package com.aliyun.datahub.client.model.protobuf;

import com.aliyun.datahub.client.http.converter.BaseProtobufModel;
import com.aliyun.datahub.client.http.converter.batch.BatchUtil;
import com.aliyun.datahub.client.model.GetRecordsResult;
import com.aliyun.datahub.client.model.RecordEntry;
import com.aliyun.datahub.client.model.RecordRespMeta;
import com.aliyun.datahub.client.model.RecordSchema;
import com.google.protobuf.Message;

import java.util.ArrayList;
import java.util.List;

import static com.aliyun.datahub.client.http.common.Constants.CONTENT_BINARY;

public class GetBatchRecordsResultPB extends GetRecordsResult implements BaseProtobufModel {
    private DatahubProtos.GetBinaryRecordsResponse proto;
    private RecordSchema schema;
    private String shardId;

    @Override
    public String getNextCursor() {
        return proto.getNextCursor();
    }

    @Override
    public int getRecordCount() {
        return proto.getRecordCount();
    }

    @Override
    public long getStartSequence() {
        return proto.getStartSequence();
    }

    @Override
    public long getLatestSequence() {
        return this.proto.getLatestSequence();
    }

    @Override
    public long getLatestTime() {
        return this.proto.getLatestTime();
    }

    @Override
    public synchronized List<RecordEntry> getRecords() {
        if (records == null) {
            records = new ArrayList<>();
            for (DatahubProtos.BinaryRecordEntry entry : proto.getRecordsList()) {
                records.addAll(convertFromBatchRecord(entry));
            }
        }
        return records;
    }

    public void internalSetSchema(RecordSchema schema) {
        this.schema = schema;
    }

    public void internalSetShardId(String shardId) {
        this.shardId = shardId;
    }

    @Override
    public String getContentType() {
        return CONTENT_BINARY;
    }

    @Override
    public Message getMessage() {
        return null;
    }

    @Override
    public void setMessage(Message message) {
        this.proto = (DatahubProtos.GetBinaryRecordsResponse) message;
    }

    private List<RecordEntry> convertFromBatchRecord(DatahubProtos.BinaryRecordEntry binaryRecordPB) {
        byte[] data = binaryRecordPB.getData().toByteArray();
        RecordRespMeta respMeta = new RecordRespMeta() {{
            setCursor(binaryRecordPB.getCursor());
            setNextCursor(binaryRecordPB.getNextCursor());
            setSequence(binaryRecordPB.getSequence());
            setSystemTime(binaryRecordPB.getSystemTime());
            setLatestSequence(getLatestSequence());
            setLatestTime(getLatestTime());
        }};
        return BatchUtil.deserialize(data, respMeta, this.schema);
    }

    public static Message.Builder newBuilder() {
        return DatahubProtos.GetBinaryRecordsResponse.newBuilder();
    }

}
