package com.aliyun.datahub.client.common;

import com.aliyun.datahub.client.auth.Account;

import java.util.Objects;

public class DatahubConfig {
    /**
     * 是否开启PB传输
     */
    private boolean enableBinary = true;
    /**
     * 是否使用新的Batch传输协议
     */
    private boolean enableBatch = false;
    /**
     * 是否开启SchemaRegistry，和Batch传输协议强绑定
     */
    private boolean enableSchemaRegistry = false;
    private String endpoint;
    private Account account;

    public DatahubConfig(String endpoint, Account account) {
        this.endpoint = endpoint;
        this.account = account;
    }

    public DatahubConfig(String endpoint, Account account, boolean enableBinary) {
        this.endpoint = endpoint;
        this.account = account;
        this.enableBinary = enableBinary;
    }

    public boolean isEnableBatch() {
        return enableBatch;
    }

    public DatahubConfig setEnableBatch(boolean enableBatch) {
        this.enableBatch = enableBatch;
        return this;
    }

    public boolean isEnableBinary() {
        return enableBinary;
    }

    public DatahubConfig setEnableBinary(boolean enableBinary) {
        this.enableBinary = enableBinary;
        return this;
    }

    public String getEndpoint() {
        return endpoint;
    }

    public DatahubConfig setEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public Account getAccount() {
        return account;
    }

    public DatahubConfig setAccount(Account account) {
        this.account = account;
        return this;
    }

    public boolean isEnableSchemaRegistry() {
        return enableSchemaRegistry;
    }

    public DatahubConfig setEnableSchemaRegistry(boolean enableSchemaRegistry) {
        this.enableSchemaRegistry = enableSchemaRegistry;
        if (enableSchemaRegistry) {
            this.enableBatch = true;
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof DatahubConfig)) return false;
        DatahubConfig that = (DatahubConfig) o;
        return enableBinary == that.enableBinary &&
                enableBatch == that.enableBatch &&
                enableSchemaRegistry == that.enableSchemaRegistry &&
                Objects.equals(endpoint, that.endpoint) &&
                Objects.equals(account, that.account);
    }

    @Override
    public int hashCode() {
        return Objects.hash(enableBinary, enableBatch, enableSchemaRegistry, endpoint, account);
    }
}
