package com.aliyun.datahub.client.common;

import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;

public abstract class ForkJoinPoolFactory {
    private static ForkJoinPool.ForkJoinWorkerThreadFactory getFactory(String threadName) {
        ForkJoinPool.ForkJoinWorkerThreadFactory factory = new ForkJoinPool.ForkJoinWorkerThreadFactory() {
            @Override
            public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
                final ForkJoinWorkerThread worker = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
                worker.setName(threadName + "-" + worker.getPoolIndex());
                return worker;
            }
        };
        return factory;
    }

    public static ForkJoinPool getPool(int parallelism, String threadName) {
        ForkJoinPool.ForkJoinWorkerThreadFactory factory = getFactory(threadName);
        return new ForkJoinPool(
                parallelism,
                factory,
                null,
                false);
    }
}
