package com.aliyun.datahub.client.example.examples;

import com.aliyun.datahub.client.DatahubClient;
import com.aliyun.datahub.client.DatahubClientBuilder;
import com.aliyun.datahub.client.auth.AliyunAccount;
import com.aliyun.datahub.client.common.DatahubConfig;
import com.aliyun.datahub.client.exception.AuthorizationFailureException;
import com.aliyun.datahub.client.exception.DatahubClientException;
import com.aliyun.datahub.client.exception.InvalidParameterException;
import com.aliyun.datahub.client.exception.ResourceNotFoundException;
import com.aliyun.datahub.client.model.ListShardResult;
import com.aliyun.datahub.client.model.MergeShardResult;
import com.aliyun.datahub.client.model.ShardEntry;
import com.aliyun.datahub.client.model.SplitShardResult;

public class ShardExample {
    private static DatahubClient datahubClient;


    public static void init() {
        // 创建DataHubClient实例
        datahubClient = DatahubClientBuilder.newBuilder()
                .setDatahubConfig(
                        new DatahubConfig(Constant.endpoint,
                                // 是否开启二进制传输，服务端2.12版本开始支持
                                new AliyunAccount(Constant.accessId, Constant.accessKey), true))
                .build();

    }

    public static void listShard() {
        try {
            ListShardResult listShardResult = datahubClient.listShard(Constant.projectName, Constant.topicName);
            if (listShardResult.getShards().size() > 0) {
                for (ShardEntry entry : listShardResult.getShards()) {
                    System.out.println(entry.getShardId() + "\t"
                            + entry.getState() + "\t"
                            + entry.getLeftShardId() + "\t"
                            + entry.getRightShardId() + "\t"
                            + entry.getAddress());
                }
            }
        } catch (InvalidParameterException e) {
            // invalid parameter, please check your parameter
            e.printStackTrace();
            throw e;
        } catch (AuthorizationFailureException e) {
            // AK error, please check your accessId and accessKey
            e.printStackTrace();
            throw e;
        } catch (ResourceNotFoundException e) {
            // project or topic not found
            e.printStackTrace();
            throw e;
        } catch (DatahubClientException e) {
            // other error
            e.printStackTrace();
            throw e;
        }
    }

    public static void splitShard() {
        try {
            String shardId = "0";
            SplitShardResult splitShardResult = datahubClient.splitShard(Constant.projectName, Constant.topicName, shardId);
            for (ShardEntry entry : splitShardResult.getNewShards()) {
                System.out.println(entry.getShardId());
            }
        } catch (InvalidParameterException e) {
            // invalid parameter, please check your parameter
            e.printStackTrace();
            throw e;
        } catch (AuthorizationFailureException e) {
            // AK error, please check your accessId and accessKey
            e.printStackTrace();
            throw e;
        } catch (ResourceNotFoundException e) {
            // project or topic not found
            e.printStackTrace();
            throw e;
        } catch (DatahubClientException e) {
            // other error
            e.printStackTrace();
            throw e;
        }
    }

    public static void mergeShard() {

        try {
            String shardId = "0";
            //adjacentShardId位置必须和shardId相邻，shard相邻信息可在listShard返回结果中查看
            String adjacentShardId = "1";
            MergeShardResult mergeShardResult = datahubClient.mergeShard(Constant.projectName, Constant.topicName, shardId, adjacentShardId);
            System.out.println("merge successful");
            System.out.println(mergeShardResult.getShardId());
        } catch (InvalidParameterException e) {
            // invalid parameter, please check your parameter
            e.printStackTrace();
            throw e;
        } catch (AuthorizationFailureException e) {
            // AK error, please check your accessId and accessKey
            e.printStackTrace();
            throw e;
        } catch (ResourceNotFoundException e) {
            // project or topic not found
            e.printStackTrace();
            throw e;
        } catch (DatahubClientException e) {
            // other error
            e.printStackTrace();
            throw e;
        }
    }

    public static void main(String[] args) {
        init();

        listShard();

//        splitShard();
//
        mergeShard();
    }

}
