package com.aliyun.datahub.client.exception;

import com.aliyun.datahub.client.common.DatahubConstant;

public class DatahubClientException extends RuntimeException {
    private int httpStatus = DatahubConstant.DEFAULT_CLIENT_ERROR_STATUS;
    private String requestId;
    private String traceId;
    private String errorCode;
    private String errorMessage;

    public DatahubClientException(String message, Throwable cause) {
        super(message, cause);
        this.errorMessage = message;
    }

    public DatahubClientException(String message) {
        this(message, null);
    }

    public DatahubClientException(String requestId, String errorCode, String errorMessage) {
        super(errorMessage, null);
        this.requestId = requestId;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public DatahubClientException(int httpStatus, String requestId, String errorCode, String errorMessage, Throwable cause) {
        this(httpStatus, requestId, null, errorCode, errorMessage, cause);
    }

    public DatahubClientException(int httpStatus, String requestId, String traceId, String errorCode, String errorMessage, Throwable cause) {
        super(errorMessage, cause);
        this.httpStatus = httpStatus;
        this.requestId = requestId;
        this.traceId = traceId;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public DatahubClientException(int httpStatus, String requestId, String traceId, String errorCode, String errorMessage) {
        this(httpStatus, requestId, traceId, errorCode, errorMessage, null);
    }

    public DatahubClientException(DatahubClientException ex) {
        this(ex.getHttpStatus(), ex.getRequestId(), ex.getTraceId(), ex.getErrorCode(), ex.getErrorMessage());
    }

    public void setHttpStatus(int httpStatus) {
        if (httpStatus != DatahubConstant.DEFAULT_CLIENT_ERROR_STATUS) {
            this.httpStatus = httpStatus;
        }
    }

    public int getHttpStatus() {
        return httpStatus;
    }

    public String getRequestId() {
        return requestId;
    }

    public String getTraceId() {
        return traceId;
    }

    public String getErrorCode() {
        return errorCode;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    @Override
    public String getMessage() {
        return "[httpStatus:" + httpStatus + ", requestId:" +
                requestId + ", traceId:" + traceId + ", errorCode:" + errorCode +
                ", errorMessage:" + errorMessage + "]";
    }
}