package com.aliyun.datahub.client.http;

import com.aliyun.datahub.client.model.CompressType;

import java.util.Map;
import java.util.Objects;

public class HttpConfig {
    private int readTimeout = 30000;
    private int connTimeout = 30000;
    private int maxRetryCount = 1;
    private int retryIntervalMs = 1000;

    /**
     * 是否开启Http2.0传输
     */
    private boolean enableH2C = false;
    /**
     * 是否开启request debug，一般json才用
     */
    private boolean debugRequest = false;
    /**
     * http传输是否压缩，非data压缩
     */
    private CompressType compressType = CompressType.NONE;

    private String proxyUri;
    private String proxyUsername;
    private String proxyPassword;

    private String networkInterface;

    private Map<String, String> userHeader;

    public int getReadTimeout() {
        return readTimeout;
    }

    public HttpConfig setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public int getConnTimeout() {
        return connTimeout;
    }

    public HttpConfig setConnTimeout(int connTimeout) {
        this.connTimeout = connTimeout;
        return this;
    }

    public int getMaxRetryCount() {
        return maxRetryCount;
    }

    public HttpConfig setMaxRetryCount(int maxRetryCount) {
        this.maxRetryCount = maxRetryCount;
        return this;
    }

    public int getRetryIntervalMs() {
        return retryIntervalMs;
    }

    public HttpConfig setRetryIntervalMs(int retryIntervalMs) {
        this.retryIntervalMs = retryIntervalMs;
        return this;
    }

    public boolean isDebugRequest() {
        return debugRequest;
    }

    public HttpConfig setDebugRequest(boolean debugRequest) {
        this.debugRequest = debugRequest;
        return this;
    }

    public boolean isEnableH2C() {
        return enableH2C;
    }

    public HttpConfig setEnableH2C(boolean enableH2C) {
        this.enableH2C = enableH2C;
        return this;
    }

    public CompressType getCompressType() {
        return compressType;
    }

    public HttpConfig setCompressType(CompressType compressType) {
        this.compressType = compressType;
        return this;
    }

    public String getProxyUri() {
        return proxyUri;
    }

    public HttpConfig setProxyUri(String proxyUri) {
        this.proxyUri = proxyUri;
        return this;
    }

    public String getProxyUsername() {
        return proxyUsername;
    }

    public HttpConfig setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
        return this;
    }

    public String getProxyPassword() {
        return proxyPassword;
    }

    public HttpConfig setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
        return this;
    }

    public String getNetworkInterface() {
        return networkInterface;
    }

    public HttpConfig setNetworkInterface(String networkInterface) {
        this.networkInterface = networkInterface;
        return this;
    }

    public Map<String, String> getUserHeader() {
        return userHeader;
    }

    public HttpConfig setUserHeader(Map<String, String> userHeader) {
        this.userHeader = userHeader;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        HttpConfig that = (HttpConfig) o;
        return readTimeout == that.readTimeout &&
                connTimeout == that.connTimeout &&
                enableH2C == that.enableH2C &&
                debugRequest == that.debugRequest &&
                compressType == that.compressType &&
                Objects.equals(proxyUri, that.proxyUri) &&
                Objects.equals(proxyUsername, that.proxyUsername) &&
                Objects.equals(proxyPassword, that.proxyPassword) &&
                Objects.equals(networkInterface, that.networkInterface);
    }

    @Override
    public int hashCode() {
        return Objects.hash(readTimeout, connTimeout, enableH2C, debugRequest, compressType, proxyUri, proxyUsername, proxyPassword, networkInterface);
    }

    public HttpConfig deepCopy() {
        HttpConfig newConfig = new HttpConfig();
        newConfig.setConnTimeout(this.connTimeout);
        newConfig.setReadTimeout(this.readTimeout);
        newConfig.setMaxRetryCount(this.maxRetryCount);
        newConfig.setRetryIntervalMs(this.retryIntervalMs);
        newConfig.setDebugRequest(this.debugRequest);
        newConfig.setEnableH2C(this.enableH2C);
        newConfig.setNetworkInterface(this.networkInterface);
        newConfig.setProxyPassword(this.proxyPassword);
        newConfig.setProxyUri(this.proxyUri);
        newConfig.setProxyUsername(this.proxyUsername);
        newConfig.setCompressType(this.compressType);
        return newConfig;
    }
}
