package com.aliyun.datahub.client.http.converter.batch;

import com.aliyun.datahub.client.common.ForkJoinPoolFactory;

import java.util.concurrent.ForkJoinPool;

public abstract class BatchSerializePool {
    private static final int DEFAULT_READ_PARALLELISM = 8;
    private static ForkJoinPool writePool = null;
    private static ForkJoinPool readPool = ForkJoinPoolFactory.getPool(DEFAULT_READ_PARALLELISM, "batch-read-pool");

    public static void initReadPool(int parallelism) {
        if (parallelism > 1) {
            readPool = ForkJoinPoolFactory.getPool(parallelism, "batch-read-pool");
        } else {
            readPool = null;
        }
    }

    public static void initWritePool(int parallelism) {
        if (parallelism > 1) {
            writePool = ForkJoinPoolFactory.getPool(parallelism, "batch-write-pool");
        }
    }

    public static ForkJoinPool getWritePool() {
        return writePool;
    }

    public static ForkJoinPool getReadPool() {
        return readPool;
    }
}
