package com.aliyun.datahub.client.impl.interceptor;

import com.aliyun.datahub.client.auth.Account;
import com.aliyun.datahub.client.common.DatahubConstant;
import com.aliyun.datahub.client.common.DateFormat;
import com.aliyun.datahub.client.common.HttpHeaders;
import com.aliyun.datahub.client.http.interceptor.AuthInterceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.Set;

public class DatahubAuthInterceptor extends AuthInterceptor {
    private Map<String, String> userHeader;

    public DatahubAuthInterceptor(Account account, Map<String, String> userHeader) {
        super(account);
        this.userHeader = userHeader;
    }

    @Override
    public Response intercept(Chain chain) throws IOException {
        Request request = chain.request();
        Request.Builder reqBuilder = request.newBuilder();
        addEssentialHeaders(request, reqBuilder);
        return chain.proceed(reqBuilder.build());
    }

    private void addEssentialHeaders(Request request, Request.Builder reqBuilder) {
        Set<String> headerNames = request.headers().names();
        if (!headerNames.contains(DatahubConstant.X_DATAHUB_CLIENT_VERSION)) {
            reqBuilder.addHeader(DatahubConstant.X_DATAHUB_CLIENT_VERSION, DatahubConstant.DATAHUB_CLIENT_VERSION_1);
        }

        if (!headerNames.contains(HttpHeaders.DATE)) {
            reqBuilder.addHeader(HttpHeaders.DATE, DateFormat.getDateTimeFormat().format(new Date()));
        }

        if (userHeader != null) {
            for (Map.Entry<String, String> entry : userHeader.entrySet()) {
                if (!headerNames.contains(entry.getKey())) {
                    reqBuilder.addHeader(entry.getKey(), entry.getValue());
                }
            }
        }

        // as auth with Content-Type, here get it for signature
        RequestBody body = request.body();
        if (body != null) {
            MediaType contentType = body.contentType();
            if (contentType != null) {
                reqBuilder.addHeader(HttpHeaders.CONTENT_TYPE, contentType.toString());
            }
        }

        // add authorization related headers
        account.addAuthHeaders(reqBuilder);
    }
}
