package com.aliyun.datahub.client.impl.request;

import com.fasterxml.jackson.annotation.JsonProperty;

public class ExtendShardRequest extends BaseRequest {
    public enum ExtendMode {
        /**
         * The ShardNumber is Increased number
         */
        INC,

        /**
         * The ShardNumber is target number
         */
        TO
    }

    public ExtendShardRequest() {
        setAction("extend");
    }

    @JsonProperty("ShardNumber")
    private int shardCount;

    @JsonProperty("ExtendMode")
    private ExtendMode extendMode;

    public int getShardCount() {
        return shardCount;
    }

    public ExtendShardRequest setShardCount(int shardCount) {
        this.shardCount = shardCount;
        return this;
    }

    public ExtendMode getExtendMode() {
        return extendMode;
    }

    public ExtendShardRequest setExtendMode(ExtendMode extendMode) {
        this.extendMode = extendMode;
        return this;
    }
}

