package com.aliyun.datahub.client.impl.request.protobuf;

import com.aliyun.datahub.client.http.converter.BaseProtobufModel;
import com.aliyun.datahub.client.model.protobuf.DatahubProtos;
import com.google.protobuf.Message;

import static com.aliyun.datahub.client.http.common.Constants.CONTENT_PROTOBUF;

public class GetRecordsRequestPB implements BaseProtobufModel {
    private DatahubProtos.GetRecordsRequest.Builder builder = DatahubProtos.GetRecordsRequest.newBuilder();

    public GetRecordsRequestPB setCursor(String cursor) {
        builder.setCursor(cursor);
        return this;
    }

    public GetRecordsRequestPB setLimit(int limit) {
        builder.setLimit(limit);
        return this;
    }

    public GetRecordsRequestPB setFilter(String filter) {
        builder.setFilter(filter);
        return this;
    }

    @Override
    public Message getMessage() {
        return builder.build();
    }

    @Override
    public void setMessage(Message message) {
    }

    @Override
    public String getContentType() {
        return CONTENT_PROTOBUF;
    }
}
