package com.aliyun.datahub.client.impl.request.protobuf;

import com.aliyun.datahub.client.http.converter.BaseProtobufModel;
import com.aliyun.datahub.client.http.converter.batch.BatchSerializer;
import com.aliyun.datahub.client.model.RecordEntry;
import com.aliyun.datahub.client.model.protobuf.DatahubProtos;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;

import java.util.List;

import static com.aliyun.datahub.client.http.common.Constants.CONTENT_BINARY;

public class PutBatchRecordsRequestPB implements BaseProtobufModel {
    private DatahubProtos.PutBinaryRecordsRequest.Builder reqBuilder = DatahubProtos.PutBinaryRecordsRequest.newBuilder();
    private BatchSerializer serializer;

    public PutBatchRecordsRequestPB() {
    }

    public PutBatchRecordsRequestPB setSerializer(BatchSerializer serializer) {
        this.serializer = serializer;
        return this;
    }

    public PutBatchRecordsRequestPB setRecords(List<RecordEntry> records) {
        byte[] batchBuffer = serializer.serialize(records);
        DatahubProtos.BinaryRecordEntry.Builder recordBuilder = DatahubProtos.BinaryRecordEntry.newBuilder();
        recordBuilder.setData(ByteString.copyFrom(batchBuffer));
        reqBuilder.addRecords(recordBuilder.build());
        return this;
    }

    @Override
    public Message getMessage() {
        return reqBuilder.build();
    }

    @Override
    public void setMessage(Message message) {
    }

    @Override
    public String getContentType() {
        return CONTENT_BINARY;
    }
}
