package com.aliyun.datahub.client.impl.schemaregistry;

import com.aliyun.datahub.client.impl.AbstractDatahubClient;

import java.util.HashMap;
import java.util.Map;

public abstract class SchemaRegistryHolder {
    private static final Map<String, SchemaRegistryClient> CLIENT_MAP = new HashMap<>();

    public static SchemaRegistryClient createClient(String endpoint, AbstractDatahubClient client) {
        SchemaRegistryClient schemaRegistryClient = CLIENT_MAP.get(endpoint);
        if (schemaRegistryClient == null) {
            synchronized (SchemaRegistryHolder.class) {
                schemaRegistryClient = CLIENT_MAP.get(endpoint);
                if (schemaRegistryClient == null) {
                    schemaRegistryClient = new SchemaRegistryClientImpl(client);
                    CLIENT_MAP.put(endpoint, schemaRegistryClient);
                }
            }
        }
        return schemaRegistryClient;
    }

}
