package com.aliyun.datahub.client.model;

public class BlobRecordData extends RecordData {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    /**
     * Binary data used to store BLOB data.
     */
    private byte[] data;

    public BlobRecordData(byte[] data) {
        if (data != null) {
            this.data = data;
        } else {
            this.data = EMPTY_BYTE_ARRAY;
        }
    }

    public byte[] getData() {
        return data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    @Override
    public int getDataSize() {
        return data == null ? 0 : data.length;
    }
}
