package com.aliyun.datahub.client.model;

public enum CompressType {
    /**
     * No Compress
     */
    NONE(0, "none"),

    /**
     * DEFLATE Compress
     */
    DEFLATE(1, "deflate"),

    /**
     * LZ4 Compress
     */
    LZ4(2, "lz4");

    private int value;
    private String name;

    CompressType(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return value;
    }

    public String getName() { return name; }

    public static CompressType fromValue(int value) {
        for (CompressType type : CompressType.values()) {
            if (type.value == value) {
                return type;
            }
        }
        return NONE;
    }
}
