package com.aliyun.datahub.client.model;

import com.fasterxml.jackson.annotation.JsonValue;

public enum ExpandMode {
    /**
     * default expand mode, allow split/merge/extend shard
     */
    SPLIT_EXTEND(""),

    /**
     * only allow split/merge shard
     */
    ONLY_SPLIT("split"),

    /**
     * only allow extend shard, adopt to kafka api
     */
    ONLY_EXTEND("extend");

    private final String value;

    ExpandMode(final String description) {
        this.value = description;
    }

    @JsonValue
    final String value() {
        return this.value;

    }
}
