package com.aliyun.datahub.client.model;

import java.util.Objects;

public class Field {
    private String name;
    private FieldType type;
    private boolean allowNull;
    private String comment;

    public Field() {
        this.name = null;
        this.type = null;
    }

    public Field(String name, FieldType type) {
        this (name, type, true, "");
    }

    public Field(String name, FieldType type, boolean allowNull) {
        this (name, type, allowNull, "");
    }

    public Field(String name, FieldType type, String comment) {
        this (name, type, true, comment);
    }

    public Field(String name, FieldType type, boolean allowNull, String comment) {
        this.name = name.toLowerCase();
        this.type = type;
        this.allowNull = allowNull;
        this.comment = comment;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(FieldType type) {
        this.type = type;
    }

    public void setAllowNull(boolean allowNull) {
        this.allowNull = allowNull;
    }

    public String getName() {
        return name;
    }

    public FieldType getType() {
        return type;
    }

    public boolean isAllowNull() {
        return allowNull;
    }

    public String getComment() { return comment; }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Field field = (Field) o;
        return allowNull == field.allowNull &&
                Objects.equals(name, field.name) &&
                type == field.type &&
                Objects.equals(comment, field.comment);
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, type, allowNull, comment);
    }
}
