package com.aliyun.datahub.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.util.StdConverter;

import java.util.List;

@JsonDeserialize(converter = GetRecordsResult.Converter.class)
public class GetRecordsResult extends BaseResult {
    /**
     * The cursor used for the next read.
     */
    @JsonProperty("NextCursor")
    private String nextCursor;

    /**
     * Record count returned.
     */
    @JsonProperty("RecordCount")
    private int recordCount;

    /**
     * Indicate the sequence of the first record.
     */
    @JsonProperty("StartSeq")
    private long startSequence;

    /**
     * Indicate the sequence of the latest record in topic.
     */
    @JsonProperty("LatestSeq")
    private long latestSequence = -1;

    /**
     * Indicate the sequence of the latest record time(ms) in topic.
     */
    @JsonProperty("LatestTime")
    private long latestTime = -1;

    /**
     * RecordEntity list. You can get detail information by iterator it.
     */
    @JsonProperty("Records")
    protected List<RecordEntry> records;

    public String getNextCursor() {
        return nextCursor;
    }

    public void setNextCursor(String nextCursor) {
        this.nextCursor = nextCursor;
    }

    public int getRecordCount() {
        return recordCount;
    }

    public void setRecordCount(int recordCount) {
        this.recordCount = recordCount;
    }

    public long getStartSequence() {
        return startSequence;
    }

    public void setStartSequence(long startSequence) {
        this.startSequence = startSequence;
    }

    public long getLatestSequence() {
        return latestSequence;
    }

    public void setLatestSequence(long latestSequence) {
        this.latestSequence = latestSequence;
    }

    public long getLatestTime() {
        return latestTime;
    }

    public void setLatestTime(long latestTime) {
        this.latestTime = latestTime;
    }

    public List<RecordEntry> getRecords() {
        return records;
    }

    public void setRecords(List<RecordEntry> records) {
        this.records = records;
    }

    static class Converter extends StdConverter<GetRecordsResult, GetRecordsResult> {

        @Override
        public GetRecordsResult convert(GetRecordsResult getRecordsResult) {
            for (RecordEntry recordEntry : getRecordsResult.getRecords()) {
                recordEntry.setLatestSequence(getRecordsResult.latestSequence);
                recordEntry.setLatestTime(getRecordsResult.latestTime);
            }
            return getRecordsResult;
        }
    }
}
