package com.aliyun.datahub.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public class RecordRespMeta {
    @JsonProperty("Cursor")
    private String cursor;

    @JsonProperty("NextCursor")
    private String nextCursor;

    private long serial = 0;
    private long systemTime;
    private long sequence = -1;
    private long latestSequence = -1;
    private long latestTime = -1;

    private int schemaVersionId = -1;
    private int segmentSizeForBatch = 0;
    private int segmentIndexForBatch = 0;

    @JsonIgnore
    public long getSerial() {
        return serial;
    }

    @JsonProperty("Serial")
    public void setSerial(long serial) {
        this.serial = serial;
    }

    @JsonIgnore
    public long getSystemTime() {
        return systemTime;
    }

    @JsonProperty("SystemTime")
    public void setSystemTime(long systemTime) {
        this.systemTime = systemTime;
    }

    @JsonIgnore
    public long getSequence() {
        return sequence;
    }

    @JsonProperty("Sequence")
    public void setSequence(long sequence) {
        this.sequence = sequence;
    }

    @JsonIgnore
    public long getLatestSequence() {
        return latestSequence;
    }

    public void setLatestSequence(long latestSequence) {
        this.latestSequence = latestSequence;
    }

    @JsonIgnore
    public long getLatestTime() {
        return latestTime;
    }

    public void setLatestTime(long latestTime) {
        this.latestTime = latestTime;
    }

    public String getCursor() {
        return cursor;
    }

    public void setCursor(String cursor) {
        this.cursor = cursor;
    }

    public String getNextCursor() {
        return nextCursor;
    }

    public void setNextCursor(String nextCursor) {
        this.nextCursor = nextCursor;
    }

    public void innerSetSegmentInfo(int versionId, int segSize, int segIndex) {
        this.schemaVersionId = versionId;
        this.segmentSizeForBatch = segSize;
        this.segmentIndexForBatch = segIndex;
    }

    @JsonIgnore
    public int getSegmentSizeForBatch() {
        return segmentSizeForBatch;
    }

    @JsonIgnore
    public int getSegmentIndexForBatch() {
        return segmentIndexForBatch;
    }

    @JsonIgnore
    public int getSchemaVersionId() {
        return schemaVersionId;
    }
}
