package com.aliyun.datahub.client.model.protobuf;

import com.aliyun.datahub.client.http.converter.BaseProtobufModel;
import com.aliyun.datahub.client.http.converter.batch.BatchDeserializer;
import com.aliyun.datahub.client.http.converter.batch.BatchSerializePool;
import com.aliyun.datahub.client.model.GetRecordsResult;
import com.aliyun.datahub.client.model.RecordEntry;
import com.aliyun.datahub.client.model.RecordRespMeta;
import com.google.protobuf.Message;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Collectors;

import static com.aliyun.datahub.client.http.common.Constants.CONTENT_BINARY;

public class GetBatchRecordsResultPB extends GetRecordsResult implements BaseProtobufModel {
    private BatchDeserializer deserializer;
    private DatahubProtos.GetBinaryRecordsResponse proto;
    private String shardId;

    public void setDeserializer(BatchDeserializer deserializer) {
        this.deserializer = deserializer;
    }

    public static Message.Builder newBuilder() {
        return DatahubProtos.GetBinaryRecordsResponse.newBuilder();
    }

    private List<RecordEntry> convertFromBatchRecord(DatahubProtos.BinaryRecordEntry binaryRecordPB) {
        byte[] data = binaryRecordPB.getData().toByteArray();
        RecordRespMeta respMeta = new RecordRespMeta() {{
            setCursor(binaryRecordPB.getCursor());
            setNextCursor(binaryRecordPB.getNextCursor());
            setSequence(binaryRecordPB.getSequence());
            setSystemTime(binaryRecordPB.getSystemTime());
        }};
        respMeta.setLatestSequence(getLatestSequence());
        respMeta.setLatestTime(getLatestTime());

        return this.deserializer.deserialize(data, respMeta, this.shardId);
    }

    public void internalSetShardId(String shardId) {
        this.shardId = shardId;
    }

    @Override
    public String getNextCursor() {
        return proto.getNextCursor();
    }

    @Override
    public int getRecordCount() {
        List<RecordEntry> records = getRecords();
        return records.size();
    }

    @Override
    public long getStartSequence() {
        return proto.getStartSequence();
    }

    @Override
    public long getLatestSequence() {
        return this.proto.getLatestSequence();
    }

    @Override
    public long getLatestTime() {
        return this.proto.getLatestTime();
    }

    @Override
    public synchronized List<RecordEntry> getRecords() {
        if (records == null) {
            records = new ArrayList<>();

            List<List<RecordEntry>> result;
            ForkJoinPool pool = BatchSerializePool.getReadPool();
            if (pool == null) {
                result =  proto.getRecordsList().stream().map(this::convertFromBatchRecord).collect(Collectors.toList());
            } else {
                result = pool.submit(() -> proto.getRecordsList().parallelStream().map(this::convertFromBatchRecord).collect(Collectors.toList())).join();
            }

            for (List<RecordEntry> list : result) {
                records.addAll(list);
            }
        }
        return records;
    }

    @Override
    public String getContentType() {
        return CONTENT_BINARY;
    }

    @Override
    public Message getMessage() {
        return null;
    }

    @Override
    public void setMessage(Message message) {
        this.proto = (DatahubProtos.GetBinaryRecordsResponse) message;
    }
}
