package com.aliyun.datahub.client.model.protobuf;

import com.aliyun.datahub.client.exception.MalformedRecordException;
import com.aliyun.datahub.client.http.converter.BaseProtobufModel;
import com.aliyun.datahub.client.model.*;
import com.google.protobuf.Message;
import org.apache.commons.codec.Charsets;

import java.util.ArrayList;
import java.util.List;

import static com.aliyun.datahub.client.http.common.Constants.CONTENT_PROTOBUF;

public class GetRecordsResultPB extends GetRecordsResult implements BaseProtobufModel {
    private DatahubProtos.GetRecordsResponse proto;
    private RecordSchema schema;
    private String shardId;

    @Override
    public Message getMessage() {
        return null;
    }

    @Override
    public void setMessage(Message message) {
        this.proto = (DatahubProtos.GetRecordsResponse) message;
    }

    @Override
    public String getNextCursor() {
        return this.proto.getNextCursor();
    }

    @Override
    public int getRecordCount() {
        return this.proto.getRecordCount();
    }

    @Override
    public long getStartSequence() {
        return this.proto.getStartSequence();
    }

    @Override
    public long getLatestSequence() {
        return this.proto.getLatestSequence();
    }

    @Override
    public long getLatestTime() {
        return this.proto.getLatestTime();
    }

    @Override
    public synchronized List<RecordEntry> getRecords() {
        if (records == null) {
            records = new ArrayList<>();
            for (DatahubProtos.RecordEntry entry : proto.getRecordsList()) {
                records.add(convertFromProtoFormat(entry));
            }
        }
        return records;
    }

    public void internalSetSchema(RecordSchema schema) {
        this.schema = schema;
    }

    public void internalSetShardId(String shardId) {
        this.shardId = shardId;
    }

    private RecordEntry convertFromProtoFormat(DatahubProtos.RecordEntry recordEntry) {
        RecordEntry entry = new RecordEntry();
        entry.setShardId(recordEntry.hasShardId() ? recordEntry.getShardId() : this.shardId);
        entry.setHashKey(recordEntry.getHashKey());
        entry.setPartitionKey(recordEntry.getPartitionKey());
        entry.setCursor(recordEntry.getCursor());
        entry.setNextCursor(recordEntry.getNextCursor());
        entry.setSequence(recordEntry.getSequence());
        entry.setSystemTime(recordEntry.getSystemTime());
        entry.setSerial(recordEntry.getSerial());
        entry.setLatestSequence(getLatestSequence());
        entry.setLatestTime(getLatestTime());
        if (recordEntry.hasAttributes()) {
            for (DatahubProtos.StringPair strPair : recordEntry.getAttributes().getAttributesList()) {
                entry.addAttribute(strPair.getKey(), strPair.getValue());
            }
        }
        entry.setRecordData(convertDataFromPb(recordEntry));
        return entry;
    }

    private RecordData convertDataFromPb(DatahubProtos.RecordEntry recordEntry) {
        if (this.schema == null) {
            if (recordEntry.getData().getDataList().size() != 1) {
                throw new MalformedRecordException("Blob record field data size is error");
            }
            DatahubProtos.FieldData fieldData = recordEntry.getData().getData(0);
            return new BlobRecordData(fieldData.getValue().toByteArray());
        }

        TupleRecordData tupleRecordData = new TupleRecordData(recordEntry.getData().getDataList().size());
        for (DatahubProtos.FieldData fieldData : recordEntry.getData().getDataList()) {
            tupleRecordData.internalAddValue(fieldData.hasValue() ? new String(fieldData.getValue().toByteArray(), Charsets.UTF_8) : null);
        }
        tupleRecordData.internalConvertAuxValues(schema);
        return tupleRecordData;
    }

    public static Message.Builder newBuilder() {
        return DatahubProtos.GetRecordsResponse.newBuilder();
    }

    @Override
    public String getContentType() {
        return CONTENT_PROTOBUF;
    }
}
