package com.aliyun.datahub.client.model.protobuf;

import com.aliyun.datahub.client.model.*;
import com.google.protobuf.ByteString;
import org.apache.commons.codec.Charsets;

import java.math.BigDecimal;
import java.util.Map;

public class RecordEntryPB {
    private DatahubProtos.RecordEntry.Builder builder = DatahubProtos.RecordEntry.newBuilder();

    public void setShardId(String shardId) {
        if (shardId != null) {
            this.builder.setShardId(shardId);
        }
    }

    public void setHashKey(String hashKey) {
        if (hashKey != null) {
            this.builder.setHashKey(hashKey);
        }
    }

    public void setPartitionKey(String partitionKey) {
        if (partitionKey != null) {
            this.builder.setPartitionKey(partitionKey);
        }
    }

    public void setAttributes(Map<String, String> attributes) {
        if (attributes != null) {
            DatahubProtos.RecordAttributes.Builder attrsBuilder = DatahubProtos.RecordAttributes.newBuilder();
            for (Map.Entry<String, String> stringPair : attributes.entrySet()) {
                DatahubProtos.StringPair.Builder stringPairBuilder = DatahubProtos.StringPair.newBuilder();
                stringPairBuilder.setKey(stringPair.getKey());
                stringPairBuilder.setValue(stringPair.getValue());
                attrsBuilder.addAttributes(stringPairBuilder.build());
            }
            this.builder.setAttributes(attrsBuilder.build());
        }
    }

    public void setRecordData(RecordData recordData) {
        if (recordData != null) {
            DatahubProtos.RecordData.Builder dataBuilder = DatahubProtos.RecordData.newBuilder();

            if (recordData instanceof TupleRecordData) {
                TupleRecordData data = (TupleRecordData) recordData;
                for (Field field : data.getRecordSchema().getFields()) {
                    DatahubProtos.FieldData.Builder fieldBuilder = DatahubProtos.FieldData.newBuilder();
                    Object value = data.getField(field.getName());
                    if (value != null) {
                        if (field.getType() == FieldType.DECIMAL) {
                            fieldBuilder.setValue(ByteString.copyFrom(((BigDecimal)value).toPlainString().getBytes(Charsets.UTF_8)));
                        } else {
                            fieldBuilder.setValue(ByteString.copyFrom(value.toString().getBytes(Charsets.UTF_8)));
                        }
                    }
                    dataBuilder.addData(fieldBuilder.build());
                }
            } else {
                BlobRecordData data = (BlobRecordData) recordData;
                DatahubProtos.FieldData.Builder fieldBuilder = DatahubProtos.FieldData.newBuilder();
                fieldBuilder.setValue(ByteString.copyFrom(data.getData()));
                dataBuilder.addData(fieldBuilder.build());
            }

            this.builder.setData(dataBuilder.build());
        }
    }

    public DatahubProtos.RecordEntry getProto() {
        return this.builder.build();
    }
}