package com.aliyun.datahub.client.util;

import com.aliyun.datahub.client.exception.InvalidParameterException;

import java.math.BigDecimal;

public abstract class ValueCheckUtils {
    private static final long MIN_TIMESTAMP = -62135798400000000L; // 0000-00-00 00:00:00
    private static final long MAX_TIMESTAMP = 253402271999000000L; // 9999-12-31 23:59:59
    public static boolean checkString(Object value) {
        return (value instanceof String);
    }

    public static boolean checkTinyInt(Object value) {
        return (value instanceof Byte) ||
                (value instanceof Integer && (Integer) value <= Byte.MAX_VALUE && (Integer) value >= Byte.MIN_VALUE) ||
                (value instanceof Long && (Long) value <= Byte.MAX_VALUE && (Long) value >= Byte.MIN_VALUE);
    }

    public static boolean checkSmallInt(Object value) {
        return (value instanceof Short) ||
                (value instanceof Integer && (Integer) value <= Short.MAX_VALUE && (Integer) value >= Short.MIN_VALUE) ||
                (value instanceof Long && (Long) value <= Short.MAX_VALUE && (Long) value >= Short.MIN_VALUE);
    }

    public static boolean checkInteger(Object value) {
        return (value instanceof Integer) ||
                (value instanceof Long && (Long) value <= Integer.MAX_VALUE && (Long) value >= Integer.MIN_VALUE);
    }

    public static boolean checkBigint(Object value) {
        return ((value instanceof Long) || (value instanceof Integer));
    }

    public static boolean checkFloat(Object value) {
        return (value instanceof Float) || (value instanceof Double);
    }

    public static boolean checkDouble(Object value) {
        return (value instanceof Double);
    }

    public static boolean checkBoolean(Object value) {
        return (value instanceof Boolean);
    }

    public static boolean checkTimestamp(Object value) {
        boolean valid = checkBigint(value);
        if (valid) {
            // add timestamp range check
            long ts = (Long) value;
            if (ts < MIN_TIMESTAMP || ts > MAX_TIMESTAMP) {
                throw new InvalidParameterException("Timestamp range error. min:" + MIN_TIMESTAMP + ", max:" + MAX_TIMESTAMP);
            }
        }
        return valid;
    }

    public static boolean checkDecimal(Object value) {
        return (value instanceof BigDecimal);
    }
}
