/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.common.data;

import com.aliyun.datahub.common.data.Field;
import com.aliyun.datahub.exception.DatahubClientException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

public class RecordSchema {
    private ArrayList<Field> fields = new ArrayList();
    private HashMap<String, Integer> nameMap = new HashMap();

    public void addField(Field c) {
        if (c == null) {
            throw new IllegalArgumentException("Field is null.");
        }
        if (this.nameMap.containsKey(c.getName())) {
            throw new IllegalArgumentException("Field " + c.getName() + " duplicated.");
        }
        this.nameMap.put(c.getName(), this.fields.size());
        this.fields.add(c);
    }

    public Field getField(int idx) {
        if (idx < 0 || idx >= this.fields.size()) {
            throw new IllegalArgumentException("idx out of range");
        }
        return this.fields.get(idx);
    }

    public int getFieldIndex(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Field name is null");
        }
        Integer idx = this.nameMap.get(name.toLowerCase());
        if (idx == null) {
            throw new IllegalArgumentException("No such field:" + name);
        }
        return idx;
    }

    public Field getField(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Field name is null");
        }
        return this.fields.get(this.getFieldIndex(name.toLowerCase()));
    }

    public void setFields(List<Field> fields) {
        if (fields == null) {
            throw new IllegalArgumentException("Field list is null");
        }
        this.nameMap.clear();
        this.fields.clear();
        for (Field field : fields) {
            this.addField(field);
        }
    }

    public List<Field> getFields() {
        return (List)this.fields.clone();
    }

    public boolean containsField(String name) {
        return this.nameMap.containsKey(name.toLowerCase());
    }

    public String toJsonString() {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode schema = mapper.createObjectNode();
        if (this.fields.size() > 0) {
            ArrayNode fields = schema.putArray("fields");
            for (Field f : this.fields) {
                ObjectNode field = fields.addObject();
                field.put("type", f.getType().toString());
                field.put("name", f.getName());
                if (!f.getNotnull()) continue;
                field.put("notnull", f.getNotnull());
            }
        }
        try {
            return mapper.writeValueAsString((Object)schema);
        }
        catch (IOException e) {
            throw new DatahubClientException("serialize error", e);
        }
    }
}

