/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.common.transport;

import com.aliyun.datahub.DatahubConfiguration;
import com.aliyun.datahub.common.transport.Connection;
import com.aliyun.datahub.common.transport.DefaultRequest;
import com.aliyun.datahub.common.transport.DefaultResponse;
import com.aliyun.datahub.common.transport.HttpClient;
import com.aliyun.datahub.common.transport.Response;
import com.aliyun.datahub.common.transport.Transport;
import com.aliyun.datahub.exception.DatahubClientException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ApacheClientTransport
implements Transport {
    private static final Logger log = Logger.getLogger(ApacheClientTransport.class.getName());
    private HttpClient httpClient;
    private DatahubConfiguration conf;

    public ApacheClientTransport(DatahubConfiguration conf) {
        this.conf = conf;
        this.httpClient = new HttpClient();
        this.httpClient.setConnectionTimeout(conf.getSocketConnectTimeout() * 1000);
        this.httpClient.setSoTimeout(conf.getSocketTimeout() * 1000);
        this.httpClient.setMaxRouteConnections(conf.getConnectionsPerEndpoint());
        this.httpClient.setTotalConn(conf.getTotalConnections());
        this.httpClient.setProxyHostName(conf.getProxyHostName());
        this.httpClient.setProxyPort(conf.getProxyPort());
        this.httpClient.setProxyUsername(conf.getProxyUsername());
        this.httpClient.setProxyPassword(conf.getProxyPassword());
        try {
            this.httpClient.init();
        }
        catch (NoSuchAlgorithmException e) {
            throw new DatahubClientException("create http client error", e);
        }
        catch (KeyStoreException e) {
            throw new DatahubClientException("create http client error", e);
        }
        catch (KeyManagementException e) {
            throw new DatahubClientException("create http client error", e);
        }
    }

    @Override
    public Response request(DefaultRequest req, String endpoint) throws IOException {
        String dhEndpoint = this.conf.getEndpoint();
        if (endpoint != null && !endpoint.isEmpty()) {
            dhEndpoint = endpoint;
        }
        String url = dhEndpoint + req.getResource();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Connectiong to " + url);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Request headers: " + req.getHeaders().toString());
        }
        HttpClient.HttpResult result = null;
        switch (req.getHttpMethod()) {
            case POST: {
                result = this.httpClient.doPostWithBytes(url, req.getHeaders(), req.getBody());
                break;
            }
            case PUT: {
                result = this.httpClient.doPutWithBytes(url, req.getHeaders(), req.getBody());
                break;
            }
            case GET: {
                result = this.httpClient.doGet(url, req.getHeaders());
                break;
            }
            case DELETE: {
                result = this.httpClient.doDelete(url, req.getHeaders());
                break;
            }
            case HEAD: {
                result = this.httpClient.doHead(url, req.getHeaders());
            }
        }
        if (result == null) {
            throw new IOException("request to server failed");
        }
        DefaultResponse response = new DefaultResponse();
        response.setStatus(result.getCode());
        if (result.getHeader() != null) {
            for (Map.Entry<String, String> entry : result.getHeader().entrySet()) {
                response.setHeader(entry.getKey(), entry.getValue());
            }
        }
        response.setBody(result.getBody());
        return response;
    }

    @Override
    public Response request(DefaultRequest req) throws IOException {
        return this.request(req, null);
    }

    @Override
    public Connection connect(DefaultRequest req) throws IOException {
        throw new DatahubClientException("not implemented");
    }

    @Override
    public void close() {
        this.httpClient.shutdown();
    }
}

