/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.common.transport;

import com.aliyun.datahub.DatahubConfiguration;
import com.aliyun.datahub.common.transport.Connection;
import com.aliyun.datahub.common.transport.DefaultConnection;
import com.aliyun.datahub.common.transport.DefaultRequest;
import com.aliyun.datahub.common.transport.DefaultResponse;
import com.aliyun.datahub.common.transport.HttpMethod;
import com.aliyun.datahub.common.transport.Response;
import com.aliyun.datahub.common.transport.Transport;
import com.aliyun.datahub.common.util.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DefaultTransport
implements Transport {
    private DatahubConfiguration config;

    public DefaultTransport(DatahubConfiguration config) {
        this.config = config;
    }

    @Override
    public Connection connect(DefaultRequest req) throws IOException {
        DefaultConnection conn = new DefaultConnection(this.config);
        conn.connect(req);
        return conn;
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response request(DefaultRequest req) throws IOException {
        Connection conn = this.connect(req);
        DefaultResponse resp = null;
        try {
            if (req.getBody() != null && req.getBody().length != 0) {
                OutputStream out = conn.getOutputStream();
                IOUtils.copyLarge(new ByteArrayInputStream(req.getBody()), out);
                out.close();
            }
            resp = (DefaultResponse)conn.getResponse();
            if (HttpMethod.HEAD != req.getHttpMethod()) {
                InputStream in = conn.getInputStream();
                resp.setBody(IOUtils.readFully(in));
            }
        }
        finally {
            conn.disconnect();
        }
        return resp;
    }

    @Override
    public Response request(DefaultRequest req, String endpoint) throws IOException {
        return this.request(req);
    }
}

