/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.model;

import com.aliyun.datahub.common.util.JacksonParser;
import com.aliyun.datahub.model.OffsetContext;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ObjectNode;

public abstract class Record {
    private String partitionKey;
    private String hashKey;
    private String shardId;
    private Map<String, String> attributes = new HashMap<String, String>();
    private long systemTime;
    private long sequence;

    public abstract long getRecordSize();

    public abstract JsonNode toJsonNode();

    public abstract void clear();

    public long getSystemTime() {
        return this.systemTime;
    }

    public void setSystemTime(long systemTime) {
        this.systemTime = systemTime;
    }

    public String getShardId() {
        return this.shardId;
    }

    public void setShardId(String shardId) {
        this.shardId = shardId;
    }

    public String getPartitionKey() {
        return this.partitionKey;
    }

    public void setPartitionKey(String partitionKey) {
        this.partitionKey = partitionKey;
    }

    public String getHashKey() {
        return this.hashKey;
    }

    public void setHashKey(String hashKey) {
        this.hashKey = hashKey;
    }

    public long getSequence() {
        return this.sequence;
    }

    public void setSequence(long sequence) {
        this.sequence = sequence;
    }

    public OffsetContext.Offset getOffset() {
        return new OffsetContext.Offset(this.sequence, this.systemTime);
    }

    public Map<String, String> getAttributes() {
        return new HashMap<String, String>(this.attributes);
    }

    public void putAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    protected ObjectNode toObjectNode() {
        ObjectMapper mapper = JacksonParser.getObjectMapper();
        ObjectNode node = mapper.createObjectNode();
        if (this.shardId != null && !this.shardId.isEmpty()) {
            node.put("ShardId", this.shardId);
        } else if (this.partitionKey != null && !this.partitionKey.isEmpty()) {
            node.put("PartitionKey", this.partitionKey);
        } else if (this.hashKey != null && !this.hashKey.isEmpty()) {
            node.put("HashKey", this.hashKey);
        }
        ObjectNode attr = node.putObject("Attributes");
        for (String key : this.attributes.keySet()) {
            attr.put(key, this.attributes.get(key));
        }
        return node;
    }
}

