/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.model.serialize;

import com.aliyun.datahub.common.transport.Response;
import com.aliyun.datahub.common.util.JacksonParser;
import com.aliyun.datahub.exception.DatahubClientException;
import com.aliyun.datahub.exception.DatahubServiceException;
import com.aliyun.datahub.model.BlobRecordEntry;
import com.aliyun.datahub.model.GetBlobRecordsRequest;
import com.aliyun.datahub.model.GetBlobRecordsResult;
import com.aliyun.datahub.model.serialize.Deserializer;
import com.aliyun.datahub.model.serialize.JsonErrorParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class GetBlobRecordsResultJsonDeser
implements Deserializer<GetBlobRecordsResult, GetBlobRecordsRequest, Response> {
    private static GetBlobRecordsResultJsonDeser instance;

    @Override
    public GetBlobRecordsResult deserialize(GetBlobRecordsRequest request, Response response) throws DatahubClientException {
        if (!response.isOK()) {
            throw JsonErrorParser.getInstance().parse(response);
        }
        GetBlobRecordsResult rs = new GetBlobRecordsResult();
        ObjectMapper mapper = JacksonParser.getObjectMapper();
        JsonNode tree = null;
        try {
            tree = mapper.readTree(response.getBody());
        }
        catch (IOException e) {
            throw new DatahubServiceException("JsonParseError", "Parse body failed:" + response.getBody(), response);
        }
        rs.setNextCursor(tree.get("NextCursor").asText());
        long sequence = tree.get("StartSeq").asLong();
        rs.setStartSeq(sequence);
        JsonNode recordsNode = tree.get("Records");
        ArrayList<BlobRecordEntry> records = new ArrayList<BlobRecordEntry>();
        Iterator itRecord = recordsNode.getElements();
        while (itRecord.hasNext()) {
            BlobRecordEntry entry = new BlobRecordEntry();
            JsonNode record = (JsonNode)itRecord.next();
            JsonNode time = record.get("SystemTime");
            JsonNode data = record.get("Data");
            JsonNode attrs = record.get("Attributes");
            entry.setSequence(sequence++);
            entry.setSystemTime(time.asLong());
            entry.setShardId(request.getShardId());
            try {
                entry.setData(data.getBinaryValue());
            }
            catch (IOException e) {
                throw new DatahubClientException("Decode record data failed:" + e.getMessage(), e);
            }
            if (attrs != null && !attrs.isNull()) {
                Iterator itAttr = attrs.getFields();
                HashMap attrMap = new HashMap();
                while (itAttr.hasNext()) {
                    Map.Entry attr = (Map.Entry)itAttr.next();
                    entry.putAttribute((String)attr.getKey(), ((JsonNode)attr.getValue()).asText());
                }
            }
            records.add(entry);
        }
        rs.setRecords(records);
        return rs;
    }

    private GetBlobRecordsResultJsonDeser() {
    }

    public static GetBlobRecordsResultJsonDeser getInstance() {
        if (instance == null) {
            instance = new GetBlobRecordsResultJsonDeser();
        }
        return instance;
    }
}

