/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.model.serialize;

import com.aliyun.datahub.common.data.Field;
import com.aliyun.datahub.common.data.FieldType;
import com.aliyun.datahub.common.transport.Response;
import com.aliyun.datahub.common.util.JacksonParser;
import com.aliyun.datahub.exception.DatahubClientException;
import com.aliyun.datahub.exception.DatahubServiceException;
import com.aliyun.datahub.exception.MalformedRecordException;
import com.aliyun.datahub.model.GetRecordsRequest;
import com.aliyun.datahub.model.GetRecordsResult;
import com.aliyun.datahub.model.RecordEntry;
import com.aliyun.datahub.model.serialize.Deserializer;
import com.aliyun.datahub.model.serialize.JsonErrorParser;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class GetRecordsResultJsonDeser
implements Deserializer<GetRecordsResult, GetRecordsRequest, Response> {
    private static GetRecordsResultJsonDeser instance;

    @Override
    public GetRecordsResult deserialize(GetRecordsRequest request, Response response) throws DatahubClientException {
        if (!response.isOK()) {
            throw JsonErrorParser.getInstance().parse(response);
        }
        GetRecordsResult rs = new GetRecordsResult();
        ObjectMapper mapper = JacksonParser.getObjectMapper();
        JsonNode tree = null;
        try {
            tree = mapper.readTree(response.getBody());
        }
        catch (IOException e) {
            throw new DatahubServiceException("JsonParseError", "Parse body failed:" + response.getBody(), response);
        }
        rs.setNextCursor(tree.get("NextCursor").asText());
        long sequence = tree.get("StartSeq").asLong();
        rs.setStartSeq(sequence);
        JsonNode recordsNode = tree.get("Records");
        ArrayList<RecordEntry> records = new ArrayList<RecordEntry>();
        Iterator itRecord = recordsNode.getElements();
        while (itRecord.hasNext()) {
            RecordEntry entry = new RecordEntry(request.getSchema());
            JsonNode record = (JsonNode)itRecord.next();
            JsonNode time = record.get("SystemTime");
            JsonNode data = record.get("Data");
            JsonNode attrs = record.get("Attributes");
            entry.setSequence(sequence++);
            entry.setSystemTime(time.asLong());
            entry.setShardId(request.getShardId());
            Iterator itField = data.getElements();
            int i = 0;
            for (Field field : request.getSchema().getFields()) {
                block17: {
                    if (!itField.hasNext()) continue;
                    JsonNode node = (JsonNode)itField.next();
                    try {
                        if (node.isNull()) break block17;
                        if (field.getType() == FieldType.BIGINT) {
                            entry.setBigint(i, (Long)Long.parseLong(node.asText()));
                            break block17;
                        }
                        if (field.getType() == FieldType.BOOLEAN) {
                            String v = node.asText();
                            if (v.equalsIgnoreCase("true") || v.equalsIgnoreCase("false")) {
                                entry.setBoolean(i, (Boolean)Boolean.parseBoolean(v));
                                break block17;
                            }
                            throw new MalformedRecordException("invalid boolean value: " + v, response);
                        }
                        if (field.getType() == FieldType.DOUBLE) {
                            entry.setDouble(i, (Double)Double.parseDouble(node.asText()));
                            break block17;
                        }
                        if (field.getType() == FieldType.STRING) {
                            entry.setString(i, node.asText());
                            break block17;
                        }
                        if (field.getType() == FieldType.TIMESTAMP) {
                            entry.setTimeStamp(i, (Long)Long.parseLong(node.asText()));
                            break block17;
                        }
                        if (field.getType() == FieldType.DECIMAL) {
                            entry.setDecimal(i, new BigDecimal(node.asText()));
                            break block17;
                        }
                        throw new MalformedRecordException("unsupported data type:" + field.getType().name(), response);
                    }
                    catch (NumberFormatException e) {
                        throw new MalformedRecordException("invalid type cast:" + field.getType().name() + "(" + node.asText() + ")", response);
                    }
                }
                ++i;
            }
            if (itField.hasNext()) {
                // empty if block
            }
            if (attrs != null && !attrs.isNull()) {
                Iterator itAttr = attrs.getFields();
                HashMap attrMap = new HashMap();
                while (itAttr.hasNext()) {
                    Map.Entry attr = (Map.Entry)itAttr.next();
                    entry.putAttribute((String)attr.getKey(), ((JsonNode)attr.getValue()).asText());
                }
            }
            records.add(entry);
        }
        rs.setRecords(records);
        return rs;
    }

    private GetRecordsResultJsonDeser() {
    }

    public static GetRecordsResultJsonDeser getInstance() {
        if (instance == null) {
            instance = new GetRecordsResultJsonDeser();
        }
        return instance;
    }
}

