/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.model.serialize;

import com.aliyun.datahub.common.transport.Response;
import com.aliyun.datahub.common.util.JacksonParser;
import com.aliyun.datahub.exception.AuthorizationFailureException;
import com.aliyun.datahub.exception.DatahubServiceException;
import com.aliyun.datahub.exception.InternalFailureException;
import com.aliyun.datahub.exception.InvalidCursorException;
import com.aliyun.datahub.exception.InvalidOperationException;
import com.aliyun.datahub.exception.InvalidParameterException;
import com.aliyun.datahub.exception.LimitExceededException;
import com.aliyun.datahub.exception.MysqlException;
import com.aliyun.datahub.exception.NoPermissionException;
import com.aliyun.datahub.exception.OdpsException;
import com.aliyun.datahub.exception.OffsetResetedException;
import com.aliyun.datahub.exception.OffsetSessionChangedException;
import com.aliyun.datahub.exception.OffsetSessionClosedException;
import com.aliyun.datahub.exception.OperationDeniedException;
import com.aliyun.datahub.exception.ResourceExistException;
import com.aliyun.datahub.exception.ResourceNotFoundException;
import com.aliyun.datahub.exception.SubscriptionOfflineException;
import com.aliyun.datahub.model.serialize.ErrorParser;
import java.io.IOException;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class JsonErrorParser
implements ErrorParser {
    private static JsonErrorParser instance;

    @Override
    public DatahubServiceException parse(Response response) {
        DatahubServiceException ex = null;
        if (response.getBody() == null) {
            ex = new DatahubServiceException("Invalid response, empty body.");
        } else {
            try {
                ObjectMapper mapper = JacksonParser.getObjectMapper();
                JsonNode tree = mapper.readTree(response.getBody());
                JsonNode node = tree.get("ErrorCode");
                if (node.isNull()) {
                    ex = new DatahubServiceException(new String(response.getBody()));
                } else {
                    String er = node.asText();
                    ex = er.equals("InvalidParameter") || er.equals("InvalidSubscription") ? new InvalidParameterException(tree.get("ErrorMessage").asText()) : (er.equals("InvalidCursor") ? new InvalidCursorException(tree.get("ErrorMessage").asText()) : (er.equals("NoSuchTopic") || er.equals("NoSuchProject") || er.equals("NoSuchSubscription") || er.equals("NoSuchShard") || er.equals("NoSuchConnector") || er.equals("NoSuchMeteringInfo") ? new ResourceNotFoundException(tree.get("ErrorMessage").asText()) : (er.equals("ProjectAlreadyExist") || er.equals("TopicAlreadyExist") || er.equals("ConnectorAlreadyExist") ? new ResourceExistException(tree.get("ErrorMessage").asText()) : (er.equals("Unauthorized") ? new AuthorizationFailureException(tree.get("ErrorMessage").asText()) : (er.equals("NoPermission") ? new NoPermissionException(tree.get("ErrorMessage").asText()) : (er.equals("InvalidShardOperation") ? new InvalidOperationException(tree.get("ErrorMessage").asText()) : (er.equals("OperationDenied") ? new OperationDeniedException(tree.get("ErrorMessage").asText()) : (er.equals("LimitExceeded") ? new LimitExceededException(tree.get("ErrorMessage").asText()) : (er.equals("OdpsServiceError") ? new OdpsException(tree.get("ErrorMessage").asText()) : (er.equals("MysqlServiceError") ? new MysqlException(tree.get("ErrorMessage").asText()) : (er.equals("InternalServerError") ? new InternalFailureException(tree.get("ErrorMessage").asText()) : (er.equals("SubscriptionOffline") ? new SubscriptionOfflineException(tree.get("ErrorMessage").asText()) : (er.equals("OffsetReseted") ? new OffsetResetedException(tree.get("ErrorMessage").asText()) : (er.equals("OffsetSessionClosed") ? new OffsetSessionClosedException(tree.get("ErrorMessage").asText()) : (er.equals("OffsetSessionChanged") ? new OffsetSessionChangedException(tree.get("ErrorMessage").asText()) : new DatahubServiceException(tree.get("ErrorMessage").asText()))))))))))))))));
                    ex.setErrorCode(er);
                }
            }
            catch (IOException e) {
                ex = new DatahubServiceException(new String(response.getBody()));
            }
        }
        ex.setStatusCode(response.getStatus());
        ex.setRequestId(response.getHeader("x-datahub-request-id"));
        return ex;
    }

    public static JsonErrorParser getInstance() {
        if (instance == null) {
            instance = new JsonErrorParser();
        }
        return instance;
    }
}

