/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.model.serialize;

import com.aliyun.datahub.common.transport.Response;
import com.aliyun.datahub.common.util.JacksonParser;
import com.aliyun.datahub.exception.DatahubServiceException;
import com.aliyun.datahub.model.ListTopicRequest;
import com.aliyun.datahub.model.ListTopicResult;
import com.aliyun.datahub.model.serialize.Deserializer;
import com.aliyun.datahub.model.serialize.JsonErrorParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class ListTopicResultJsonDeser
implements Deserializer<ListTopicResult, ListTopicRequest, Response> {
    private static ListTopicResultJsonDeser instance;

    @Override
    public ListTopicResult deserialize(ListTopicRequest request, Response response) throws DatahubServiceException {
        if (!response.isOK()) {
            throw JsonErrorParser.getInstance().parse(response);
        }
        ListTopicResult rs = new ListTopicResult();
        ByteArrayInputStream is = new ByteArrayInputStream(response.getBody());
        ObjectMapper mapper = JacksonParser.getObjectMapper();
        JsonNode tree = null;
        try {
            tree = mapper.readTree((InputStream)is);
        }
        catch (IOException e) {
            throw new DatahubServiceException("JsonParseError", "Parse body failed:" + response.getBody(), response);
        }
        JsonNode node = tree.get("TopicNames");
        if (node != null && !node.isNull() && node.isArray()) {
            Iterator it = node.getElements();
            while (it.hasNext()) {
                JsonNode topic = (JsonNode)it.next();
                rs.addTopic(topic.asText());
            }
        }
        return rs;
    }

    private ListTopicResultJsonDeser() {
    }

    public static ListTopicResultJsonDeser getInstance() {
        if (instance == null) {
            instance = new ListTopicResultJsonDeser();
        }
        return instance;
    }
}

