/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.model.serialize;

import com.aliyun.datahub.common.transport.Response;
import com.aliyun.datahub.common.util.JacksonParser;
import com.aliyun.datahub.exception.DatahubServiceException;
import com.aliyun.datahub.model.ErrorEntry;
import com.aliyun.datahub.model.PutRecordsRequest;
import com.aliyun.datahub.model.PutRecordsResult;
import com.aliyun.datahub.model.serialize.Deserializer;
import com.aliyun.datahub.model.serialize.JsonErrorParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class PutRecordsResultJsonDeser
implements Deserializer<PutRecordsResult, PutRecordsRequest, Response> {
    private static PutRecordsResultJsonDeser instance;

    @Override
    public PutRecordsResult deserialize(PutRecordsRequest request, Response response) throws DatahubServiceException {
        if (!response.isOK()) {
            throw JsonErrorParser.getInstance().parse(response);
        }
        PutRecordsResult rs = new PutRecordsResult();
        rs.setRequestId(response.getHeader("x-datahub-request-id"));
        ByteArrayInputStream is = new ByteArrayInputStream(response.getBody());
        ObjectMapper mapper = JacksonParser.getObjectMapper();
        JsonNode tree = null;
        try {
            tree = mapper.readTree((InputStream)is);
        }
        catch (IOException e) {
            throw new DatahubServiceException("JsonParseError", "Parse body failed:" + response.getBody(), response);
        }
        JsonNode node = tree.get("FailedRecordCount");
        if (node != null && !node.isNull() && node.isInt()) {
            rs.setFailedRecordCount(node.asInt());
        }
        if ((node = tree.get("FailedRecords")) != null && !node.isNull()) {
            if (!node.isArray()) {
                throw new DatahubServiceException("InvalidResultFormat", "Invalid result format:" + tree.asText(), response);
            }
            Iterator failedNodes = node.getElements();
            while (failedNodes.hasNext()) {
                JsonNode failedNode = (JsonNode)failedNodes.next();
                int index = failedNode.get("Index").asInt();
                String errCode = failedNode.get("ErrorCode").asText();
                String errMsg = failedNode.get("ErrorMessage").asText();
                ErrorEntry error = new ErrorEntry(errCode, errMsg);
                rs.addFailedIndex(index);
                rs.addFailedError(error);
            }
        }
        return rs;
    }

    private PutRecordsResultJsonDeser() {
    }

    public static PutRecordsResultJsonDeser getInstance() {
        if (instance == null) {
            instance = new PutRecordsResultJsonDeser();
        }
        return instance;
    }
}

