/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.model.serialize;

import com.aliyun.datahub.common.transport.Response;
import com.aliyun.datahub.common.util.JacksonParser;
import com.aliyun.datahub.exception.DatahubServiceException;
import com.aliyun.datahub.model.GetSubscriptionResult;
import com.aliyun.datahub.model.QuerySubscriptionRequest;
import com.aliyun.datahub.model.QuerySubscriptionResult;
import com.aliyun.datahub.model.serialize.Deserializer;
import com.aliyun.datahub.model.serialize.JsonErrorParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class QuerySubscriptionResultJsonDeser
implements Deserializer<QuerySubscriptionResult, QuerySubscriptionRequest, Response> {
    private static QuerySubscriptionResultJsonDeser instance;

    @Override
    public QuerySubscriptionResult deserialize(QuerySubscriptionRequest request, Response response) throws DatahubServiceException {
        if (!response.isOK()) {
            throw JsonErrorParser.getInstance().parse(response);
        }
        QuerySubscriptionResult rs = new QuerySubscriptionResult();
        ObjectMapper mapper = JacksonParser.getObjectMapper();
        JsonNode tree = null;
        try {
            tree = mapper.readTree(response.getBody());
        }
        catch (IOException e) {
            throw new DatahubServiceException("JsonParseError", "Parse body failed:" + response.getBody(), response);
        }
        rs.setTotalCount(tree.get("TotalCount").asLong());
        JsonNode subscriptionsNode = tree.get("Subscriptions");
        ArrayList<GetSubscriptionResult> subscriptions = new ArrayList<GetSubscriptionResult>();
        Iterator itSub = subscriptionsNode.getElements();
        while (itSub.hasNext()) {
            JsonNode subNode = (JsonNode)itSub.next();
            GetSubscriptionResult sub = new GetSubscriptionResult();
            sub.setIsOwner(subNode.get("IsOwner").asBoolean());
            sub.setSubId(subNode.get("SubId").asText());
            sub.setTopicName(subNode.get("TopicName").asText());
            sub.setComment(subNode.get("Comment").asText());
            sub.setType(subNode.get("Type").asInt());
            sub.setState(subNode.get("State").asInt());
            sub.setCreateTime(subNode.get("CreateTime").asLong() * 1000L);
            sub.setLastModifyTime(subNode.get("LastModifyTime").asLong() * 1000L);
            subscriptions.add(sub);
        }
        rs.setSubscriptions(subscriptions);
        return rs;
    }

    private QuerySubscriptionResultJsonDeser() {
    }

    public static QuerySubscriptionResultJsonDeser getInstance() {
        if (instance == null) {
            instance = new QuerySubscriptionResultJsonDeser();
        }
        return instance;
    }
}

