/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datalake.metastore.common;

import com.aliyun.datalake.metastore.common.CacheDataLakeMetaStoreConfig;
import com.aliyun.datalake.metastore.common.IDataLakeMetaStore;
import com.aliyun.datalake20200710.models.ColumnStatisticsObj;
import com.aliyun.datalake20200710.models.Database;
import com.aliyun.datalake20200710.models.Function;
import com.aliyun.datalake20200710.models.FunctionInput;
import com.aliyun.datalake20200710.models.LockObj;
import com.aliyun.datalake20200710.models.LockStatus;
import com.aliyun.datalake20200710.models.Partition;
import com.aliyun.datalake20200710.models.PartitionInput;
import com.aliyun.datalake20200710.models.PrincipalPrivilegeSet;
import com.aliyun.datalake20200710.models.Table;
import com.aliyun.datalake20200710.models.TableInput;
import com.aliyun.datalake20200710.models.UpdateTablePartitionColumnStatisticsRequest;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheDataLakeMetaStore
implements IDataLakeMetaStore {
    private final Logger logger = LoggerFactory.getLogger(CacheDataLakeMetaStore.class);
    private final boolean databaseCacheEnabled;
    private final boolean tableCacheEnabled;
    @VisibleForTesting
    protected Cache<DbIdentifier, Database> databaseCache;
    @VisibleForTesting
    protected Cache<TableIdentifier, Table> tableCache;
    private CacheDataLakeMetaStoreConfig config;
    private IDataLakeMetaStore defaultDataLakeMetaStore;

    public CacheDataLakeMetaStore(CacheDataLakeMetaStoreConfig config, IDataLakeMetaStore defaultDataLakeMetaStore) {
        this.config = config;
        this.defaultDataLakeMetaStore = defaultDataLakeMetaStore;
        this.databaseCacheEnabled = config.isDataLakeDbCacheEnable();
        if (this.databaseCacheEnabled) {
            int dbCacheSize = config.getDataLakeDbCacheSize();
            int dbCacheTtlMins = config.getDataLakeDbCacheTTLMins();
            this.validateConfigValueIsGreaterThanZero("data.lake.cache.db.size", dbCacheSize);
            this.validateConfigValueIsGreaterThanZero("data.lake.cache.db.ttl.mins", dbCacheTtlMins);
            this.databaseCache = CacheBuilder.newBuilder().maximumSize((long)dbCacheSize).expireAfterWrite((long)dbCacheTtlMins, TimeUnit.MINUTES).build();
        } else {
            this.databaseCache = null;
        }
        this.tableCacheEnabled = config.isDataLakeTbCacheEnable();
        if (this.tableCacheEnabled) {
            int tableCacheSize = config.getDataLakeTbCacheSize();
            int tableCacheTtlMins = config.getDataLakeTbCacheTTLMins();
            this.validateConfigValueIsGreaterThanZero("data.lake.cache.tb.size", tableCacheSize);
            this.validateConfigValueIsGreaterThanZero("data.lake.cache.tb.ttl.mins", tableCacheTtlMins);
            this.tableCache = CacheBuilder.newBuilder().maximumSize((long)tableCacheSize).expireAfterWrite((long)tableCacheTtlMins, TimeUnit.MINUTES).build();
        } else {
            this.tableCache = null;
        }
    }

    private void validateConfigValueIsGreaterThanZero(String configName, int value) {
        Preconditions.checkArgument((value > 0 ? 1 : 0) != 0, (Object)String.format("Invalid value for Hive Config %s. Provide a value greater than zero", configName));
    }

    public Cache<DbIdentifier, Database> getDatabaseCache() {
        return this.databaseCache;
    }

    public Cache<TableIdentifier, Table> getTableCache() {
        return this.tableCache;
    }

    @Override
    public void createDatabase(String catalogId, Database database) throws Exception {
        this.defaultDataLakeMetaStore.createDatabase(catalogId, database);
    }

    @Override
    public void createDatabase(String catalogId, String dbName, String description, String location, Map<String, String> parameters, String ownerName, String ownerType, PrincipalPrivilegeSet principalPrivilegeSet) throws Exception {
        this.defaultDataLakeMetaStore.createDatabase(catalogId, dbName, description, location, parameters, ownerName, ownerType, principalPrivilegeSet);
    }

    @Override
    public Database getDatabase(String catalogId, String dbName) throws Exception {
        Database result;
        if (this.databaseCacheEnabled) {
            DbIdentifier key = new DbIdentifier(catalogId, dbName);
            Database valueFromCache = (Database)this.databaseCache.getIfPresent((Object)key);
            if (valueFromCache != null) {
                this.logger.debug("Cache hit for operation [getDatabase] on key [" + key + "]");
                result = valueFromCache;
            } else {
                this.logger.debug("Cache miss for operation [getDatabase] on key [" + key + "]");
                result = this.defaultDataLakeMetaStore.getDatabase(catalogId, dbName);
                this.databaseCache.put((Object)key, (Object)result);
            }
        } else {
            result = this.defaultDataLakeMetaStore.getDatabase(catalogId, dbName);
        }
        return result;
    }

    @Override
    public List<String> getDatabases(String catalogId, String pattern, int pageSize) throws Exception {
        return this.defaultDataLakeMetaStore.getDatabases(catalogId, pattern, pageSize);
    }

    @Override
    public void alterDatabase(String catalogId, String dbName, Database database) throws Exception {
        this.defaultDataLakeMetaStore.alterDatabase(catalogId, dbName, database);
        if (this.databaseCacheEnabled) {
            this.purgeDatabaseFromCache(catalogId, dbName);
        }
    }

    private void purgeDatabaseFromCache(String catalogId, String dbName) {
        this.databaseCache.invalidate((Object)new DbIdentifier(catalogId, dbName));
    }

    @Override
    public void dropDatabase(String catalogId, String dbName, boolean deleteData, boolean ignoreUnknownDb, boolean cascade) throws Exception {
        this.defaultDataLakeMetaStore.dropDatabase(catalogId, dbName, deleteData, ignoreUnknownDb, cascade);
        if (this.databaseCacheEnabled) {
            this.purgeDatabaseFromCache(catalogId, dbName);
            if (this.tableCacheEnabled) {
                this.purgeTableFromCache(catalogId, dbName);
            }
        }
    }

    @Override
    public void createTable(String catalogId, TableInput tbl) throws Exception {
        this.defaultDataLakeMetaStore.createTable(catalogId, tbl);
    }

    @Override
    public Table getTable(String catalogId, String dbName, String tableName) throws Exception {
        Table result;
        if (this.tableCacheEnabled) {
            TableIdentifier key = new TableIdentifier(catalogId, dbName, tableName);
            Table valueFromCache = (Table)this.tableCache.getIfPresent((Object)key);
            if (valueFromCache != null) {
                result = valueFromCache;
            } else {
                result = this.defaultDataLakeMetaStore.getTable(catalogId, dbName, tableName);
                this.tableCache.put((Object)key, (Object)result);
            }
        } else {
            result = this.defaultDataLakeMetaStore.getTable(catalogId, dbName, tableName);
        }
        return result;
    }

    @Override
    public List<String> getTables(String catalogId, String dbname, String tablePattern, int pageSize, String tableType) throws Exception {
        return this.defaultDataLakeMetaStore.getTables(catalogId, dbname, tablePattern, pageSize, tableType);
    }

    @Override
    public List<Table> getTableObjects(String catalogId, String dbname, String tablePattern, int pageSize, String tableType) throws Exception {
        return this.defaultDataLakeMetaStore.getTableObjects(catalogId, dbname, tablePattern, pageSize, tableType);
    }

    @Override
    public List<Table> getTableObjects(String catalogId, String dbname, List<String> tableNames) throws Exception {
        return this.defaultDataLakeMetaStore.getTableObjects(catalogId, dbname, tableNames);
    }

    @Override
    public void alterTable(String catalogId, String dbName, String oldTableName, TableInput newTable) throws Exception {
        this.alterTable(catalogId, dbName, oldTableName, newTable, false, false);
    }

    @Override
    public void alterTable(String catalogId, String dbName, String oldTableName, TableInput newTable, boolean cascade, boolean isAsync) throws Exception {
        this.defaultDataLakeMetaStore.alterTable(catalogId, dbName, oldTableName, newTable, cascade, isAsync);
        if (this.tableCacheEnabled) {
            this.purgeTableFromCache(catalogId, dbName, oldTableName);
        }
    }

    public void purgeTableFromCache(String catalogId, String dbName, String oldTableName) {
        this.tableCache.invalidate((Object)new TableIdentifier(catalogId, dbName, oldTableName));
    }

    public void purgeTableFromCache(String catalogId, String dbName) {
        ConcurrentMap cacheMaps = this.tableCache.asMap();
        for (Map.Entry entry : cacheMaps.entrySet()) {
            TableIdentifier tableIdentifier = (TableIdentifier)entry.getKey();
            if (!tableIdentifier.getDbName().equalsIgnoreCase(dbName)) continue;
            this.tableCache.invalidate((Object)new TableIdentifier(catalogId, dbName, ((Table)entry.getValue()).getTableName()));
        }
    }

    @Override
    public void dropTable(String catalogId, String dbName, String tbName, boolean deleteData) throws Exception {
        this.defaultDataLakeMetaStore.dropTable(catalogId, dbName, tbName, deleteData);
        if (this.tableCacheEnabled) {
            this.purgeTableFromCache(catalogId, dbName, tbName);
        }
    }

    @Override
    public void doRenameTableInMs(String catalogId, String dbName, String oldTableName, TableInput newTable, Boolean isAsync) throws Exception {
        this.defaultDataLakeMetaStore.doRenameTableInMs(catalogId, dbName, oldTableName, newTable, isAsync);
        if (this.tableCacheEnabled) {
            this.purgeTableFromCache(catalogId, dbName, oldTableName);
        }
    }

    @Override
    public List<ColumnStatisticsObj> getTableColumnStatistics(String catalogId, String dbName, String tableName, List<String> columnNames) throws Exception {
        return this.defaultDataLakeMetaStore.getTableColumnStatistics(catalogId, dbName, tableName, columnNames);
    }

    @Override
    public boolean updateTableColumnStatistics(UpdateTablePartitionColumnStatisticsRequest columnStatistics) throws Exception {
        return this.defaultDataLakeMetaStore.updateTableColumnStatistics(columnStatistics);
    }

    @Override
    public boolean deleteTableColumnStatistics(String catalogId, String dbName, String tableName, List<String> colNames) throws Exception {
        return this.defaultDataLakeMetaStore.deleteTableColumnStatistics(catalogId, dbName, tableName, colNames);
    }

    @Override
    public Partition addPartition(String catalogId, String dbName, String tableName, PartitionInput partitions, boolean ifNotExist, boolean needResult) throws Exception {
        return this.defaultDataLakeMetaStore.addPartition(catalogId, dbName, tableName, partitions, ifNotExist, needResult);
    }

    @Override
    public List<Partition> addPartitions(String catalogId, String dbName, String tableName, List<PartitionInput> partitions, boolean ifNotExist, boolean needResult) throws Exception {
        return this.defaultDataLakeMetaStore.addPartitions(catalogId, dbName, tableName, partitions, ifNotExist, needResult);
    }

    @Override
    public void alterPartitions(String catalogId, String dbName, String tblName, List<PartitionInput> partitions) throws Exception {
        this.defaultDataLakeMetaStore.alterPartitions(catalogId, dbName, tblName, partitions);
    }

    @Override
    public <T> T listPartitionsByExpr(String catalogId, String dbName, String tblName, byte[] expr, String defaultPartName, int max, String filter, int pageSizeIn, IDataLakeMetaStore.PartitionVisitor<T, Partition> resultConverter) throws Exception {
        return this.defaultDataLakeMetaStore.listPartitionsByExpr(catalogId, dbName, tblName, expr, defaultPartName, max, filter, pageSizeIn, resultConverter);
    }

    @Override
    public void doDropPartitions(String catalogId, String dbName, String tableName, List<List<String>> partValuesList, boolean ifExist) throws Exception {
        this.defaultDataLakeMetaStore.doDropPartitions(catalogId, dbName, tableName, partValuesList, ifExist);
    }

    @Override
    public Partition getPartition(String catalogId, String databaseName, String tableName, List<String> parValues) throws Exception {
        return this.defaultDataLakeMetaStore.getPartition(catalogId, databaseName, tableName, parValues);
    }

    @Override
    public List<Partition> getPartitionsByValues(String catalogId, String databaseName, String tableName, List<List<String>> partValuesList) throws Exception {
        return this.defaultDataLakeMetaStore.getPartitionsByValues(catalogId, databaseName, tableName, partValuesList);
    }

    @Override
    public void renamePartitionInCatalog(String catalogId, String dbName, String tbName, List<String> partitionValues, PartitionInput newPartition) throws Exception {
        this.defaultDataLakeMetaStore.renamePartitionInCatalog(catalogId, dbName, tbName, partitionValues, newPartition);
    }

    @Override
    public List<String> listPartitionNames(String catalogId, String dbName, String tblName, List<String> partialPartValues, int max, int pageSizeIn) throws Exception {
        return this.defaultDataLakeMetaStore.listPartitionNames(catalogId, dbName, tblName, partialPartValues, max, pageSizeIn);
    }

    @Override
    public int getNumPartitionsByFilter(String catalogId, String dbName, String tblName, String filter, int pageSizeIn) throws Exception {
        return this.defaultDataLakeMetaStore.getNumPartitionsByFilter(catalogId, dbName, tblName, filter, pageSizeIn);
    }

    @Override
    public <T> T listPartitionsInternal(String catalogId, String databaseName, String tableName, List<String> values, String filter, int max, int pageSizeIn, IDataLakeMetaStore.PartitionVisitor<T, Partition> resultConverter) throws Exception {
        return this.defaultDataLakeMetaStore.listPartitionsInternal(catalogId, databaseName, tableName, values, filter, max, pageSizeIn, resultConverter);
    }

    @Override
    public <T> T listPartitions(String catalogId, String databaseName, String tableName, int max, int pageSizeIn, IDataLakeMetaStore.PartitionVisitor<T, Partition> resultConverter) throws Exception {
        return this.defaultDataLakeMetaStore.listPartitions(catalogId, databaseName, tableName, max, pageSizeIn, resultConverter);
    }

    @Override
    public List<Partition> listPartitionsByFilter(String catalogId, String databaseName, String tableName, String filter, int pageSizeIn) throws Exception {
        return this.defaultDataLakeMetaStore.listPartitionsByFilter(catalogId, databaseName, tableName, filter, pageSizeIn);
    }

    @Override
    public void doDropPartition(String catalogId, String dbName, String tableName, List<String> partValuesList, boolean ifExist) throws Exception {
        this.defaultDataLakeMetaStore.doDropPartition(catalogId, dbName, tableName, partValuesList, ifExist);
    }

    @Override
    public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String catalogId, String dbName, String tableName, List<String> partitionNames, List<String> columnNames) throws Exception {
        return this.defaultDataLakeMetaStore.getPartitionColumnStatistics(catalogId, dbName, tableName, partitionNames, columnNames);
    }

    @Override
    public Map<String, List<ColumnStatisticsObj>> batchGetPartitionColumnStatistics(String catalogId, String dbName, String tableName, List<String> partitionNames, List<String> columnNames) throws Exception {
        return this.defaultDataLakeMetaStore.batchGetPartitionColumnStatistics(catalogId, dbName, tableName, partitionNames, columnNames);
    }

    @Override
    public boolean updatePartitionColumnStatistics(UpdateTablePartitionColumnStatisticsRequest columnStatistics) throws Exception {
        return this.defaultDataLakeMetaStore.updatePartitionColumnStatistics(columnStatistics);
    }

    @Override
    public boolean deletePartitionColumnStatistics(String catalogId, String dbName, String tableName, List<String> partNames, List<String> colNames) throws Exception {
        return this.defaultDataLakeMetaStore.deletePartitionColumnStatistics(catalogId, dbName, tableName, partNames, colNames);
    }

    @Override
    public void createFunction(String catalogId, FunctionInput function, String dbName) throws Exception {
        this.defaultDataLakeMetaStore.createFunction(catalogId, function, dbName);
    }

    @Override
    public Function getFunction(String catalogId, String dbName, String functionName) throws Exception {
        return this.defaultDataLakeMetaStore.getFunction(catalogId, dbName, functionName);
    }

    @Override
    public List<String> getFunctions(String catalogId, String dbName, String pattern, int pageSize) throws Exception {
        return this.defaultDataLakeMetaStore.getFunctions(catalogId, dbName, pattern, pageSize);
    }

    @Override
    public List<Function> getFunctionObjects(String catalogId, String dbName, String pattern, int pageSize) throws Exception {
        return this.defaultDataLakeMetaStore.getFunctionObjects(catalogId, dbName, pattern, pageSize);
    }

    @Override
    public void alterFunction(String catalogId, String dbName, String functionName, FunctionInput function) throws Exception {
        this.defaultDataLakeMetaStore.alterFunction(catalogId, dbName, functionName, function);
    }

    @Override
    public void dropFunction(String catalogId, String dbName, String functionName) throws Exception {
        this.defaultDataLakeMetaStore.dropFunction(catalogId, dbName, functionName);
    }

    @Override
    public List<Partition> getNonSubDirectoryPartitionLocations(String catalogId, String dbName, String tableName, int pageSize) throws Exception {
        return this.defaultDataLakeMetaStore.getNonSubDirectoryPartitionLocations(catalogId, dbName, tableName, pageSize);
    }

    @Override
    public LockStatus lock(List<LockObj> lockObjList) throws Exception {
        return this.defaultDataLakeMetaStore.lock(lockObjList);
    }

    @Override
    public Boolean unLock(Long lockId) throws Exception {
        return this.defaultDataLakeMetaStore.unLock(lockId);
    }

    @Override
    public LockStatus getLock(Long lockId) throws Exception {
        return this.defaultDataLakeMetaStore.getLock(lockId);
    }

    @Override
    public Boolean refreshLock(Long lockId) throws Exception {
        return this.defaultDataLakeMetaStore.refreshLock(lockId);
    }

    public static class DbIdentifier {
        private final String catalogId;
        private final String dbName;

        public DbIdentifier(String catalogId, String dbName) {
            this.catalogId = catalogId;
            this.dbName = dbName;
        }

        public String getDbName() {
            return this.dbName;
        }

        public String toString() {
            return "DbIdentifier{catalogId='" + this.catalogId + '\'' + ", dbName='" + this.dbName + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DbIdentifier that = (DbIdentifier)o;
            return Objects.equals(this.catalogId, that.catalogId) && Objects.equals(this.dbName, that.dbName);
        }

        public int hashCode() {
            return Objects.hash(this.catalogId, this.dbName);
        }
    }

    public static class TableIdentifier {
        private final String catalogId;
        private final String dbName;
        private final String tableName;

        public TableIdentifier(String catalogId, String dbName, String tableName) {
            this.catalogId = catalogId.toLowerCase();
            this.dbName = dbName.toLowerCase();
            this.tableName = tableName.toLowerCase();
        }

        public String getDbName() {
            return this.dbName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getCatalogId() {
            return this.catalogId;
        }

        public String toString() {
            return "TableIdentifier{catalogId='" + this.catalogId + '\'' + ", dbName='" + this.dbName + '\'' + ", tableName='" + this.tableName + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TableIdentifier that = (TableIdentifier)o;
            return Objects.equals(this.catalogId, that.catalogId) && Objects.equals(this.dbName, that.dbName) && Objects.equals(this.tableName, that.tableName);
        }

        public int hashCode() {
            return Objects.hash(this.catalogId, this.dbName, this.tableName);
        }
    }
}

