/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datalake.metastore.common.api;

import com.aliyun.datalake.metastore.common.api.AbstractBaseApi;
import com.aliyun.datalake.metastore.common.entity.PaginatedResult;
import com.aliyun.datalake.metastore.common.entity.PartitionBatchResultModel;
import com.aliyun.datalake.metastore.common.entity.ResultModel;
import com.aliyun.datalake.metastore.common.functional.ThrowingBiFunction;
import com.aliyun.datalake.metastore.common.util.DataLakeUtil;
import com.aliyun.datalake20200710.Client;
import com.aliyun.datalake20200710.models.BatchCreatePartitionsRequest;
import com.aliyun.datalake20200710.models.BatchCreatePartitionsResponse;
import com.aliyun.datalake20200710.models.BatchCreatePartitionsResponseBody;
import com.aliyun.datalake20200710.models.BatchDeletePartitionsRequest;
import com.aliyun.datalake20200710.models.BatchDeletePartitionsResponse;
import com.aliyun.datalake20200710.models.BatchDeletePartitionsResponseBody;
import com.aliyun.datalake20200710.models.BatchGetPartitionColumnStatisticsRequest;
import com.aliyun.datalake20200710.models.BatchGetPartitionColumnStatisticsResponse;
import com.aliyun.datalake20200710.models.BatchGetPartitionColumnStatisticsResponseBody;
import com.aliyun.datalake20200710.models.BatchGetPartitionsRequest;
import com.aliyun.datalake20200710.models.BatchGetPartitionsResponse;
import com.aliyun.datalake20200710.models.BatchGetPartitionsResponseBody;
import com.aliyun.datalake20200710.models.BatchUpdatePartitionsRequest;
import com.aliyun.datalake20200710.models.BatchUpdatePartitionsResponse;
import com.aliyun.datalake20200710.models.BatchUpdatePartitionsResponseBody;
import com.aliyun.datalake20200710.models.ColumnStatisticsObj;
import com.aliyun.datalake20200710.models.CreatePartitionRequest;
import com.aliyun.datalake20200710.models.CreatePartitionResponse;
import com.aliyun.datalake20200710.models.CreatePartitionResponseBody;
import com.aliyun.datalake20200710.models.DeletePartitionColumnStatisticsRequest;
import com.aliyun.datalake20200710.models.DeletePartitionColumnStatisticsResponse;
import com.aliyun.datalake20200710.models.DeletePartitionColumnStatisticsResponseBody;
import com.aliyun.datalake20200710.models.DeletePartitionRequest;
import com.aliyun.datalake20200710.models.DeletePartitionResponse;
import com.aliyun.datalake20200710.models.DeletePartitionResponseBody;
import com.aliyun.datalake20200710.models.GetPartitionColumnStatisticsRequest;
import com.aliyun.datalake20200710.models.GetPartitionColumnStatisticsResponse;
import com.aliyun.datalake20200710.models.GetPartitionColumnStatisticsResponseBody;
import com.aliyun.datalake20200710.models.GetPartitionRequest;
import com.aliyun.datalake20200710.models.GetPartitionResponse;
import com.aliyun.datalake20200710.models.GetPartitionResponseBody;
import com.aliyun.datalake20200710.models.ListPartitionNamesRequest;
import com.aliyun.datalake20200710.models.ListPartitionNamesResponse;
import com.aliyun.datalake20200710.models.ListPartitionNamesResponseBody;
import com.aliyun.datalake20200710.models.ListPartitionsByFilterRequest;
import com.aliyun.datalake20200710.models.ListPartitionsByFilterResponse;
import com.aliyun.datalake20200710.models.ListPartitionsByFilterResponseBody;
import com.aliyun.datalake20200710.models.ListPartitionsRequest;
import com.aliyun.datalake20200710.models.ListPartitionsResponse;
import com.aliyun.datalake20200710.models.ListPartitionsResponseBody;
import com.aliyun.datalake20200710.models.Partition;
import com.aliyun.datalake20200710.models.PartitionError;
import com.aliyun.datalake20200710.models.PartitionInput;
import com.aliyun.datalake20200710.models.PartitionSpec;
import com.aliyun.datalake20200710.models.RenamePartitionRequest;
import com.aliyun.datalake20200710.models.RenamePartitionResponse;
import com.aliyun.datalake20200710.models.RenamePartitionResponseBody;
import com.aliyun.datalake20200710.models.UpdatePartitionColumnStatisticsRequest;
import com.aliyun.datalake20200710.models.UpdatePartitionColumnStatisticsResponse;
import com.aliyun.datalake20200710.models.UpdatePartitionColumnStatisticsResponseBody;
import com.aliyun.datalake20200710.models.UpdateTablePartitionColumnStatisticsRequest;
import com.aliyun.teautil.models.RuntimeOptions;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PartitionApi
extends AbstractBaseApi {
    public PartitionApi(Client client) {
        super(client);
    }

    public ResultModel<Partition> getPartition(String catalogId, String databaseName, String tableName, List<String> values) throws Exception {
        return this.call(() -> {
            GetPartitionRequest request = new GetPartitionRequest();
            request.catalogId = catalogId;
            request.databaseName = databaseName;
            request.tableName = tableName;
            request.partitionValues = values;
            GetPartitionResponseBody response = ((GetPartitionResponse)this.callWithOptions((ThrowingBiFunction<Map, RuntimeOptions, GetPartitionResponse, E>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$getPartition$0(com.aliyun.datalake20200710.models.GetPartitionRequest java.util.Map com.aliyun.teautil.models.RuntimeOptions ), (Ljava/util/Map;Lcom/aliyun/teautil/models/RuntimeOptions;)Lcom/aliyun/datalake20200710/models/GetPartitionResponse;)((PartitionApi)this, (GetPartitionRequest)request))).body;
            return new ResultModel<Partition>(response.success, response.code, response.message, response.requestId, response.partition);
        });
    }

    public PartitionBatchResultModel<List<Partition>> batchGetPartitions(String catalogId, String databaseName, String tableName, List<List<String>> partValuesList, boolean isShareSd) throws Exception {
        return this.batchCall(() -> {
            BatchGetPartitionsRequest request = new BatchGetPartitionsRequest();
            request.catalogId = catalogId;
            request.databaseName = databaseName;
            request.tableName = tableName;
            request.partitionValueList = new ArrayList();
            request.isShareSd = isShareSd;
            for (List strings : partValuesList) {
                BatchGetPartitionsRequest.BatchGetPartitionsRequestPartitionValueList valueList = new BatchGetPartitionsRequest.BatchGetPartitionsRequestPartitionValueList();
                valueList.values = strings;
                request.partitionValueList.add(valueList);
            }
            BatchGetPartitionsResponseBody response = ((BatchGetPartitionsResponse)this.callWithOptions((ThrowingBiFunction<Map, RuntimeOptions, BatchGetPartitionsResponse, E>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$batchGetPartitions$2(com.aliyun.datalake20200710.models.BatchGetPartitionsRequest java.util.Map com.aliyun.teautil.models.RuntimeOptions ), (Ljava/util/Map;Lcom/aliyun/teautil/models/RuntimeOptions;)Lcom/aliyun/datalake20200710/models/BatchGetPartitionsResponse;)((PartitionApi)this, (BatchGetPartitionsRequest)request))).body;
            this.combinePartitionsWithShareSd(isShareSd, response.partitions, response.partitionSpecs);
            return new PartitionBatchResultModel<List>((boolean)response.success, response.code, response.message, response.requestId, response.partitions, (List<PartitionError>)response.partitionErrors);
        }, new PartitionBatchResultModel());
    }

    public PartitionBatchResultModel<List<Partition>> batchGetPartitions(String catalogId, String databaseName, String tableName, List<List<String>> partValuesList) throws Exception {
        return this.batchGetPartitions(catalogId, databaseName, tableName, partValuesList, true);
    }

    public ResultModel<Partition> createPartition(String catalogId, String databaseName, String tableName, PartitionInput partition, boolean ifNotExists, Boolean needResult) throws Exception {
        return this.call(() -> {
            CreatePartitionRequest request = new CreatePartitionRequest();
            request.catalogId = catalogId;
            request.databaseName = databaseName;
            request.tableName = tableName;
            request.partitionInput = partition;
            request.ifNotExists = ifNotExists;
            request.needResult = needResult;
            CreatePartitionResponseBody response = ((CreatePartitionResponse)this.callWithOptions((ThrowingBiFunction<Map, RuntimeOptions, CreatePartitionResponse, E>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$createPartition$4(com.aliyun.datalake20200710.models.CreatePartitionRequest java.util.Map com.aliyun.teautil.models.RuntimeOptions ), (Ljava/util/Map;Lcom/aliyun/teautil/models/RuntimeOptions;)Lcom/aliyun/datalake20200710/models/CreatePartitionResponse;)((PartitionApi)this, (CreatePartitionRequest)request))).body;
            return new ResultModel<Partition>(response.success, response.code, response.message, response.requestId, response.partition);
        });
    }

    public PartitionBatchResultModel<List<Partition>> batchCreatePartitions(String catalogId, String databaseName, String tableName, List<PartitionInput> partitions, boolean ifNotExists, Boolean needResult) throws Exception {
        return this.batchCall(() -> {
            BatchCreatePartitionsRequest request = new BatchCreatePartitionsRequest();
            request.catalogId = catalogId;
            request.databaseName = databaseName;
            request.tableName = tableName;
            request.ifNotExists = ifNotExists;
            request.needResult = needResult;
            request.partitionInputs = partitions;
            BatchCreatePartitionsResponseBody response = ((BatchCreatePartitionsResponse)this.callWithOptions((ThrowingBiFunction<Map, RuntimeOptions, BatchCreatePartitionsResponse, E>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$batchCreatePartitions$6(com.aliyun.datalake20200710.models.BatchCreatePartitionsRequest java.util.Map com.aliyun.teautil.models.RuntimeOptions ), (Ljava/util/Map;Lcom/aliyun/teautil/models/RuntimeOptions;)Lcom/aliyun/datalake20200710/models/BatchCreatePartitionsResponse;)((PartitionApi)this, (BatchCreatePartitionsRequest)request))).body;
            return new PartitionBatchResultModel<List>((boolean)response.success, response.code, response.message, response.requestId, response.partitions, (List<PartitionError>)response.partitionErrors);
        }, new PartitionBatchResultModel());
    }

    public ResultModel<Void> deletePartition(String catalogId, String databaseName, String tableName, List<String> partValues, boolean ifExists) throws Exception {
        return this.call(() -> {
            DeletePartitionRequest request = new DeletePartitionRequest();
            request.catalogId = catalogId;
            request.databaseName = databaseName;
            request.tableName = tableName;
            request.ifExists = ifExists;
            request.partitionValues = DataLakeUtil.wrapperNullList(partValues);
            DeletePartitionResponseBody response = ((DeletePartitionResponse)this.callWithOptions((ThrowingBiFunction<Map, RuntimeOptions, DeletePartitionResponse, E>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$deletePartition$8(com.aliyun.datalake20200710.models.DeletePartitionRequest java.util.Map com.aliyun.teautil.models.RuntimeOptions ), (Ljava/util/Map;Lcom/aliyun/teautil/models/RuntimeOptions;)Lcom/aliyun/datalake20200710/models/DeletePartitionResponse;)((PartitionApi)this, (DeletePartitionRequest)request))).body;
            return new ResultModel(response.success, response.code, response.message, response.requestId);
        });
    }

    public ResultModel<Void> renamePartition(String catalogName, String databaseName, String tableName, List<String> partitionValues, PartitionInput partition) throws Exception {
        return this.call(() -> {
            RenamePartitionRequest request = new RenamePartitionRequest();
            request.catalogId = catalogName;
            request.databaseName = databaseName;
            request.tableName = tableName;
            request.partitionValues = DataLakeUtil.wrapperNullList(partitionValues);
            request.partitionInput = partition;
            RenamePartitionResponseBody response = ((RenamePartitionResponse)this.callWithOptions((ThrowingBiFunction<Map, RuntimeOptions, RenamePartitionResponse, E>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$renamePartition$10(com.aliyun.datalake20200710.models.RenamePartitionRequest java.util.Map com.aliyun.teautil.models.RuntimeOptions ), (Ljava/util/Map;Lcom/aliyun/teautil/models/RuntimeOptions;)Lcom/aliyun/datalake20200710/models/RenamePartitionResponse;)((PartitionApi)this, (RenamePartitionRequest)request))).body;
            return new ResultModel(response.success, response.code, response.message, response.requestId);
        });
    }

    public ResultModel<PaginatedResult<String>> listPartitionNames(String catalogId, String databaseName, String tableName, List<String> partialPartValues, int pageSize, String nextPageToken) throws Exception {
        return this.call(() -> {
            ListPartitionNamesRequest request = new ListPartitionNamesRequest();
            request.catalogId = catalogId;
            request.databaseName = databaseName;
            request.tableName = tableName;
            request.partialPartValues = DataLakeUtil.wrapperNullList(partialPartValues);
            request.nextPageToken = DataLakeUtil.wrapperNullString(nextPageToken);
            request.pageSize = pageSize;
            ListPartitionNamesResponseBody response = ((ListPartitionNamesResponse)this.callWithOptions((ThrowingBiFunction<Map, RuntimeOptions, ListPartitionNamesResponse, E>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$listPartitionNames$12(com.aliyun.datalake20200710.models.ListPartitionNamesRequest java.util.Map com.aliyun.teautil.models.RuntimeOptions ), (Ljava/util/Map;Lcom/aliyun/teautil/models/RuntimeOptions;)Lcom/aliyun/datalake20200710/models/ListPartitionNamesResponse;)((PartitionApi)this, (ListPartitionNamesRequest)request))).body;
            PaginatedResult result = new PaginatedResult(response.partitionNames, DataLakeUtil.wrapperNullString(response.nextPageToken));
            return new ResultModel(response.success, response.code, response.message, response.requestId, result);
        });
    }

    public ResultModel<PaginatedResult<Partition>> listPartitions(String catalogId, String databaseName, String tableName, List<String> partialPartValues, int pageSize, String nextPageToken, boolean isShareSd) throws Exception {
        return this.call(() -> {
            ListPartitionsRequest request = new ListPartitionsRequest();
            request.catalogId = catalogId;
            request.databaseName = databaseName;
            request.tableName = tableName;
            request.partialPartValues = DataLakeUtil.wrapperNullList(partialPartValues);
            request.pageSize = pageSize;
            request.nextPageToken = DataLakeUtil.wrapperNullString(nextPageToken);
            request.isShareSd = isShareSd;
            ListPartitionsResponseBody response = ((ListPartitionsResponse)this.callWithOptions((ThrowingBiFunction<Map, RuntimeOptions, ListPartitionsResponse, E>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$listPartitions$14(com.aliyun.datalake20200710.models.ListPartitionsRequest java.util.Map com.aliyun.teautil.models.RuntimeOptions ), (Ljava/util/Map;Lcom/aliyun/teautil/models/RuntimeOptions;)Lcom/aliyun/datalake20200710/models/ListPartitionsResponse;)((PartitionApi)this, (ListPartitionsRequest)request))).body;
            this.combinePartitionsWithShareSd(isShareSd, response.partitions, response.partitionSpecs);
            PaginatedResult result = new PaginatedResult(response.partitions, DataLakeUtil.wrapperNullString(response.nextPageToken));
            return new ResultModel(response.success, response.code, response.message, response.requestId, result);
        });
    }

    public ResultModel<PaginatedResult<Partition>> listPartitions(String catalogId, String databaseName, String tableName, List<String> partialPartValues, int pageSize, String nextPageToken) throws Exception {
        return this.listPartitions(catalogId, databaseName, tableName, partialPartValues, pageSize, nextPageToken, true);
    }

    public ResultModel<PaginatedResult<Partition>> listPartitionsByFilter(String catalogId, String databaseName, String tableName, String filter, int pageSize, String nextPageToken, boolean isShareSd) throws Exception {
        return this.call(() -> {
            ListPartitionsByFilterRequest request = new ListPartitionsByFilterRequest();
            request.catalogId = catalogId;
            request.databaseName = databaseName;
            request.tableName = tableName;
            request.filter = filter;
            request.pageSize = pageSize;
            request.nextPageToken = DataLakeUtil.wrapperNullString(nextPageToken);
            request.isShareSd = isShareSd;
            ListPartitionsByFilterResponseBody response = ((ListPartitionsByFilterResponse)this.callWithOptions((ThrowingBiFunction<Map, RuntimeOptions, ListPartitionsByFilterResponse, E>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$listPartitionsByFilter$16(com.aliyun.datalake20200710.models.ListPartitionsByFilterRequest java.util.Map com.aliyun.teautil.models.RuntimeOptions ), (Ljava/util/Map;Lcom/aliyun/teautil/models/RuntimeOptions;)Lcom/aliyun/datalake20200710/models/ListPartitionsByFilterResponse;)((PartitionApi)this, (ListPartitionsByFilterRequest)request))).body;
            this.combinePartitionsWithShareSd(isShareSd, response.partitions, response.partitionSpecs);
            PaginatedResult result = new PaginatedResult(response.partitions, response.nextPageToken);
            return new ResultModel(response.success, response.code, response.message, response.requestId, result);
        });
    }

    public void combinePartitionsWithShareSd(boolean isShareSd, List<Partition> partitions, List<PartitionSpec> partitionSpecs) {
        if (isShareSd && partitionSpecs != null) {
            partitionSpecs.stream().forEach(partitionSpec -> partitionSpec.getSharedSDPartitions().stream().forEach(p -> {
                p.getSd().setCols(partitionSpec.getSharedStorageDescriptor().cols);
                p.getSd().setLocation(partitionSpec.getSharedStorageDescriptor().getLocation() + p.getSd().getLocation());
                partitions.add((Partition)p);
            }));
        }
    }

    public ResultModel<PaginatedResult<Partition>> listPartitionsByFilter(String catalogId, String databaseName, String tableName, String filter, int pageSize, String nextPageToken) throws Exception {
        return this.listPartitionsByFilter(catalogId, databaseName, tableName, filter, pageSize, nextPageToken, false);
    }

    public PartitionBatchResultModel<Void> batchDeletePartitions(String catalogId, String databaseName, String tableName, List<List<String>> partValuesList, boolean ifExists) throws Exception {
        return this.batchCall(() -> {
            BatchDeletePartitionsRequest request = new BatchDeletePartitionsRequest();
            request.catalogId = catalogId;
            request.databaseName = databaseName;
            request.tableName = tableName;
            request.partitionValueList = new ArrayList();
            request.ifExists = ifExists;
            for (List strings : partValuesList) {
                BatchDeletePartitionsRequest.BatchDeletePartitionsRequestPartitionValueList valueList = new BatchDeletePartitionsRequest.BatchDeletePartitionsRequestPartitionValueList();
                valueList.values = strings;
                request.partitionValueList.add(valueList);
            }
            BatchDeletePartitionsResponseBody response = ((BatchDeletePartitionsResponse)this.callWithOptions((ThrowingBiFunction<Map, RuntimeOptions, BatchDeletePartitionsResponse, E>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$batchDeletePartitions$20(com.aliyun.datalake20200710.models.BatchDeletePartitionsRequest java.util.Map com.aliyun.teautil.models.RuntimeOptions ), (Ljava/util/Map;Lcom/aliyun/teautil/models/RuntimeOptions;)Lcom/aliyun/datalake20200710/models/BatchDeletePartitionsResponse;)((PartitionApi)this, (BatchDeletePartitionsRequest)request))).body;
            return new PartitionBatchResultModel<Object>((boolean)response.success, response.code, response.message, response.requestId, null, response.partitionErrors);
        }, new PartitionBatchResultModel());
    }

    public PartitionBatchResultModel<Void> batchUpdatePartitions(String catalogId, String databaseName, String tableName, List<PartitionInput> partitions) throws Exception {
        return this.batchCall(() -> {
            BatchUpdatePartitionsRequest request = new BatchUpdatePartitionsRequest();
            request.catalogId = catalogId;
            request.databaseName = databaseName;
            request.tableName = tableName;
            request.partitionInputs = partitions;
            BatchUpdatePartitionsResponseBody response = ((BatchUpdatePartitionsResponse)this.callWithOptions((ThrowingBiFunction<Map, RuntimeOptions, BatchUpdatePartitionsResponse, E>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$batchUpdatePartitions$22(com.aliyun.datalake20200710.models.BatchUpdatePartitionsRequest java.util.Map com.aliyun.teautil.models.RuntimeOptions ), (Ljava/util/Map;Lcom/aliyun/teautil/models/RuntimeOptions;)Lcom/aliyun/datalake20200710/models/BatchUpdatePartitionsResponse;)((PartitionApi)this, (BatchUpdatePartitionsRequest)request))).body;
            return new PartitionBatchResultModel<Object>((boolean)response.success, response.code, response.message, response.requestId, null, response.partitionErrors);
        }, new PartitionBatchResultModel());
    }

    public ResultModel<Map<String, List<ColumnStatisticsObj>>> getPartitionColumnStatistics(String catalogId, String dbName, String tableName, List<String> partitionNames, List<String> columnNames) throws Exception {
        return this.call(() -> {
            GetPartitionColumnStatisticsRequest request = new GetPartitionColumnStatisticsRequest();
            request.catalogId = catalogId;
            request.databaseName = dbName;
            request.tableName = tableName;
            request.partitionNames = partitionNames;
            request.columnNames = columnNames;
            GetPartitionColumnStatisticsResponseBody response = ((GetPartitionColumnStatisticsResponse)this.callWithOptions((ThrowingBiFunction<Map, RuntimeOptions, GetPartitionColumnStatisticsResponse, E>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$getPartitionColumnStatistics$24(com.aliyun.datalake20200710.models.GetPartitionColumnStatisticsRequest java.util.Map com.aliyun.teautil.models.RuntimeOptions ), (Ljava/util/Map;Lcom/aliyun/teautil/models/RuntimeOptions;)Lcom/aliyun/datalake20200710/models/GetPartitionColumnStatisticsResponse;)((PartitionApi)this, (GetPartitionColumnStatisticsRequest)request))).body;
            return new ResultModel<Map>(response.success, response.code, response.message, response.requestId, response.partitionStatisticsMap);
        });
    }

    public ResultModel<Map<String, List<ColumnStatisticsObj>>> batchGetPartitionColumnStatistics(String catalogId, String dbName, String tableName, List<String> partitionNames, List<String> columnNames) throws Exception {
        return this.call(() -> {
            BatchGetPartitionColumnStatisticsRequest request = new BatchGetPartitionColumnStatisticsRequest();
            request.catalogId = catalogId;
            request.databaseName = dbName;
            request.tableName = tableName;
            request.partitionNames = partitionNames;
            request.columnNames = columnNames;
            BatchGetPartitionColumnStatisticsResponseBody response = ((BatchGetPartitionColumnStatisticsResponse)this.callWithOptions((ThrowingBiFunction<Map, RuntimeOptions, BatchGetPartitionColumnStatisticsResponse, E>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$batchGetPartitionColumnStatistics$26(com.aliyun.datalake20200710.models.BatchGetPartitionColumnStatisticsRequest java.util.Map com.aliyun.teautil.models.RuntimeOptions ), (Ljava/util/Map;Lcom/aliyun/teautil/models/RuntimeOptions;)Lcom/aliyun/datalake20200710/models/BatchGetPartitionColumnStatisticsResponse;)((PartitionApi)this, (BatchGetPartitionColumnStatisticsRequest)request))).body;
            return new ResultModel<Map>(response.success, response.code, response.message, response.requestId, response.partitionStatisticsMap);
        });
    }

    public ResultModel<Boolean> updatePartitionColumnStatistics(UpdateTablePartitionColumnStatisticsRequest columnStatistics) throws Exception {
        return this.call(() -> {
            UpdatePartitionColumnStatisticsRequest request = new UpdatePartitionColumnStatisticsRequest();
            request.setUpdateTablePartitionColumnStatisticsRequest(columnStatistics);
            UpdatePartitionColumnStatisticsResponseBody response = ((UpdatePartitionColumnStatisticsResponse)this.callWithOptions((ThrowingBiFunction<Map, RuntimeOptions, UpdatePartitionColumnStatisticsResponse, E>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$updatePartitionColumnStatistics$28(com.aliyun.datalake20200710.models.UpdatePartitionColumnStatisticsRequest java.util.Map com.aliyun.teautil.models.RuntimeOptions ), (Ljava/util/Map;Lcom/aliyun/teautil/models/RuntimeOptions;)Lcom/aliyun/datalake20200710/models/UpdatePartitionColumnStatisticsResponse;)((PartitionApi)this, (UpdatePartitionColumnStatisticsRequest)request))).body;
            return new ResultModel<Boolean>(response.success, response.code, response.message, response.requestId, response.success);
        });
    }

    public ResultModel<Boolean> deletePartitionColumnStatistics(String catalogId, String dbName, String tableName, List<String> partNames, List<String> colNames) throws Exception {
        return this.call(() -> {
            DeletePartitionColumnStatisticsRequest request = new DeletePartitionColumnStatisticsRequest();
            request.catalogId = catalogId;
            request.databaseName = dbName;
            request.tableName = tableName;
            request.partitionNames = partNames;
            request.columnNames = colNames;
            DeletePartitionColumnStatisticsResponseBody response = ((DeletePartitionColumnStatisticsResponse)this.callWithOptions((ThrowingBiFunction<Map, RuntimeOptions, DeletePartitionColumnStatisticsResponse, E>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$deletePartitionColumnStatistics$30(com.aliyun.datalake20200710.models.DeletePartitionColumnStatisticsRequest java.util.Map com.aliyun.teautil.models.RuntimeOptions ), (Ljava/util/Map;Lcom/aliyun/teautil/models/RuntimeOptions;)Lcom/aliyun/datalake20200710/models/DeletePartitionColumnStatisticsResponse;)((PartitionApi)this, (DeletePartitionColumnStatisticsRequest)request))).body;
            return new ResultModel<Boolean>(response.success, response.code, response.message, response.requestId, response.success);
        });
    }

    private /* synthetic */ DeletePartitionColumnStatisticsResponse lambda$deletePartitionColumnStatistics$30(DeletePartitionColumnStatisticsRequest request, Map h, RuntimeOptions r) throws Exception {
        return this.client.deletePartitionColumnStatisticsWithOptions(request, h, r);
    }

    private /* synthetic */ UpdatePartitionColumnStatisticsResponse lambda$updatePartitionColumnStatistics$28(UpdatePartitionColumnStatisticsRequest request, Map h, RuntimeOptions r) throws Exception {
        return this.client.updatePartitionColumnStatisticsWithOptions(request, h, r);
    }

    private /* synthetic */ BatchGetPartitionColumnStatisticsResponse lambda$batchGetPartitionColumnStatistics$26(BatchGetPartitionColumnStatisticsRequest request, Map h, RuntimeOptions r) throws Exception {
        return this.client.batchGetPartitionColumnStatisticsWithOptions(request, h, r);
    }

    private /* synthetic */ GetPartitionColumnStatisticsResponse lambda$getPartitionColumnStatistics$24(GetPartitionColumnStatisticsRequest request, Map h, RuntimeOptions r) throws Exception {
        return this.client.getPartitionColumnStatisticsWithOptions(request, h, r);
    }

    private /* synthetic */ BatchUpdatePartitionsResponse lambda$batchUpdatePartitions$22(BatchUpdatePartitionsRequest request, Map h, RuntimeOptions r) throws Exception {
        return this.client.batchUpdatePartitionsWithOptions(request, h, r);
    }

    private /* synthetic */ BatchDeletePartitionsResponse lambda$batchDeletePartitions$20(BatchDeletePartitionsRequest request, Map h, RuntimeOptions r) throws Exception {
        return this.client.batchDeletePartitionsWithOptions(request, h, r);
    }

    private /* synthetic */ ListPartitionsByFilterResponse lambda$listPartitionsByFilter$16(ListPartitionsByFilterRequest request, Map h, RuntimeOptions r) throws Exception {
        return this.client.listPartitionsByFilterWithOptions(request, h, r);
    }

    private /* synthetic */ ListPartitionsResponse lambda$listPartitions$14(ListPartitionsRequest request, Map h, RuntimeOptions r) throws Exception {
        return this.client.listPartitionsWithOptions(request, h, r);
    }

    private /* synthetic */ ListPartitionNamesResponse lambda$listPartitionNames$12(ListPartitionNamesRequest request, Map h, RuntimeOptions r) throws Exception {
        return this.client.listPartitionNamesWithOptions(request, h, r);
    }

    private /* synthetic */ RenamePartitionResponse lambda$renamePartition$10(RenamePartitionRequest request, Map h, RuntimeOptions r) throws Exception {
        return this.client.renamePartitionWithOptions(request, h, r);
    }

    private /* synthetic */ DeletePartitionResponse lambda$deletePartition$8(DeletePartitionRequest request, Map h, RuntimeOptions r) throws Exception {
        return this.client.deletePartitionWithOptions(request, h, r);
    }

    private /* synthetic */ BatchCreatePartitionsResponse lambda$batchCreatePartitions$6(BatchCreatePartitionsRequest request, Map h, RuntimeOptions r) throws Exception {
        return this.client.batchCreatePartitionsWithOptions(request, h, r);
    }

    private /* synthetic */ CreatePartitionResponse lambda$createPartition$4(CreatePartitionRequest request, Map h, RuntimeOptions r) throws Exception {
        return this.client.createPartitionWithOptions(request, h, r);
    }

    private /* synthetic */ BatchGetPartitionsResponse lambda$batchGetPartitions$2(BatchGetPartitionsRequest request, Map h, RuntimeOptions r) throws Exception {
        return this.client.batchGetPartitionsWithOptions(request, h, r);
    }

    private /* synthetic */ GetPartitionResponse lambda$getPartition$0(GetPartitionRequest request, Map h, RuntimeOptions r) throws Exception {
        return this.client.getPartitionWithOptions(request, h, r);
    }
}

