/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datalake.metastore.common.api;

import com.aliyun.datalake.metastore.common.api.AbstractBaseApi;
import com.aliyun.datalake.metastore.common.entity.PaginatedResult;
import com.aliyun.datalake.metastore.common.entity.ResultModel;
import com.aliyun.datalake.metastore.common.functional.ThrowingBiFunction;
import com.aliyun.datalake.metastore.common.util.DataLakeUtil;
import com.aliyun.datalake20200710.Client;
import com.aliyun.datalake20200710.models.BatchGetTablesRequest;
import com.aliyun.datalake20200710.models.BatchGetTablesResponse;
import com.aliyun.datalake20200710.models.BatchGetTablesResponseBody;
import com.aliyun.datalake20200710.models.ColumnStatisticsObj;
import com.aliyun.datalake20200710.models.CreateLockRequest;
import com.aliyun.datalake20200710.models.CreateLockResponse;
import com.aliyun.datalake20200710.models.CreateLockResponseBody;
import com.aliyun.datalake20200710.models.CreateTableRequest;
import com.aliyun.datalake20200710.models.CreateTableResponse;
import com.aliyun.datalake20200710.models.CreateTableResponseBody;
import com.aliyun.datalake20200710.models.DeleteTableColumnStatisticsRequest;
import com.aliyun.datalake20200710.models.DeleteTableColumnStatisticsResponse;
import com.aliyun.datalake20200710.models.DeleteTableColumnStatisticsResponseBody;
import com.aliyun.datalake20200710.models.DeleteTableRequest;
import com.aliyun.datalake20200710.models.DeleteTableResponse;
import com.aliyun.datalake20200710.models.DeleteTableResponseBody;
import com.aliyun.datalake20200710.models.GetAsyncTaskStatusRequest;
import com.aliyun.datalake20200710.models.GetAsyncTaskStatusResponse;
import com.aliyun.datalake20200710.models.GetAsyncTaskStatusResponseBody;
import com.aliyun.datalake20200710.models.GetLockRequest;
import com.aliyun.datalake20200710.models.GetLockResponse;
import com.aliyun.datalake20200710.models.GetLockResponseBody;
import com.aliyun.datalake20200710.models.GetTableColumnStatisticsRequest;
import com.aliyun.datalake20200710.models.GetTableColumnStatisticsResponse;
import com.aliyun.datalake20200710.models.GetTableColumnStatisticsResponseBody;
import com.aliyun.datalake20200710.models.GetTableRequest;
import com.aliyun.datalake20200710.models.GetTableResponse;
import com.aliyun.datalake20200710.models.GetTableResponseBody;
import com.aliyun.datalake20200710.models.ListTableNamesRequest;
import com.aliyun.datalake20200710.models.ListTableNamesResponse;
import com.aliyun.datalake20200710.models.ListTableNamesResponseBody;
import com.aliyun.datalake20200710.models.ListTablesRequest;
import com.aliyun.datalake20200710.models.ListTablesResponse;
import com.aliyun.datalake20200710.models.ListTablesResponseBody;
import com.aliyun.datalake20200710.models.LockObj;
import com.aliyun.datalake20200710.models.LockStatus;
import com.aliyun.datalake20200710.models.RefreshLockRequest;
import com.aliyun.datalake20200710.models.RefreshLockResponse;
import com.aliyun.datalake20200710.models.RefreshLockResponseBody;
import com.aliyun.datalake20200710.models.RenameTableRequest;
import com.aliyun.datalake20200710.models.RenameTableResponse;
import com.aliyun.datalake20200710.models.RenameTableResponseBody;
import com.aliyun.datalake20200710.models.Table;
import com.aliyun.datalake20200710.models.TableInput;
import com.aliyun.datalake20200710.models.TaskStatus;
import com.aliyun.datalake20200710.models.UnLockRequest;
import com.aliyun.datalake20200710.models.UnLockResponse;
import com.aliyun.datalake20200710.models.UnLockResponseBody;
import com.aliyun.datalake20200710.models.UpdateTableColumnStatisticsRequest;
import com.aliyun.datalake20200710.models.UpdateTableColumnStatisticsResponse;
import com.aliyun.datalake20200710.models.UpdateTableColumnStatisticsResponseBody;
import com.aliyun.datalake20200710.models.UpdateTablePartitionColumnStatisticsRequest;
import com.aliyun.datalake20200710.models.UpdateTableRequest;
import com.aliyun.datalake20200710.models.UpdateTableResponse;
import com.aliyun.datalake20200710.models.UpdateTableResponseBody;
import com.aliyun.teautil.models.RuntimeOptions;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableApi
extends AbstractBaseApi {
    private static ThreadLocal<HashMap<Long, List<String>>> threadLocalTableLockInfoReverse = new ThreadLocal();
    private static ThreadLocal<HashMap<String, Long>> threadLocalTableLockInfo = new ThreadLocal();
    private static String LOCK_HEADER_KEY = "metastore-lock-id";

    public TableApi(Client client) {
        super(client);
    }

    public ResultModel<Void> createTable(String catalogId, String databaseName, TableInput table) throws Exception {
        return this.call(() -> {
            CreateTableRequest request = new CreateTableRequest();
            request.catalogId = catalogId;
            request.databaseName = databaseName;
            request.tableInput = table;
            RuntimeOptions runtime = new RuntimeOptions();
            HashMap<String, String> headers = new HashMap<String, String>();
            this.setLockId(catalogId, databaseName, table.getTableName(), headers);
            CreateTableResponseBody response = ((CreateTableResponse)this.callWithOptions((ThrowingBiFunction<Map, RuntimeOptions, CreateTableResponse, E>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$createTable$0(com.aliyun.datalake20200710.models.CreateTableRequest java.util.Map com.aliyun.teautil.models.RuntimeOptions ), (Ljava/util/Map;Lcom/aliyun/teautil/models/RuntimeOptions;)Lcom/aliyun/datalake20200710/models/CreateTableResponse;)((TableApi)this, (CreateTableRequest)request), headers, (RuntimeOptions)runtime)).body;
            return new ResultModel(response.success, response.code, response.message, response.requestId);
        });
    }

    public ResultModel<String> updateTable(String catalogId, String databaseName, TableInput table) throws Exception {
        return this.updateTable(catalogId, databaseName, table, false, false);
    }

    public ResultModel<String> updateTable(String catalogId, String databaseName, TableInput table, boolean cascade, boolean isAsync) throws Exception {
        return this.call(() -> {
            UpdateTableRequest request = new UpdateTableRequest();
            request.catalogId = catalogId;
            request.databaseName = databaseName;
            request.tableName = table.tableName;
            table.cascade = cascade;
            request.tableInput = table;
            request.isAsync = isAsync;
            RuntimeOptions runtime = new RuntimeOptions();
            HashMap<String, String> headers = new HashMap<String, String>();
            this.setLockId(catalogId, databaseName, table.getTableName(), headers);
            UpdateTableResponseBody response = ((UpdateTableResponse)this.callWithOptions((ThrowingBiFunction<Map, RuntimeOptions, UpdateTableResponse, E>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$updateTable$2(com.aliyun.datalake20200710.models.UpdateTableRequest java.util.Map com.aliyun.teautil.models.RuntimeOptions ), (Ljava/util/Map;Lcom/aliyun/teautil/models/RuntimeOptions;)Lcom/aliyun/datalake20200710/models/UpdateTableResponse;)((TableApi)this, (UpdateTableRequest)request), headers, (RuntimeOptions)runtime)).body;
            return new ResultModel<String>(response.success, response.code, response.message, response.requestId, response.taskId);
        });
    }

    public void setLockId(String catalogId, String databaseName, String tableName, Map<String, String> headers) {
        Long lockId = this.getTableLock().get(this.toTableName(catalogId, databaseName, tableName));
        if (lockId != null && lockId > 0L) {
            headers.put(LOCK_HEADER_KEY, String.valueOf(lockId));
        }
    }

    public ResultModel<Table> getTable(String catalogId, String databaseName, String tableName) throws Exception {
        return this.call(() -> {
            GetTableRequest request = new GetTableRequest();
            request.catalogId = catalogId;
            request.databaseName = databaseName;
            request.tableName = tableName;
            RuntimeOptions runtime = new RuntimeOptions();
            HashMap<String, String> headers = new HashMap<String, String>();
            this.setLockId(catalogId, databaseName, tableName, headers);
            GetTableResponseBody response = ((GetTableResponse)this.callWithOptions((ThrowingBiFunction<Map, RuntimeOptions, GetTableResponse, E>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$getTable$4(com.aliyun.datalake20200710.models.GetTableRequest java.util.Map com.aliyun.teautil.models.RuntimeOptions ), (Ljava/util/Map;Lcom/aliyun/teautil/models/RuntimeOptions;)Lcom/aliyun/datalake20200710/models/GetTableResponse;)((TableApi)this, (GetTableRequest)request), headers, (RuntimeOptions)runtime)).body;
            return new ResultModel<Table>(response.success, response.code, response.message, response.requestId, response.table);
        });
    }

    public ResultModel<List<Table>> getTableObjectsByName(String catalogId, String databaseName, List<String> tableNames) throws Exception {
        return this.call(() -> {
            ArrayList<Table> tables = new ArrayList<Table>();
            String lastReq = null;
            for (String tableName : tableNames) {
                ResultModel<Table> table = this.getTable(catalogId, databaseName, tableName);
                if (table.success) {
                    tables.add((Table)table.data);
                    lastReq = table.requestId;
                    continue;
                }
                return new ResultModel(false, table.code, table.message, table.requestId);
            }
            return new ResultModel(true, "", "", lastReq, tables);
        });
    }

    public ResultModel<PaginatedResult<Table>> getTableObjects(String catalogId, String databaseName, String tableNamePattern, int pageSize, String nextPageToken, String tableType) throws Exception {
        return this.call(() -> {
            ListTablesRequest request = new ListTablesRequest();
            request.catalogId = catalogId;
            request.databaseName = databaseName;
            request.tableNamePattern = DataLakeUtil.wrapperPatternString(tableNamePattern);
            request.nextPageToken = DataLakeUtil.wrapperNullString(nextPageToken);
            request.pageSize = pageSize;
            request.tableType = tableType;
            ListTablesResponseBody response = ((ListTablesResponse)this.callWithOptions((ThrowingBiFunction<Map, RuntimeOptions, ListTablesResponse, E>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$getTableObjects$7(com.aliyun.datalake20200710.models.ListTablesRequest java.util.Map com.aliyun.teautil.models.RuntimeOptions ), (Ljava/util/Map;Lcom/aliyun/teautil/models/RuntimeOptions;)Lcom/aliyun/datalake20200710/models/ListTablesResponse;)((TableApi)this, (ListTablesRequest)request))).body;
            PaginatedResult result = new PaginatedResult(response.tables, DataLakeUtil.wrapperNullString(response.nextPageToken));
            return new ResultModel(response.success, response.code, response.message, response.requestId, result);
        });
    }

    public ResultModel<List<Table>> getTableObjects(String catalogId, String databaseName, List<String> tableNames) throws Exception {
        return this.call(() -> {
            BatchGetTablesRequest request = new BatchGetTablesRequest();
            request.setCatalogId(catalogId);
            request.setDatabaseName(databaseName);
            request.setTableNames(tableNames);
            BatchGetTablesResponseBody response = ((BatchGetTablesResponse)this.callWithOptions((ThrowingBiFunction<Map, RuntimeOptions, BatchGetTablesResponse, E>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$getTableObjects$9(com.aliyun.datalake20200710.models.BatchGetTablesRequest java.util.Map com.aliyun.teautil.models.RuntimeOptions ), (Ljava/util/Map;Lcom/aliyun/teautil/models/RuntimeOptions;)Lcom/aliyun/datalake20200710/models/BatchGetTablesResponse;)((TableApi)this, (BatchGetTablesRequest)request))).body;
            return new ResultModel<List>(response.success, response.code, response.message, response.requestId, response.tables);
        });
    }

    public ResultModel<PaginatedResult<String>> getTables(String catalogId, String databaseName, String tableNamePattern, int pageSize, String nextPageToken, String tableType) throws Exception {
        return this.call(() -> {
            ListTableNamesRequest request = new ListTableNamesRequest();
            request.catalogId = catalogId;
            request.databaseName = databaseName;
            request.tableNamePattern = DataLakeUtil.wrapperPatternString(tableNamePattern);
            request.nextPageToken = DataLakeUtil.wrapperNullString(nextPageToken);
            request.pageSize = pageSize;
            request.tableType = tableType;
            ListTableNamesResponseBody response = ((ListTableNamesResponse)this.callWithOptions((ThrowingBiFunction<Map, RuntimeOptions, ListTableNamesResponse, E>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$getTables$11(com.aliyun.datalake20200710.models.ListTableNamesRequest java.util.Map com.aliyun.teautil.models.RuntimeOptions ), (Ljava/util/Map;Lcom/aliyun/teautil/models/RuntimeOptions;)Lcom/aliyun/datalake20200710/models/ListTableNamesResponse;)((TableApi)this, (ListTableNamesRequest)request))).body;
            PaginatedResult result = new PaginatedResult(response.tableNames, DataLakeUtil.wrapperNullString(response.nextPageToken));
            return new ResultModel(response.success, response.code, response.message, response.requestId, result);
        });
    }

    public ResultModel<String> renameTable(String catalogId, String databaseName, String tableName, TableInput table, Boolean isAsync) throws Exception {
        return this.call(() -> {
            RenameTableRequest request = new RenameTableRequest();
            request.catalogId = catalogId;
            request.databaseName = databaseName;
            request.tableName = tableName;
            request.setIsAsync(isAsync);
            request.tableInput = table;
            RuntimeOptions runtime = new RuntimeOptions();
            HashMap<String, String> headers = new HashMap<String, String>();
            this.setLockId(catalogId, databaseName, table.getTableName(), headers);
            RenameTableResponseBody response = ((RenameTableResponse)this.callWithOptions((ThrowingBiFunction<Map, RuntimeOptions, RenameTableResponse, E>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$renameTable$13(com.aliyun.datalake20200710.models.RenameTableRequest java.util.Map com.aliyun.teautil.models.RuntimeOptions ), (Ljava/util/Map;Lcom/aliyun/teautil/models/RuntimeOptions;)Lcom/aliyun/datalake20200710/models/RenameTableResponse;)((TableApi)this, (RenameTableRequest)request), headers, (RuntimeOptions)runtime)).body;
            return new ResultModel<String>(response.success, response.code, response.message, response.requestId, response.taskId);
        });
    }

    public ResultModel<Void> deleteTable(String catalogId, String databaseName, String tableName) throws Exception {
        return this.call(() -> {
            DeleteTableRequest request = new DeleteTableRequest();
            request.catalogId = catalogId;
            request.databaseName = databaseName;
            request.tableName = tableName;
            RuntimeOptions runtime = new RuntimeOptions();
            HashMap<String, String> headers = new HashMap<String, String>();
            this.setLockId(catalogId, databaseName, tableName, headers);
            DeleteTableResponseBody response = ((DeleteTableResponse)this.callWithOptions((ThrowingBiFunction<Map, RuntimeOptions, DeleteTableResponse, E>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$deleteTable$15(com.aliyun.datalake20200710.models.DeleteTableRequest java.util.Map com.aliyun.teautil.models.RuntimeOptions ), (Ljava/util/Map;Lcom/aliyun/teautil/models/RuntimeOptions;)Lcom/aliyun/datalake20200710/models/DeleteTableResponse;)((TableApi)this, (DeleteTableRequest)request), headers, (RuntimeOptions)runtime)).body;
            return new ResultModel(response.success, response.code, response.message, response.requestId);
        });
    }

    public ResultModel<List<ColumnStatisticsObj>> getTableColumnStatistics(String catalogId, String dbName, String tableName, List<String> columnNames) throws Exception {
        return this.call(() -> {
            GetTableColumnStatisticsRequest request = new GetTableColumnStatisticsRequest();
            request.catalogId = catalogId;
            request.databaseName = dbName;
            request.tableName = tableName;
            request.columnNames = columnNames;
            GetTableColumnStatisticsResponseBody response = ((GetTableColumnStatisticsResponse)this.callWithOptions((ThrowingBiFunction<Map, RuntimeOptions, GetTableColumnStatisticsResponse, E>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$getTableColumnStatistics$17(com.aliyun.datalake20200710.models.GetTableColumnStatisticsRequest java.util.Map com.aliyun.teautil.models.RuntimeOptions ), (Ljava/util/Map;Lcom/aliyun/teautil/models/RuntimeOptions;)Lcom/aliyun/datalake20200710/models/GetTableColumnStatisticsResponse;)((TableApi)this, (GetTableColumnStatisticsRequest)request))).body;
            return new ResultModel<List>(response.success, response.code, response.message, response.requestId, response.columnStatisticsObjList);
        });
    }

    public ResultModel<Boolean> updateTableColumnStatistics(UpdateTablePartitionColumnStatisticsRequest columnStatistics) throws Exception {
        return this.call(() -> {
            UpdateTableColumnStatisticsRequest request = new UpdateTableColumnStatisticsRequest();
            request.setUpdateTablePartitionColumnStatisticsRequest(columnStatistics);
            UpdateTableColumnStatisticsResponseBody response = ((UpdateTableColumnStatisticsResponse)this.callWithOptions((ThrowingBiFunction<Map, RuntimeOptions, UpdateTableColumnStatisticsResponse, E>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$updateTableColumnStatistics$19(com.aliyun.datalake20200710.models.UpdateTableColumnStatisticsRequest java.util.Map com.aliyun.teautil.models.RuntimeOptions ), (Ljava/util/Map;Lcom/aliyun/teautil/models/RuntimeOptions;)Lcom/aliyun/datalake20200710/models/UpdateTableColumnStatisticsResponse;)((TableApi)this, (UpdateTableColumnStatisticsRequest)request))).body;
            return new ResultModel<Boolean>(response.success, response.code, response.message, response.requestId, response.success);
        });
    }

    public ResultModel<Boolean> deleteTableColumnStatistics(String catalogId, String dbName, String tableName, List<String> colNames) throws Exception {
        return this.call(() -> {
            DeleteTableColumnStatisticsRequest request = new DeleteTableColumnStatisticsRequest();
            request.catalogId = catalogId;
            request.databaseName = dbName;
            request.tableName = tableName;
            request.columnNames = colNames;
            DeleteTableColumnStatisticsResponseBody response = ((DeleteTableColumnStatisticsResponse)this.callWithOptions((ThrowingBiFunction<Map, RuntimeOptions, DeleteTableColumnStatisticsResponse, E>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$deleteTableColumnStatistics$21(com.aliyun.datalake20200710.models.DeleteTableColumnStatisticsRequest java.util.Map com.aliyun.teautil.models.RuntimeOptions ), (Ljava/util/Map;Lcom/aliyun/teautil/models/RuntimeOptions;)Lcom/aliyun/datalake20200710/models/DeleteTableColumnStatisticsResponse;)((TableApi)this, (DeleteTableColumnStatisticsRequest)request))).body;
            return new ResultModel<Boolean>(response.success, response.code, response.message, response.requestId, response.success);
        });
    }

    public ResultModel<LockStatus> lock(List<LockObj> lockObjList) throws Exception {
        return this.call(() -> {
            CreateLockRequest request = new CreateLockRequest();
            request.setLockObjList(lockObjList);
            CreateLockResponseBody response = ((CreateLockResponse)this.callWithOptions((ThrowingBiFunction<Map, RuntimeOptions, CreateLockResponse, E>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$lock$23(com.aliyun.datalake20200710.models.CreateLockRequest java.util.Map com.aliyun.teautil.models.RuntimeOptions ), (Ljava/util/Map;Lcom/aliyun/teautil/models/RuntimeOptions;)Lcom/aliyun/datalake20200710/models/CreateLockResponse;)((TableApi)this, (CreateLockRequest)request))).body;
            if (response != null && response.success.booleanValue() && response.lockStatus != null && "ACQUIRED".equals(response.lockStatus.getLockState())) {
                this.addLockId(lockObjList, response.lockStatus.getLockId());
            }
            return new ResultModel<LockStatus>(response.success, response.code, response.message, response.requestId, response.lockStatus);
        });
    }

    public ResultModel<Boolean> unLock(Long lockId) throws Exception {
        return this.call(() -> {
            UnLockRequest request = new UnLockRequest();
            request.setLockId(lockId);
            this.removeLockId(lockId);
            UnLockResponseBody response = ((UnLockResponse)this.callWithOptions((ThrowingBiFunction<Map, RuntimeOptions, UnLockResponse, E>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$unLock$25(com.aliyun.datalake20200710.models.UnLockRequest java.util.Map com.aliyun.teautil.models.RuntimeOptions ), (Ljava/util/Map;Lcom/aliyun/teautil/models/RuntimeOptions;)Lcom/aliyun/datalake20200710/models/UnLockResponse;)((TableApi)this, (UnLockRequest)request))).body;
            return new ResultModel<Boolean>(response.success, response.code, response.message, response.requestId, response.success);
        });
    }

    public ResultModel<LockStatus> getLock(Long lockId) throws Exception {
        return this.call(() -> {
            GetLockRequest request = new GetLockRequest();
            request.setLockId(lockId);
            GetLockResponseBody response = ((GetLockResponse)this.callWithOptions((ThrowingBiFunction<Map, RuntimeOptions, GetLockResponse, E>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$getLock$27(com.aliyun.datalake20200710.models.GetLockRequest java.util.Map com.aliyun.teautil.models.RuntimeOptions ), (Ljava/util/Map;Lcom/aliyun/teautil/models/RuntimeOptions;)Lcom/aliyun/datalake20200710/models/GetLockResponse;)((TableApi)this, (GetLockRequest)request))).body;
            return new ResultModel<LockStatus>(response.success, response.code, response.message, response.requestId, response.lockStatus);
        });
    }

    public ResultModel<Boolean> refreshLock(Long lockId) throws Exception {
        return this.call(() -> {
            RefreshLockRequest request = new RefreshLockRequest();
            request.setLockId(lockId);
            RefreshLockResponseBody response = ((RefreshLockResponse)this.callWithOptions((ThrowingBiFunction<Map, RuntimeOptions, RefreshLockResponse, E>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$refreshLock$29(com.aliyun.datalake20200710.models.RefreshLockRequest java.util.Map com.aliyun.teautil.models.RuntimeOptions ), (Ljava/util/Map;Lcom/aliyun/teautil/models/RuntimeOptions;)Lcom/aliyun/datalake20200710/models/RefreshLockResponse;)((TableApi)this, (RefreshLockRequest)request))).body;
            return new ResultModel<Boolean>(response.success, response.code, response.message, response.requestId, response.success);
        });
    }

    private HashMap<Long, List<String>> getTableLockReverse() {
        HashMap<Long, List<String>> lockTables = threadLocalTableLockInfoReverse.get();
        if (lockTables == null) {
            lockTables = new HashMap();
            threadLocalTableLockInfoReverse.set(lockTables);
        }
        return lockTables;
    }

    private HashMap<String, Long> getTableLock() {
        HashMap<String, Long> lockTables = threadLocalTableLockInfo.get();
        if (lockTables == null) {
            lockTables = new HashMap();
            threadLocalTableLockInfo.set(lockTables);
        }
        return lockTables;
    }

    private void removeLockId(Long lockId) {
        if (lockId != null) {
            List<String> tableNames = this.getTableLockReverse().get(lockId);
            if (tableNames != null) {
                for (String table : tableNames) {
                    this.getTableLock().remove(table);
                }
            }
            this.getTableLockReverse().remove(lockId);
        }
    }

    private void addLockId(List<LockObj> lockObjList, Long lockId) {
        ArrayList<String> tableNames = new ArrayList<String>();
        for (LockObj lockObj : lockObjList) {
            String tableName = this.toTableName(lockObj.getCatalogId(), lockObj.getDatabaseName(), lockObj.getTableName());
            tableNames.add(tableName);
            this.getTableLock().put(tableName, lockId);
        }
        this.getTableLockReverse().put(lockId, tableNames);
    }

    private String toTableName(String catalogId, String databaseName, String tableName) {
        tableName = catalogId + "." + databaseName + "." + tableName;
        return tableName;
    }

    public ResultModel<TaskStatus> getRenameStatus(String catalogId, String taskId) throws Exception {
        return this.call(() -> {
            GetAsyncTaskStatusRequest getAsyncTaskStatusRequest = new GetAsyncTaskStatusRequest();
            getAsyncTaskStatusRequest.setCatalogId(catalogId);
            getAsyncTaskStatusRequest.setTaskId(taskId);
            GetAsyncTaskStatusResponseBody response = ((GetAsyncTaskStatusResponse)this.callWithOptions((ThrowingBiFunction<Map, RuntimeOptions, GetAsyncTaskStatusResponse, E>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$getRenameStatus$31(com.aliyun.datalake20200710.models.GetAsyncTaskStatusRequest java.util.Map com.aliyun.teautil.models.RuntimeOptions ), (Ljava/util/Map;Lcom/aliyun/teautil/models/RuntimeOptions;)Lcom/aliyun/datalake20200710/models/GetAsyncTaskStatusResponse;)((TableApi)this, (GetAsyncTaskStatusRequest)getAsyncTaskStatusRequest))).body;
            return new ResultModel<TaskStatus>(response.success, response.code, response.message, response.requestId, response.taskStatus);
        });
    }

    private /* synthetic */ GetAsyncTaskStatusResponse lambda$getRenameStatus$31(GetAsyncTaskStatusRequest getAsyncTaskStatusRequest, Map h, RuntimeOptions r) throws Exception {
        return this.client.getAsyncTaskStatusWithOptions(getAsyncTaskStatusRequest, h, r);
    }

    private /* synthetic */ RefreshLockResponse lambda$refreshLock$29(RefreshLockRequest request, Map h, RuntimeOptions r) throws Exception {
        return this.client.refreshLockWithOptions(request, h, r);
    }

    private /* synthetic */ GetLockResponse lambda$getLock$27(GetLockRequest request, Map h, RuntimeOptions r) throws Exception {
        return this.client.getLockWithOptions(request, h, r);
    }

    private /* synthetic */ UnLockResponse lambda$unLock$25(UnLockRequest request, Map h, RuntimeOptions r) throws Exception {
        return this.client.unLockWithOptions(request, h, r);
    }

    private /* synthetic */ CreateLockResponse lambda$lock$23(CreateLockRequest request, Map h, RuntimeOptions r) throws Exception {
        return this.client.createLockWithOptions(request, h, r);
    }

    private /* synthetic */ DeleteTableColumnStatisticsResponse lambda$deleteTableColumnStatistics$21(DeleteTableColumnStatisticsRequest request, Map h, RuntimeOptions r) throws Exception {
        return this.client.deleteTableColumnStatisticsWithOptions(request, h, r);
    }

    private /* synthetic */ UpdateTableColumnStatisticsResponse lambda$updateTableColumnStatistics$19(UpdateTableColumnStatisticsRequest request, Map h, RuntimeOptions r) throws Exception {
        return this.client.updateTableColumnStatisticsWithOptions(request, h, r);
    }

    private /* synthetic */ GetTableColumnStatisticsResponse lambda$getTableColumnStatistics$17(GetTableColumnStatisticsRequest request, Map h, RuntimeOptions r) throws Exception {
        return this.client.getTableColumnStatisticsWithOptions(request, h, r);
    }

    private /* synthetic */ DeleteTableResponse lambda$deleteTable$15(DeleteTableRequest request, Map h, RuntimeOptions r) throws Exception {
        return this.client.deleteTableWithOptions(request, h, r);
    }

    private /* synthetic */ RenameTableResponse lambda$renameTable$13(RenameTableRequest request, Map h, RuntimeOptions r) throws Exception {
        return this.client.renameTableWithOptions(request, h, r);
    }

    private /* synthetic */ ListTableNamesResponse lambda$getTables$11(ListTableNamesRequest request, Map h, RuntimeOptions r) throws Exception {
        return this.client.listTableNamesWithOptions(request, h, r);
    }

    private /* synthetic */ BatchGetTablesResponse lambda$getTableObjects$9(BatchGetTablesRequest request, Map h, RuntimeOptions r) throws Exception {
        return this.client.batchGetTablesWithOptions(request, h, r);
    }

    private /* synthetic */ ListTablesResponse lambda$getTableObjects$7(ListTablesRequest request, Map h, RuntimeOptions r) throws Exception {
        return this.client.listTablesWithOptions(request, h, r);
    }

    private /* synthetic */ GetTableResponse lambda$getTable$4(GetTableRequest request, Map h, RuntimeOptions r) throws Exception {
        return this.client.getTableWithOptions(request, h, r);
    }

    private /* synthetic */ UpdateTableResponse lambda$updateTable$2(UpdateTableRequest request, Map h, RuntimeOptions r) throws Exception {
        return this.client.updateTableWithOptions(request, h, r);
    }

    private /* synthetic */ CreateTableResponse lambda$createTable$0(CreateTableRequest request, Map h, RuntimeOptions r) throws Exception {
        return this.client.createTableWithOptions(request, h, r);
    }
}

