/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datalake.metastore.common.util;

import com.aliyun.datalake.metastore.common.ProxyMode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.Sets;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyLogUtils {
    private static final Logger logger = LoggerFactory.getLogger(ProxyLogUtils.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static ProxyLogUtils proxyLogUtils;
    private static final Set<String> ignoreActionLogging;
    private static final int DEFAULT_LOG_SIZE = 1024;
    private String logStore;
    private boolean recordActionLog;
    private boolean recordLog;

    public ProxyLogUtils(String logStore, boolean recordActionLog, boolean recordLog) {
        this.logStore = logStore == null ? "default" : logStore;
        this.recordActionLog = recordActionLog;
        this.recordLog = recordLog;
    }

    public static String toJson(Object object) {
        try {
            return OBJECT_MAPPER.writeValueAsString(object);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return e.getMessage();
        }
    }

    public static synchronized void initLogUtils(ProxyMode proxyMode, String logStore, boolean recordActionLog, boolean recordLog) {
        if (proxyLogUtils != null) {
            return;
        }
        logger.info("init LogUtils with proxyMode:{}", (Object)proxyMode);
        proxyLogUtils = new ProxyLogUtils(logStore, recordActionLog, recordLog);
    }

    public static boolean ignoreLogParameters(String actionName) {
        return ignoreActionLogging.contains(actionName);
    }

    public static String getActionParametersString(String actionName, Object ... parameters) {
        ProxyLogUtils proxyLogUtils = ProxyLogUtils.getProxyLogUtils();
        if (proxyLogUtils == null || !proxyLogUtils.recordActionLog) {
            return "";
        }
        if (ProxyLogUtils.ignoreLogParameters(actionName)) {
            return "";
        }
        String paramJson = ProxyLogUtils.toJson(parameters);
        return paramJson.length() > 1024 ? paramJson.substring(0, 1024) : paramJson;
    }

    public static void setProxyLogUtils(ProxyLogUtils proxyLogUtils) {
        ProxyLogUtils.proxyLogUtils = proxyLogUtils;
    }

    public static ProxyLogUtils getProxyLogUtils() {
        return proxyLogUtils;
    }

    public static void writeLog(Exception e, String actionName, Object ... parameters) {
        try {
            ProxyLogUtils proxyLogUtils = ProxyLogUtils.getProxyLogUtils();
            if (proxyLogUtils == null) {
                return;
            }
            String message = e.getMessage();
            String stack = ProxyLogUtils.getStackTrace(e);
            proxyLogUtils.writeLog2Sls(actionName, message, stack, parameters);
        }
        catch (Exception e1) {
            logger.error(e1.getMessage(), (Throwable)e1);
        }
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    public void writeLog2Sls(String actionName, String message, String stack, Object ... parameters) {
        String parameterString = ProxyLogUtils.toJson(parameters);
        parameterString = parameterString.length() > 1024 ? parameterString.substring(0, 1024) : parameterString;
        logger.warn("dlf_error, uid: {}, actionName: {}, message: {}, stack:{}, parameters: {}", new Object[]{this.logStore, actionName, message, stack, parameterString});
    }

    public static void printLog(Runnable log) {
        ProxyLogUtils proxyUtils = ProxyLogUtils.getProxyLogUtils();
        if (proxyUtils.recordLog) {
            log.run();
        }
    }

    public boolean isRecordActionLog() {
        return this.recordActionLog;
    }

    public boolean isRecordLog() {
        return this.recordLog;
    }

    static {
        ignoreActionLogging = Sets.newHashSet((Object[])new String[]{"updateTableColumnStatistics", "isCompatibleWith"});
        SimpleModule m = new SimpleModule();
        OBJECT_MAPPER.registerModule((Module)m);
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

