/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.oss.common.utils;

import android.util.Base64;
import android.util.Pair;
import android.webkit.MimeTypeMap;
import com.alibaba.sdk.android.oss.common.OSSConstants;
import com.alibaba.sdk.android.oss.common.OSSLog;
import com.alibaba.sdk.android.oss.common.auth.HmacSHA1Signature;
import com.alibaba.sdk.android.oss.common.auth.OSSCredentialProvider;
import com.alibaba.sdk.android.oss.common.auth.OSSCustomSignerCredentialProvider;
import com.alibaba.sdk.android.oss.common.auth.OSSFederationCredentialProvider;
import com.alibaba.sdk.android.oss.common.auth.OSSFederationToken;
import com.alibaba.sdk.android.oss.common.auth.OSSPlainTextAKSKCredentialProvider;
import com.alibaba.sdk.android.oss.common.utils.DateUtil;
import com.alibaba.sdk.android.oss.common.utils.HttpUtil;
import com.alibaba.sdk.android.oss.internal.RequestMessage;
import com.alibaba.sdk.android.oss.model.CopyObjectRequest;
import com.alibaba.sdk.android.oss.model.CreateBucketRequest;
import com.alibaba.sdk.android.oss.model.DeleteBucketRequest;
import com.alibaba.sdk.android.oss.model.GetBucketACLRequest;
import com.alibaba.sdk.android.oss.model.ListObjectsRequest;
import com.alibaba.sdk.android.oss.model.OSSRequest;
import com.alibaba.sdk.android.oss.model.ObjectMetadata;
import com.alibaba.sdk.android.oss.model.PartETag;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class OSSUtils {
    private static final List<String> SIGNED_PARAMTERS = Arrays.asList("acl", "uploads", "location", "cors", "logging", "website", "referer", "lifecycle", "delete", "append", "uploadId", "partNumber", "security-token", "position", "response-cache-control", "response-content-disposition", "response-content-encoding", "response-content-language", "response-content-type", "response-expires");

    public static void populateRequestMetadata(Map<String, String> headers, ObjectMetadata metadata) {
        Map<String, String> userMetadata;
        if (metadata == null) {
            return;
        }
        Map<String, Object> rawMetadata = metadata.getRawMetadata();
        if (rawMetadata != null) {
            for (Map.Entry<String, Object> entry : rawMetadata.entrySet()) {
                headers.put(entry.getKey(), entry.getValue().toString());
            }
        }
        if ((userMetadata = metadata.getUserMetadata()) != null) {
            for (Map.Entry<String, String> entry : userMetadata.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (key != null) {
                    key = key.trim();
                }
                if (value != null) {
                    value = value.trim();
                }
                headers.put(key, value);
            }
        }
    }

    public static void populateListObjectsRequestParameters(ListObjectsRequest listObjectsRequest, Map<String, String> params) {
        if (listObjectsRequest.getPrefix() != null) {
            params.put("prefix", listObjectsRequest.getPrefix());
        }
        if (listObjectsRequest.getMarker() != null) {
            params.put("marker", listObjectsRequest.getMarker());
        }
        if (listObjectsRequest.getDelimiter() != null) {
            params.put("delimiter", listObjectsRequest.getDelimiter());
        }
        if (listObjectsRequest.getMaxKeys() != null) {
            params.put("max-keys", Integer.toString(listObjectsRequest.getMaxKeys()));
        }
        if (listObjectsRequest.getEncodingType() != null) {
            params.put("encoding-type", listObjectsRequest.getEncodingType());
        }
    }

    public static void populateCopyObjectHeaders(CopyObjectRequest copyObjectRequest, Map<String, String> headers) {
        String copySourceHeader = "/" + copyObjectRequest.getSourceBucketName() + "/" + HttpUtil.urlEncode(copyObjectRequest.getSourceKey(), "utf-8");
        headers.put("x-oss-copy-source", copySourceHeader);
        OSSUtils.addDateHeader(headers, "x-oss-copy-source-if-modified-since", copyObjectRequest.getModifiedSinceConstraint());
        OSSUtils.addDateHeader(headers, "x-oss-copy-source-if-unmodified-since", copyObjectRequest.getUnmodifiedSinceConstraint());
        OSSUtils.addStringListHeader(headers, "x-oss-copy-source-if-match", copyObjectRequest.getMatchingETagConstraints());
        OSSUtils.addStringListHeader(headers, "x-oss-copy-source-if-none-match", copyObjectRequest.getNonmatchingEtagConstraints());
        OSSUtils.addHeader(headers, "x-oss-server-side-encryption", copyObjectRequest.getServerSideEncryption());
        ObjectMetadata newObjectMetadata = copyObjectRequest.getNewObjectMetadata();
        if (newObjectMetadata != null) {
            headers.put("x-oss-metadata-directive", MetadataDirective.REPLACE.toString());
            OSSUtils.populateRequestMetadata(headers, newObjectMetadata);
        }
        OSSUtils.removeHeader(headers, "Content-Length");
    }

    public static String buildXMLFromPartEtagList(List<PartETag> partETagList) {
        StringBuilder builder = new StringBuilder();
        builder.append("<CompleteMultipartUpload>\n");
        for (PartETag partETag : partETagList) {
            builder.append("<Part>\n");
            builder.append("<PartNumber>" + partETag.getPartNumber() + "</PartNumber>\n");
            builder.append("<ETag>" + partETag.getETag() + "</ETag>\n");
            builder.append("</Part>\n");
        }
        builder.append("</CompleteMultipartUpload>\n");
        return builder.toString();
    }

    public static void addHeader(Map<String, String> headers, String header, String value) {
        if (value != null) {
            headers.put(header, value);
        }
    }

    public static void addDateHeader(Map<String, String> headers, String header, Date value) {
        if (value != null) {
            headers.put(header, DateUtil.formatRfc822Date(value));
        }
    }

    public static void addStringListHeader(Map<String, String> headers, String header, List<String> values) {
        if (values != null && !values.isEmpty()) {
            headers.put(header, OSSUtils.join(values));
        }
    }

    public static void removeHeader(Map<String, String> headers, String header) {
        if (header != null && headers.containsKey(header)) {
            headers.remove(header);
        }
    }

    public static String join(List<String> strings) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String s : strings) {
            if (!first) {
                result.append(", ");
            }
            result.append(s);
            first = false;
        }
        return result.toString();
    }

    public static boolean isEmptyString(String str) {
        return str == null || str.length() == 0;
    }

    public static String buildCanonicalizedResource(String bucketName, String objectKey, Map<String, String> parameters) {
        String resourcePath = bucketName == null && objectKey == null ? "/" : (objectKey == null ? "/" + bucketName + "/" : "/" + bucketName + "/" + objectKey);
        StringBuilder builder = new StringBuilder();
        builder.append(resourcePath);
        if (parameters != null) {
            Object[] parameterNames = parameters.keySet().toArray(new String[parameters.size()]);
            Arrays.sort(parameterNames);
            int separater = 63;
            for (Object paramName : parameterNames) {
                if (!SIGNED_PARAMTERS.contains(paramName)) continue;
                builder.append((char)separater);
                builder.append((String)paramName);
                String paramValue = parameters.get(paramName);
                if (!OSSUtils.isEmptyString(paramValue)) {
                    builder.append("=").append(paramValue);
                }
                separater = 38;
            }
        }
        return builder.toString();
    }

    public static String paramToQueryString(Map<String, String> params, String charset) {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder paramString = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> p : params.entrySet()) {
            String key = p.getKey();
            String value = p.getValue();
            if (!first) {
                paramString.append("&");
            }
            paramString.append(HttpUtil.urlEncode(key, charset));
            if (!OSSUtils.isEmptyString(value)) {
                paramString.append("=").append(HttpUtil.urlEncode(value, charset));
            }
            first = false;
        }
        return paramString.toString();
    }

    public static String populateMapToBase64JsonString(Map<String, String> map) {
        JSONObject jsonObj = new JSONObject(map);
        return Base64.encodeToString((byte[])jsonObj.toString().getBytes(), (int)2);
    }

    public static String sign(String accessKey, String screctKey, String content) {
        String signature = null;
        try {
            signature = new HmacSHA1Signature().computeSignature(screctKey, content);
            signature = signature.trim();
        }
        catch (Exception e) {
            throw new IllegalStateException("Compute signature failed!", e);
        }
        return "OSS " + accessKey + ":" + signature;
    }

    public static boolean isCname(String host) {
        for (String suffix : OSSConstants.DEFAULT_CNAME_EXCLUDE_LIST) {
            if (!host.toLowerCase().endsWith(suffix)) continue;
            return false;
        }
        return true;
    }

    public static void assertTrue(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    public static boolean isNullOrEmpty(String value) {
        return value == null || value.length() == 0;
    }

    public static boolean validateBucketName(String bucketName) {
        if (bucketName == null) {
            return false;
        }
        String BUCKETNAME_REGX = "^[a-z0-9][a-z0-9_\\-]{2,62}$";
        return bucketName.matches("^[a-z0-9][a-z0-9_\\-]{2,62}$");
    }

    public static void ensureBucketNameValid(String bucketName) {
        if (!OSSUtils.validateBucketName(bucketName)) {
            throw new IllegalArgumentException("The bucket name is invalid. \nA bucket name must: \n1) be comprised of lower-case characters, numbers or dash(-); \n2) start with lower case or numbers; \n3) be between 3-63 characters long. ");
        }
    }

    public static boolean validateObjectKey(String objectKey) {
        if (objectKey == null) {
            return false;
        }
        if (objectKey.length() <= 0 || objectKey.length() > 1023) {
            return false;
        }
        try {
            byte[] keyBytes = objectKey.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return false;
        }
        char[] keyChars = objectKey.toCharArray();
        char beginKeyChar = keyChars[0];
        if (beginKeyChar == '/' || beginKeyChar == '\\') {
            return false;
        }
        for (char keyChar : keyChars) {
            if (keyChar == '\t' || keyChar >= ' ') continue;
            return false;
        }
        return true;
    }

    public static void ensureObjectKeyValid(String objectKey) {
        if (!OSSUtils.validateObjectKey(objectKey)) {
            throw new IllegalArgumentException("The object key is invalid. \nAn object name should be: \n1) between 1 - 1023 bytes long when encoded as UTF-8 \n2) cannot contain LF or CR or unsupported chars in XML1.0, \n3) cannot begin with \"/\" or \"\\\".");
        }
    }

    public static boolean doesRequestNeedObjectKey(OSSRequest request) {
        return !(request instanceof ListObjectsRequest) && !(request instanceof CreateBucketRequest) && !(request instanceof DeleteBucketRequest) && !(request instanceof GetBucketACLRequest);
    }

    public static void ensureRequestValid(OSSRequest request, RequestMessage message) {
        OSSUtils.ensureBucketNameValid(message.getBucketName());
        if (OSSUtils.doesRequestNeedObjectKey(request)) {
            OSSUtils.ensureObjectKeyValid(message.getObjectKey());
        }
    }

    public static String determineContentType(String initValue, String srcPath, String toObjectKey) {
        String extension;
        String contentType;
        if (initValue != null) {
            return initValue;
        }
        MimeTypeMap typeMap = MimeTypeMap.getSingleton();
        if (srcPath != null && (contentType = typeMap.getMimeTypeFromExtension(extension = srcPath.substring(srcPath.lastIndexOf(46) + 1))) != null) {
            return contentType;
        }
        if (toObjectKey != null && (contentType = typeMap.getMimeTypeFromExtension(extension = toObjectKey.substring(toObjectKey.lastIndexOf(46) + 1))) != null) {
            return contentType;
        }
        return "application/octet-stream";
    }

    public static void signRequest(RequestMessage message) throws IOException {
        String contentType;
        if (!message.isAuthorizationRequired()) {
            return;
        }
        if (message.getCredentialProvider() == null) {
            throw new IllegalStateException("\u5f53\u524dCredentialProvider\u4e3a\u7a7a\uff01\uff01\uff01\n1. \u8bf7\u68c0\u67e5\u60a8\u662f\u5426\u5728\u521d\u59cb\u5316OSSService\u65f6\u8bbe\u7f6eCredentialProvider;\n2. \u5982\u679c\u60a8bucket\u4e3a\u516c\u5171\u6743\u9650\uff0c\u8bf7\u786e\u8ba4\u83b7\u53d6\u5230Bucket\u540e\u5df2\u7ecf\u8c03\u7528Bucket\u4e2d\u63a5\u53e3\u58f0\u660eACL;");
        }
        OSSCredentialProvider credentialProvider = message.getCredentialProvider();
        OSSFederationToken federationToken = null;
        if (credentialProvider instanceof OSSFederationCredentialProvider) {
            federationToken = ((OSSFederationCredentialProvider)credentialProvider).getValidFederationToken();
            if (federationToken == null) {
                OSSLog.logE("Can't get a federation token");
                throw new IOException("Can't get a federation token");
            }
            message.getHeaders().put("x-oss-security-token", federationToken.getSecurityToken());
        }
        String method = message.getMethod().toString();
        String contentMD5 = message.getHeaders().get("Content-MD5");
        if (contentMD5 == null) {
            contentMD5 = "";
        }
        if ((contentType = message.getHeaders().get("Content-Type")) == null) {
            contentType = "";
        }
        String dateString = message.getHeaders().get("Date");
        ArrayList<Pair> list = new ArrayList<Pair>();
        for (String key : message.getHeaders().keySet()) {
            if (!key.toLowerCase().startsWith("x-oss-")) continue;
            list.add(new Pair((Object)key.toLowerCase(), (Object)message.getHeaders().get(key)));
        }
        Collections.sort(list, new Comparator<Pair<String, String>>(){

            @Override
            public int compare(Pair<String, String> lhs, Pair<String, String> rhs) {
                String k1 = (String)lhs.first;
                String k2 = (String)rhs.first;
                return k1.compareTo(k2);
            }
        });
        StringBuilder sb = new StringBuilder();
        Pair previous = null;
        for (Pair curr : list) {
            if (previous == null) {
                sb.append((String)curr.first + ":" + (String)curr.second);
            } else if (((String)previous.first).equals(curr.first)) {
                sb.append("," + (String)curr.second);
            } else {
                sb.append("\n" + (String)curr.first + ":" + (String)curr.second);
            }
            previous = curr;
        }
        String canonicalizedHeader = sb.toString();
        if (!OSSUtils.isEmptyString(canonicalizedHeader)) {
            canonicalizedHeader = canonicalizedHeader.trim();
            canonicalizedHeader = canonicalizedHeader + "\n";
        }
        String canonicalizedResource = OSSUtils.buildCanonicalizedResource(message.getBucketName(), message.getObjectKey(), message.getParameters());
        String contentToSign = String.format("%s\n%s\n%s\n%s\n%s%s", method, contentMD5, contentType, dateString, canonicalizedHeader, canonicalizedResource);
        String signature = "---initValue---";
        if (credentialProvider instanceof OSSFederationCredentialProvider) {
            signature = OSSUtils.sign(federationToken.getTempAK(), federationToken.getTempSK(), contentToSign);
        } else if (credentialProvider instanceof OSSPlainTextAKSKCredentialProvider) {
            signature = OSSUtils.sign(((OSSPlainTextAKSKCredentialProvider)credentialProvider).getAccessKeyId(), ((OSSPlainTextAKSKCredentialProvider)credentialProvider).getAccessKeySecret(), contentToSign);
        } else if (credentialProvider instanceof OSSCustomSignerCredentialProvider) {
            signature = ((OSSCustomSignerCredentialProvider)credentialProvider).signContent(contentToSign);
        }
        OSSLog.logD("signed content: " + contentToSign.replaceAll("\n", "@") + "   ---------   signature: " + signature);
        message.getHeaders().put("Authorization", signature);
    }

    private static enum MetadataDirective {
        COPY("COPY"),
        REPLACE("REPLACE");

        private final String directiveAsString;

        private MetadataDirective(String directiveAsString) {
            this.directiveAsString = directiveAsString;
        }

        public String toString() {
            return this.directiveAsString;
        }
    }
}

