/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.oss.internal;

import android.content.Context;
import android.net.Proxy;
import android.os.Build;
import com.alibaba.sdk.android.oss.ClientConfiguration;
import com.alibaba.sdk.android.oss.callback.OSSCompletedCallback;
import com.alibaba.sdk.android.oss.common.HttpMethod;
import com.alibaba.sdk.android.oss.common.auth.OSSCredentialProvider;
import com.alibaba.sdk.android.oss.common.utils.DateUtil;
import com.alibaba.sdk.android.oss.common.utils.OSSUtils;
import com.alibaba.sdk.android.oss.common.utils.VersionInfoUtils;
import com.alibaba.sdk.android.oss.internal.OSSAsyncTask;
import com.alibaba.sdk.android.oss.internal.RequestMessage;
import com.alibaba.sdk.android.oss.internal.ResponseParsers;
import com.alibaba.sdk.android.oss.model.AbortMultipartUploadRequest;
import com.alibaba.sdk.android.oss.model.AbortMultipartUploadResult;
import com.alibaba.sdk.android.oss.model.AppendObjectRequest;
import com.alibaba.sdk.android.oss.model.AppendObjectResult;
import com.alibaba.sdk.android.oss.model.CompleteMultipartUploadRequest;
import com.alibaba.sdk.android.oss.model.CompleteMultipartUploadResult;
import com.alibaba.sdk.android.oss.model.CopyObjectRequest;
import com.alibaba.sdk.android.oss.model.CopyObjectResult;
import com.alibaba.sdk.android.oss.model.CreateBucketRequest;
import com.alibaba.sdk.android.oss.model.CreateBucketResult;
import com.alibaba.sdk.android.oss.model.DeleteBucketRequest;
import com.alibaba.sdk.android.oss.model.DeleteBucketResult;
import com.alibaba.sdk.android.oss.model.DeleteObjectRequest;
import com.alibaba.sdk.android.oss.model.DeleteObjectResult;
import com.alibaba.sdk.android.oss.model.GetBucketACLRequest;
import com.alibaba.sdk.android.oss.model.GetBucketACLResult;
import com.alibaba.sdk.android.oss.model.GetObjectRequest;
import com.alibaba.sdk.android.oss.model.GetObjectResult;
import com.alibaba.sdk.android.oss.model.HeadObjectRequest;
import com.alibaba.sdk.android.oss.model.HeadObjectResult;
import com.alibaba.sdk.android.oss.model.InitiateMultipartUploadRequest;
import com.alibaba.sdk.android.oss.model.InitiateMultipartUploadResult;
import com.alibaba.sdk.android.oss.model.ListObjectsRequest;
import com.alibaba.sdk.android.oss.model.ListObjectsResult;
import com.alibaba.sdk.android.oss.model.ListPartsRequest;
import com.alibaba.sdk.android.oss.model.ListPartsResult;
import com.alibaba.sdk.android.oss.model.PutObjectRequest;
import com.alibaba.sdk.android.oss.model.PutObjectResult;
import com.alibaba.sdk.android.oss.model.UploadPartRequest;
import com.alibaba.sdk.android.oss.model.UploadPartResult;
import com.alibaba.sdk.android.oss.network.ExecutionContext;
import com.alibaba.sdk.android.oss.network.OSSRequestTask;
import com.squareup.okhttp.Dispatcher;
import com.squareup.okhttp.OkHttpClient;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class InternalRequestOperation {
    private volatile URI endpoint;
    private OkHttpClient innerClient;
    private Context applicationContext;
    private OSSCredentialProvider credentialProvider;
    private int maxRetryCount = 2;
    private ExecutorService executorService = Executors.newFixedThreadPool(5);

    public InternalRequestOperation(Context context, URI endpoint, OSSCredentialProvider credentialProvider, ClientConfiguration conf) {
        this.applicationContext = context;
        this.endpoint = endpoint;
        this.credentialProvider = credentialProvider;
        this.innerClient = new OkHttpClient();
        this.innerClient.setFollowRedirects(false);
        this.innerClient.setRetryOnConnectionFailure(false);
        this.innerClient.setCache(null);
        this.innerClient.setFollowSslRedirects(false);
        this.innerClient.setRetryOnConnectionFailure(false);
        if (conf != null) {
            this.innerClient.setConnectTimeout((long)conf.getConnectionTimeout(), TimeUnit.MILLISECONDS);
            this.innerClient.setReadTimeout((long)conf.getSocketTimeout(), TimeUnit.MILLISECONDS);
            this.innerClient.setWriteTimeout((long)conf.getSocketTimeout(), TimeUnit.MILLISECONDS);
            Dispatcher dispatcher = new Dispatcher();
            dispatcher.setMaxRequests(conf.getMaxConcurrentRequest());
            this.innerClient.setDispatcher(dispatcher);
            this.maxRetryCount = conf.getMaxErrorRetry();
        }
    }

    public OSSAsyncTask<PutObjectResult> putObject(PutObjectRequest request, OSSCompletedCallback<PutObjectRequest, PutObjectResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.PUT);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setObjectKey(request.getObjectKey());
        if (request.getUploadData() != null) {
            requestMessage.setUploadData(request.getUploadData());
        }
        if (request.getUploadFilePath() != null) {
            requestMessage.setUploadFilePath(request.getUploadFilePath());
        }
        if (request.getCallbackParam() != null) {
            requestMessage.getHeaders().put("x-oss-callback", OSSUtils.populateMapToBase64JsonString(request.getCallbackParam()));
        }
        if (request.getCallbackVars() != null) {
            requestMessage.getHeaders().put("x-oss-callback-var", OSSUtils.populateMapToBase64JsonString(request.getCallbackVars()));
        }
        OSSUtils.populateRequestMetadata(requestMessage.getHeaders(), request.getMetadata());
        this.canonicalizeRequestMessage(requestMessage);
        ExecutionContext<PutObjectRequest> executionContext = new ExecutionContext<PutObjectRequest>(this.getInnerClient(), request);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        executionContext.setProgressCallback(request.getProgressCallback());
        ResponseParsers.PutObjectReponseParser parser = new ResponseParsers.PutObjectReponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<CreateBucketResult> createBucket(CreateBucketRequest request, OSSCompletedCallback<CreateBucketRequest, CreateBucketResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.PUT);
        requestMessage.setBucketName(request.getBucketName());
        if (request.getBucketACL() != null) {
            requestMessage.getHeaders().put("x-oss-acl", request.getBucketACL().toString());
        }
        try {
            requestMessage.createBucketRequestBodyMarshall(request.getLocationConstraint());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        this.canonicalizeRequestMessage(requestMessage);
        ExecutionContext<CreateBucketRequest> executionContext = new ExecutionContext<CreateBucketRequest>(this.getInnerClient(), request);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.CreateBucketResponseParser parser = new ResponseParsers.CreateBucketResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<DeleteBucketResult> deleteBucket(DeleteBucketRequest request, OSSCompletedCallback<DeleteBucketRequest, DeleteBucketResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.DELETE);
        requestMessage.setBucketName(request.getBucketName());
        this.canonicalizeRequestMessage(requestMessage);
        ExecutionContext<DeleteBucketRequest> executionContext = new ExecutionContext<DeleteBucketRequest>(this.getInnerClient(), request);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.DeleteBucketResponseParser parser = new ResponseParsers.DeleteBucketResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<GetBucketACLResult> getBucketACL(GetBucketACLRequest request, OSSCompletedCallback<GetBucketACLRequest, GetBucketACLResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        LinkedHashMap<String, String> query = new LinkedHashMap<String, String>();
        query.put("acl", "");
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.GET);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setParameters(query);
        this.canonicalizeRequestMessage(requestMessage);
        ExecutionContext<GetBucketACLRequest> executionContext = new ExecutionContext<GetBucketACLRequest>(this.getInnerClient(), request);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.GetBucketACLResponseParser parser = new ResponseParsers.GetBucketACLResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<AppendObjectResult> appendObject(AppendObjectRequest request, OSSCompletedCallback<AppendObjectRequest, AppendObjectResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.POST);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setObjectKey(request.getObjectKey());
        if (request.getUploadData() != null) {
            requestMessage.setUploadData(request.getUploadData());
        }
        if (request.getUploadFilePath() != null) {
            requestMessage.setUploadFilePath(request.getUploadFilePath());
        }
        requestMessage.getParameters().put("append", "");
        requestMessage.getParameters().put("position", String.valueOf(request.getPosition()));
        OSSUtils.populateRequestMetadata(requestMessage.getHeaders(), request.getMetadata());
        this.canonicalizeRequestMessage(requestMessage);
        ExecutionContext<AppendObjectRequest> executionContext = new ExecutionContext<AppendObjectRequest>(this.getInnerClient(), request);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        executionContext.setProgressCallback(request.getProgressCallback());
        ResponseParsers.AppendObjectResponseParser parser = new ResponseParsers.AppendObjectResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<HeadObjectResult> headObject(HeadObjectRequest request, OSSCompletedCallback<HeadObjectRequest, HeadObjectResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.HEAD);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setObjectKey(request.getObjectKey());
        this.canonicalizeRequestMessage(requestMessage);
        ExecutionContext<HeadObjectRequest> executionContext = new ExecutionContext<HeadObjectRequest>(this.getInnerClient(), request);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.HeadObjectResponseParser parser = new ResponseParsers.HeadObjectResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<GetObjectResult> getObject(GetObjectRequest request, OSSCompletedCallback<GetObjectRequest, GetObjectResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.GET);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setObjectKey(request.getObjectKey());
        if (request.getRange() != null) {
            requestMessage.getHeaders().put("Range", request.getRange().toString());
        }
        this.canonicalizeRequestMessage(requestMessage);
        ExecutionContext<GetObjectRequest> executionContext = new ExecutionContext<GetObjectRequest>(this.getInnerClient(), request);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.GetObjectResponseParser parser = new ResponseParsers.GetObjectResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<CopyObjectResult> copyObject(CopyObjectRequest request, OSSCompletedCallback<CopyObjectRequest, CopyObjectResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.PUT);
        requestMessage.setBucketName(request.getDestinationBucketName());
        requestMessage.setObjectKey(request.getDestinationKey());
        OSSUtils.populateCopyObjectHeaders(request, requestMessage.getHeaders());
        this.canonicalizeRequestMessage(requestMessage);
        ExecutionContext<CopyObjectRequest> executionContext = new ExecutionContext<CopyObjectRequest>(this.getInnerClient(), request);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.CopyObjectResponseParser parser = new ResponseParsers.CopyObjectResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<DeleteObjectResult> deleteObject(DeleteObjectRequest request, OSSCompletedCallback<DeleteObjectRequest, DeleteObjectResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.DELETE);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setObjectKey(request.getObjectKey());
        this.canonicalizeRequestMessage(requestMessage);
        ExecutionContext<DeleteObjectRequest> executionContext = new ExecutionContext<DeleteObjectRequest>(this.getInnerClient(), request);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.DeleteObjectResponseParser parser = new ResponseParsers.DeleteObjectResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<ListObjectsResult> listObjects(ListObjectsRequest request, OSSCompletedCallback<ListObjectsRequest, ListObjectsResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.GET);
        requestMessage.setBucketName(request.getBucketName());
        this.canonicalizeRequestMessage(requestMessage);
        OSSUtils.populateListObjectsRequestParameters(request, requestMessage.getParameters());
        ExecutionContext<ListObjectsRequest> executionContext = new ExecutionContext<ListObjectsRequest>(this.getInnerClient(), request);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.ListObjectsResponseParser parser = new ResponseParsers.ListObjectsResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<InitiateMultipartUploadResult> initMultipartUpload(InitiateMultipartUploadRequest request, OSSCompletedCallback<InitiateMultipartUploadRequest, InitiateMultipartUploadResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.POST);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setObjectKey(request.getObjectKey());
        requestMessage.getParameters().put("uploads", "");
        OSSUtils.populateRequestMetadata(requestMessage.getHeaders(), request.getMetadata());
        this.canonicalizeRequestMessage(requestMessage);
        ExecutionContext<InitiateMultipartUploadRequest> executionContext = new ExecutionContext<InitiateMultipartUploadRequest>(this.getInnerClient(), request);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.InitMultipartResponseParser parser = new ResponseParsers.InitMultipartResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<UploadPartResult> uploadPart(UploadPartRequest request, OSSCompletedCallback<UploadPartRequest, UploadPartResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.PUT);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setObjectKey(request.getObjectKey());
        requestMessage.getParameters().put("uploadId", request.getUploadId());
        requestMessage.getParameters().put("partNumber", String.valueOf(request.getPartNumber()));
        requestMessage.setUploadData(request.getPartContent());
        if (request.getMd5Digest() != null) {
            requestMessage.getHeaders().put("Content-MD5", request.getMd5Digest());
        }
        this.canonicalizeRequestMessage(requestMessage);
        ExecutionContext<UploadPartRequest> executionContext = new ExecutionContext<UploadPartRequest>(this.getInnerClient(), request);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        executionContext.setProgressCallback(request.getProgressCallback());
        ResponseParsers.UploadPartResponseParser parser = new ResponseParsers.UploadPartResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<CompleteMultipartUploadResult> completeMultipartUpload(CompleteMultipartUploadRequest request, OSSCompletedCallback<CompleteMultipartUploadRequest, CompleteMultipartUploadResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.POST);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setObjectKey(request.getObjectKey());
        requestMessage.setUploadData(OSSUtils.buildXMLFromPartEtagList(request.getPartETags()).getBytes());
        requestMessage.getParameters().put("uploadId", request.getUploadId());
        if (request.getCallbackParam() != null) {
            requestMessage.getHeaders().put("x-oss-callback", OSSUtils.populateMapToBase64JsonString(request.getCallbackParam()));
        }
        if (request.getCallbackVars() != null) {
            requestMessage.getHeaders().put("x-oss-callback-var", OSSUtils.populateMapToBase64JsonString(request.getCallbackVars()));
        }
        this.canonicalizeRequestMessage(requestMessage);
        ExecutionContext<CompleteMultipartUploadRequest> executionContext = new ExecutionContext<CompleteMultipartUploadRequest>(this.getInnerClient(), request);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.CompleteMultipartUploadResponseParser parser = new ResponseParsers.CompleteMultipartUploadResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<AbortMultipartUploadResult> abortMultipartUpload(AbortMultipartUploadRequest request, OSSCompletedCallback<AbortMultipartUploadRequest, AbortMultipartUploadResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.DELETE);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setObjectKey(request.getObjectKey());
        requestMessage.getParameters().put("uploadId", request.getUploadId());
        this.canonicalizeRequestMessage(requestMessage);
        ExecutionContext<AbortMultipartUploadRequest> executionContext = new ExecutionContext<AbortMultipartUploadRequest>(this.getInnerClient(), request);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.AbortMultipartUploadResponseParser parser = new ResponseParsers.AbortMultipartUploadResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<ListPartsResult> listParts(ListPartsRequest request, OSSCompletedCallback<ListPartsRequest, ListPartsResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.GET);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setObjectKey(request.getObjectKey());
        requestMessage.getParameters().put("uploadId", request.getUploadId());
        this.canonicalizeRequestMessage(requestMessage);
        ExecutionContext<ListPartsRequest> executionContext = new ExecutionContext<ListPartsRequest>(this.getInnerClient(), request);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.ListPartsResponseParser parser = new ResponseParsers.ListPartsResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(this.executorService.submit(callable), executionContext);
    }

    private boolean checkIfHttpdnsAwailable() {
        if (this.applicationContext == null) {
            return false;
        }
        boolean IS_ICS_OR_LATER = Build.VERSION.SDK_INT >= 14;
        String proxyHost = IS_ICS_OR_LATER ? System.getProperty("http.proxyHost") : Proxy.getHost((Context)this.applicationContext);
        return proxyHost == null;
    }

    public OkHttpClient getInnerClient() {
        return this.innerClient.clone();
    }

    private void canonicalizeRequestMessage(RequestMessage message) {
        Map<String, String> header = message.getHeaders();
        if (header.get("Date") == null) {
            header.put("Date", DateUtil.currentFixedSkewedTimeInRFC822Format());
        }
        if ((message.getMethod() == HttpMethod.POST || message.getMethod() == HttpMethod.PUT) && header.get("Content-Type") == null) {
            String determineContentType = OSSUtils.determineContentType(null, message.getUploadFilePath(), message.getObjectKey());
            header.put("Content-Type", determineContentType);
        }
        message.setIsHttpdnsEnable(this.checkIfHttpdnsAwailable());
        message.setCredentialProvider(this.credentialProvider);
        message.getHeaders().put("User-Agent", VersionInfoUtils.getUserAgent());
    }

    public void setCredentialProvider(OSSCredentialProvider credentialProvider) {
        this.credentialProvider = credentialProvider;
    }
}

