/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.oss.network;

import com.alibaba.sdk.android.oss.ClientException;
import com.alibaba.sdk.android.oss.ServiceException;
import com.alibaba.sdk.android.oss.callback.OSSProgressCallback;
import com.alibaba.sdk.android.oss.common.OSSLog;
import com.alibaba.sdk.android.oss.common.utils.DateUtil;
import com.alibaba.sdk.android.oss.common.utils.OSSUtils;
import com.alibaba.sdk.android.oss.internal.OSSRetryHandler;
import com.alibaba.sdk.android.oss.internal.OSSRetryType;
import com.alibaba.sdk.android.oss.internal.RequestMessage;
import com.alibaba.sdk.android.oss.internal.ResponseParser;
import com.alibaba.sdk.android.oss.internal.ResponseParsers;
import com.alibaba.sdk.android.oss.model.OSSResult;
import com.alibaba.sdk.android.oss.network.ExecutionContext;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;

public class OSSRequestTask<T extends OSSResult>
implements Callable<T> {
    private ResponseParser<T> responseParser;
    private RequestMessage message;
    private ExecutionContext context;
    private OkHttpClient clone;
    private OSSRetryHandler retryHandler;
    private int currentRetryCount = 0;

    public OSSRequestTask(RequestMessage message, ResponseParser parser, ExecutionContext context, int maxRetry) {
        this.responseParser = parser;
        this.message = message;
        this.context = context;
        this.clone = context.getClient();
        this.retryHandler = new OSSRetryHandler(maxRetry);
    }

    @Override
    public T call() throws Exception {
        Request request = null;
        Response response = null;
        Exception exception = null;
        try {
            OSSLog.logD("[call] - ");
            OSSUtils.ensureRequestValid(this.context.getRequest(), this.message);
            OSSUtils.signRequest(this.message);
            if (this.context.getCancellationHandler().isCancelled()) {
                throw new InterruptedIOException("This task is cancelled!");
            }
            Request.Builder requestBuilder = new Request.Builder();
            String url = this.message.buildCanonicalURL();
            requestBuilder = requestBuilder.url(url);
            for (String key : this.message.getHeaders().keySet()) {
                requestBuilder = requestBuilder.addHeader(key, this.message.getHeaders().get(key));
            }
            String contentType = this.message.getHeaders().get("Content-Type");
            switch (this.message.getMethod()) {
                case POST: 
                case PUT: {
                    OSSUtils.assertTrue(contentType != null, "Content type can't be null when upload!");
                    if (this.message.getUploadData() != null) {
                        requestBuilder = requestBuilder.method(this.message.getMethod().toString(), (RequestBody)new ProgressTouchableRequestBody(this.message.getUploadData(), contentType, this.context.getProgressCallback()));
                        break;
                    }
                    if (this.message.getUploadFilePath() != null) {
                        requestBuilder = requestBuilder.method(this.message.getMethod().toString(), (RequestBody)new ProgressTouchableRequestBody(new File(this.message.getUploadFilePath()), contentType, this.context.getProgressCallback()));
                        break;
                    }
                    if (this.message.getUploadInputStream() != null) {
                        requestBuilder = requestBuilder.method(this.message.getMethod().toString(), (RequestBody)new ProgressTouchableRequestBody(this.message.getUploadInputStream(), this.message.getReadStreamLength(), contentType, this.context.getProgressCallback()));
                        break;
                    }
                    requestBuilder = requestBuilder.method(this.message.getMethod().toString(), RequestBody.create(null, (byte[])new byte[0]));
                    break;
                }
                case GET: {
                    requestBuilder = requestBuilder.get();
                    break;
                }
                case HEAD: {
                    requestBuilder = requestBuilder.head();
                    break;
                }
                case DELETE: {
                    requestBuilder = requestBuilder.delete();
                    break;
                }
            }
            this.clone.networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressTouchableResponseBody(originalResponse.body(), OSSRequestTask.this.context.getProgressCallback())).build();
                }
            });
            request = requestBuilder.build();
            if (OSSLog.isEnableLog()) {
                OSSLog.logD("request url: " + request.url());
                Map headerMap = request.headers().toMultimap();
                for (String key : headerMap.keySet()) {
                    OSSLog.logD("requestHeader " + key + ": " + (String)((List)headerMap.get(key)).get(0));
                }
            }
            Call call = this.clone.newCall(request);
            this.context.getCancellationHandler().setCall(call);
            response = call.execute();
            if (OSSLog.isEnableLog()) {
                OSSLog.logD("response code: " + response.code() + " for url: " + request.url());
                Map headerMap = response.headers().toMultimap();
                for (String key : headerMap.keySet()) {
                    OSSLog.logD("responseHeader " + key + ": " + (String)((List)headerMap.get(key)).get(0));
                }
            }
        }
        catch (Exception e) {
            OSSLog.logE("Encounter local execpiton: " + e.toString());
            if (OSSLog.isEnableLog()) {
                e.printStackTrace();
            }
            exception = new ClientException(e.getMessage(), e);
        }
        if (exception == null && (response.code() == 203 || response.code() >= 300)) {
            try {
                exception = ResponseParsers.parseResponseErrorXML(response, request.method().equals("HEAD"));
            }
            catch (IOException e) {
                exception = new ClientException(e.getMessage(), e);
            }
        } else if (exception == null) {
            try {
                OSSResult result = (OSSResult)this.responseParser.parse(response);
                if (this.context.getCompletedCallback() != null) {
                    this.context.getCompletedCallback().onSuccess(this.context.getRequest(), result);
                }
                return (T)result;
            }
            catch (IOException e) {
                exception = new ClientException(e.getMessage(), e);
            }
        }
        OSSRetryType retryType = this.retryHandler.shouldRetry(exception, this.currentRetryCount);
        OSSLog.logE("[run] - retry, retry type: " + (Object)((Object)retryType));
        if (retryType == OSSRetryType.OSSRetryTypeShouldRetry) {
            ++this.currentRetryCount;
            return (T)this.call();
        }
        if (retryType == OSSRetryType.OSSRetryTypeShouldFixedTimeSkewedAndRetry) {
            String responseDateString = response.header("Date");
            this.message.getHeaders().put("Date", responseDateString);
            long serverTime = DateUtil.parseRfc822Date(responseDateString).getTime();
            DateUtil.setCurrentServerTime(serverTime);
            ++this.currentRetryCount;
            return (T)this.call();
        }
        if (exception instanceof ClientException) {
            if (this.context.getCompletedCallback() != null) {
                this.context.getCompletedCallback().onFailure(this.context.getRequest(), (ClientException)exception, null);
            }
        } else if (this.context.getCompletedCallback() != null) {
            this.context.getCompletedCallback().onFailure(this.context.getRequest(), null, (ServiceException)exception);
        }
        throw exception;
    }

    public class ProgressTouchableResponseBody
    extends ResponseBody {
        private ResponseBody responseBody;
        private OSSProgressCallback callback;
        private BufferedSource bufferedSource;

        public ProgressTouchableResponseBody(ResponseBody responseBody, OSSProgressCallback callback) {
            this.responseBody = responseBody;
            this.callback = callback;
        }

        public MediaType contentType() {
            return this.responseBody.contentType();
        }

        public long contentLength() throws IOException {
            return this.responseBody.contentLength();
        }

        public BufferedSource source() throws IOException {
            if (this.bufferedSource == null) {
                this.bufferedSource = Okio.buffer((Source)this.source((Source)this.responseBody.source()));
            }
            return this.bufferedSource;
        }

        private Source source(Source source) {
            return new ForwardingSource(source){
                long totalBytesRead;
                {
                    this.totalBytesRead = 0L;
                }

                public long read(Buffer sink, long byteCount) throws IOException {
                    long bytesRead = super.read(sink, byteCount);
                    this.totalBytesRead += bytesRead != -1L ? bytesRead : 0L;
                    if (ProgressTouchableResponseBody.this.callback != null) {
                        ProgressTouchableResponseBody.this.callback.onProgress(OSSRequestTask.this.context.getRequest(), this.totalBytesRead, ProgressTouchableResponseBody.this.responseBody.contentLength());
                    }
                    return bytesRead;
                }
            };
        }
    }

    class ProgressTouchableRequestBody
    extends RequestBody {
        private static final int SEGMENT_SIZE = 2048;
        private byte[] data;
        private File file;
        private InputStream inputStream;
        private String contentType;
        private long contentLength;
        private OSSProgressCallback callback;
        private BufferedSink bufferedSink;

        public ProgressTouchableRequestBody(File file, String contentType, OSSProgressCallback callback) {
            this.file = file;
            this.contentType = contentType;
            this.contentLength = file.length();
            this.callback = callback;
        }

        public ProgressTouchableRequestBody(byte[] data, String contentType, OSSProgressCallback callback) {
            this.data = data;
            this.contentType = contentType;
            this.contentLength = data.length;
            this.callback = callback;
        }

        public ProgressTouchableRequestBody(InputStream input, long contentLength, String contentType, OSSProgressCallback callback) {
            this.inputStream = input;
            this.contentType = contentType;
            this.contentLength = contentLength;
            this.callback = callback;
        }

        public MediaType contentType() {
            return MediaType.parse((String)this.contentType);
        }

        public long contentLength() throws IOException {
            return this.contentLength;
        }

        public void writeTo(BufferedSink sink) throws IOException {
            long read;
            Source source = null;
            if (this.file != null) {
                source = Okio.source((File)this.file);
            } else if (this.data != null) {
                source = Okio.source((InputStream)new ByteArrayInputStream(this.data));
            } else if (this.inputStream != null) {
                source = Okio.source((InputStream)this.inputStream);
            }
            for (long total = 0L; total < this.contentLength; total += read) {
                long remain = this.contentLength - total;
                long toRead = Math.min(remain, 2048L);
                read = source.read(sink.buffer(), toRead);
                if (read == -1L) break;
                sink.flush();
                if (this.callback == null) continue;
                this.callback.onProgress(OSSRequestTask.this.context.getRequest(), total, this.contentLength);
            }
        }
    }
}

