/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.oss.common.utils;

import com.alibaba.sdk.android.oss.common.OSSLog;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONArray;
import org.json.JSONObject;

public class HttpdnsMini {
    private static final String TAG = "HttpDnsMini";
    private static final String SERVER_IP = "140.205.143.143";
    private static final String SERVER_HOST = "httpdns.aliyuncs.com";
    private static final int MAX_THREAD_NUM = 5;
    private static final int THRESHOLD_DEGRADE_HOST = 5;
    private static final int RESOLVE_TIMEOUT_IN_SEC = 10;
    private static final int MAX_HOLD_HOST_NUM = 100;
    private static final int EMPTY_RESULT_HOST_TTL = 30;
    private static AtomicInteger globalNetworkError = new AtomicInteger(0);
    private ConcurrentMap<String, HostObject> hostManager = new ConcurrentHashMap<String, HostObject>();
    private static HttpdnsMini instance = new HttpdnsMini();
    private ExecutorService pool = Executors.newFixedThreadPool(5);

    private HttpdnsMini() {
    }

    public static HttpdnsMini getInstance() {
        return instance;
    }

    public String getIpByHost(String hostName) {
        HostObject host = (HostObject)this.hostManager.get(hostName);
        if (host == null || host.isExpired()) {
            OSSLog.logD("[httpdnsmini] - refresh host: " + hostName);
            Future<String> future = this.pool.submit(new QueryHostTask(hostName));
            try {
                String result = future.get();
                return result;
            }
            catch (Exception e) {
                if (OSSLog.isEnableLog()) {
                    e.printStackTrace();
                }
                return null;
            }
        }
        return host.getIp();
    }

    public String getIpByHostAsync(String hostName) {
        HostObject host = (HostObject)this.hostManager.get(hostName);
        if (host == null || host.isExpired()) {
            OSSLog.logD("[httpdnsmini] - refresh host: " + hostName);
            this.pool.submit(new QueryHostTask(hostName));
        }
        if (host != null) {
            return host.isStillAvailable() ? host.getIp() : null;
        }
        return null;
    }

    class QueryHostTask
    implements Callable<String> {
        private String hostName;
        private boolean hasRetryed = false;

        public QueryHostTask(String hostToQuery) {
            this.hostName = hostToQuery;
        }

        @Override
        public String call() {
            block10: {
                String chooseServerAddress = HttpdnsMini.SERVER_IP;
                if (globalNetworkError.get() > 5) {
                    chooseServerAddress = HttpdnsMini.SERVER_HOST;
                }
                String resolveUrl = "http://" + chooseServerAddress + "/d?host=" + this.hostName;
                OSSLog.logD("[httpdnsmini] - buildUrl: " + resolveUrl);
                try {
                    HttpURLConnection conn = (HttpURLConnection)new URL(resolveUrl).openConnection();
                    conn.setConnectTimeout(10000);
                    conn.setReadTimeout(10000);
                    if (conn.getResponseCode() != 200) {
                        OSSLog.logE("[httpdnsmini] - responseCodeNot 200, but: " + conn.getResponseCode());
                    } else {
                        String line;
                        globalNetworkError.decrementAndGet();
                        InputStream in = conn.getInputStream();
                        BufferedReader streamReader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                        StringBuilder sb = new StringBuilder();
                        while ((line = streamReader.readLine()) != null) {
                            sb.append(line);
                        }
                        JSONObject json = new JSONObject(sb.toString());
                        String host = json.getString("host");
                        long ttl = json.getLong("ttl");
                        JSONArray ips = json.getJSONArray("ips");
                        if (host != null) {
                            if (ttl == 0L) {
                                ttl = 30L;
                            }
                            HostObject hostObject = new HostObject();
                            String ip = ips == null ? null : ips.getString(0);
                            OSSLog.logD("[httpdnsmini] - resolve host:" + host + " ip:" + ip + " ttl:" + ttl);
                            hostObject.setHostName(host);
                            hostObject.setTtl(ttl);
                            hostObject.setIp(ip);
                            hostObject.setQueryTime(System.currentTimeMillis() / 1000L);
                            if (HttpdnsMini.this.hostManager.size() < 100) {
                                HttpdnsMini.this.hostManager.put(this.hostName, hostObject);
                            }
                            return ip;
                        }
                    }
                }
                catch (Exception e) {
                    globalNetworkError.incrementAndGet();
                    if (!OSSLog.isEnableLog()) break block10;
                    e.printStackTrace();
                }
            }
            if (!this.hasRetryed) {
                this.hasRetryed = true;
                return this.call();
            }
            return null;
        }
    }

    class HostObject {
        private String hostName;
        private String ip;
        private long ttl;
        private long queryTime;

        HostObject() {
        }

        public String toString() {
            return "HostObject [hostName=" + this.hostName + ", ip=" + this.ip + ", ttl=" + this.ttl + ", queryTime=" + this.queryTime + "]";
        }

        public boolean isExpired() {
            return this.getQueryTime() + this.ttl < System.currentTimeMillis() / 1000L;
        }

        public boolean isStillAvailable() {
            return this.getQueryTime() + this.ttl + 600L > System.currentTimeMillis() / 1000L;
        }

        public String getIp() {
            return this.ip;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public void setHostName(String hostName) {
            this.hostName = hostName;
        }

        public String getHostName() {
            return this.hostName;
        }

        public long getTtl() {
            return this.ttl;
        }

        public void setTtl(long ttl) {
            this.ttl = ttl;
        }

        public long getQueryTime() {
            return this.queryTime;
        }

        public void setQueryTime(long queryTime) {
            this.queryTime = queryTime;
        }
    }
}

