/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.oss.internal;

import com.alibaba.sdk.android.oss.ClientException;
import com.alibaba.sdk.android.oss.ServiceException;
import com.alibaba.sdk.android.oss.model.OSSResult;
import com.alibaba.sdk.android.oss.network.ExecutionContext;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class OSSAsyncTask<T extends OSSResult> {
    private Future<T> future;
    private ExecutionContext context;

    public void cancel() {
        if (this.context != null) {
            this.context.getCancellationHandler().cancel();
        }
    }

    public boolean isCompleted() {
        return this.future.isDone();
    }

    public T getResult() throws ClientException, ServiceException {
        try {
            OSSResult result = (OSSResult)this.future.get();
            return (T)result;
        }
        catch (InterruptedException e) {
            throw new ClientException(e.getMessage(), e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ClientException) {
                throw (ClientException)cause;
            }
            if (cause instanceof ServiceException) {
                throw (ServiceException)cause;
            }
            cause.printStackTrace();
            throw new ClientException("Unexpected exception!" + cause.getMessage());
        }
    }

    public static OSSAsyncTask wrapRequestTask(Future future, ExecutionContext context) {
        OSSAsyncTask asynTask = new OSSAsyncTask();
        asynTask.future = future;
        asynTask.context = context;
        return asynTask;
    }

    public void waitUntilFinished() {
        try {
            this.future.get();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

