/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.oss.common;

import android.util.Log;
import com.alibaba.sdk.android.oss.common.OSSLogToFileUtils;

public class OSSLog {
    private static final String TAG = "OSS-Android-SDK";
    private static boolean enableLog = false;

    public static void enableLog() {
        enableLog = true;
    }

    public static void disableLog() {
        enableLog = false;
    }

    public static boolean isEnableLog() {
        return enableLog;
    }

    public static void logInfo(String msg) {
        if (enableLog) {
            Log.i((String)TAG, (String)msg);
            OSSLogToFileUtils.getInstance().write(msg);
        }
    }

    public static void logVerbose(String msg) {
        if (enableLog) {
            Log.v((String)TAG, (String)msg);
            OSSLogToFileUtils.getInstance().write(msg);
        }
    }

    public static void logWarn(String msg) {
        if (enableLog) {
            Log.w((String)TAG, (String)msg);
            OSSLogToFileUtils.getInstance().write(msg);
        }
    }

    public static void logDebug(String msg) {
        OSSLog.logDebug(msg, true);
    }

    public static void logDebug(String msg, boolean write2local) {
        if (enableLog) {
            Log.d((String)TAG, (String)msg);
        }
        if (write2local) {
            OSSLogToFileUtils.getInstance().write(msg);
        }
    }

    public static void logError(String msg) {
        OSSLog.logError(msg, true);
    }

    public static void logError(String msg, boolean write2local) {
        if (enableLog) {
            Log.e((String)TAG, (String)msg);
        }
        if (write2local) {
            OSSLogToFileUtils.getInstance().write(msg);
        }
    }

    public static void logThrowable2Local(Throwable throwable) {
        if (enableLog) {
            OSSLogToFileUtils.getInstance().write(throwable);
        }
    }
}

