/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.oss.common;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.text.format.Formatter;
import android.util.Log;
import com.alibaba.sdk.android.oss.ClientConfiguration;
import com.alibaba.sdk.android.oss.common.LogThreadPoolManager;
import com.alibaba.sdk.android.oss.common.OSSLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;

public class OSSLogToFileUtils {
    private static LogThreadPoolManager logService = LogThreadPoolManager.newInstance();
    private static Context sContext;
    private static OSSLogToFileUtils instance;
    private static File sLogFile;
    private static SimpleDateFormat sLogSDF;
    private static long LOG_MAX_SIZE;
    private static boolean sWrite2Local;
    private static final String LOG_TAG = "OSS-Android-SDK";
    private static final String LOG_DIR_NAME = "OSSLog";
    private boolean useSdCard = true;

    private OSSLogToFileUtils() {
    }

    public static void init(Context context, ClientConfiguration cfg) {
        OSSLogToFileUtils.log(4, "init ...");
        if (null == sContext || null == instance || null == sLogFile || !sLogFile.exists()) {
            if (cfg != null) {
                LOG_MAX_SIZE = cfg.getMaxLogSize();
            }
            sContext = context.getApplicationContext();
            instance = OSSLogToFileUtils.getInstance();
            sLogFile = instance.getLogFile();
            if (sLogFile != null) {
                OSSLogToFileUtils.log(4, "LogFilePath is: " + sLogFile.getPath());
                long logFileSize = OSSLogToFileUtils.getLogFileSize(sLogFile);
                OSSLogToFileUtils.log(4, "Log max size is: " + Formatter.formatFileSize((Context)context, (long)LOG_MAX_SIZE));
                OSSLogToFileUtils.log(4, "Log now size is: " + Formatter.formatFileSize((Context)context, (long)logFileSize));
                if (LOG_MAX_SIZE < logFileSize) {
                    OSSLogToFileUtils.log(4, "init reset log file");
                    instance.resetLogFile();
                }
            }
        } else {
            OSSLogToFileUtils.log(4, "LogToFileUtils has been init ...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OSSLogToFileUtils getInstance() {
        if (instance != null) return instance;
        Class<OSSLogToFileUtils> clazz = OSSLogToFileUtils.class;
        synchronized (OSSLogToFileUtils.class) {
            if (instance != null) return instance;
            instance = new OSSLogToFileUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private long readSDCardSpace() {
        long sdCardSize = 0L;
        String state = Environment.getExternalStorageState();
        if ("mounted".equals(state)) {
            File sdcardDir = Environment.getExternalStorageDirectory();
            StatFs sf = new StatFs(sdcardDir.getPath());
            long blockSize = sf.getBlockSize();
            long availCount = sf.getAvailableBlocks();
            sdCardSize = availCount * blockSize;
        }
        OSSLogToFileUtils.log(3, "sd\u5361\u5b58\u50a8\u7a7a\u95f4:" + String.valueOf(sdCardSize) + "kb");
        return sdCardSize;
    }

    private long readSystemSpace() {
        File root = Environment.getRootDirectory();
        StatFs sf = new StatFs(root.getPath());
        long blockSize = sf.getBlockSize();
        long availCount = sf.getAvailableBlocks();
        long systemSpaceSize = availCount * blockSize / 1024L;
        OSSLogToFileUtils.log(3, "\u5185\u90e8\u5b58\u50a8\u7a7a\u95f4:" + String.valueOf(systemSpaceSize) + "kb");
        return systemSpaceSize;
    }

    public void setUseSdCard(boolean useSdCard) {
        this.useSdCard = useSdCard;
    }

    public void resetLogFile() {
        File logFile;
        OSSLogToFileUtils.log(4, "Reset Log File ... ");
        if (!sLogFile.getParentFile().exists()) {
            OSSLogToFileUtils.log(4, "Reset Log make File dir ... ");
            sLogFile.getParentFile().mkdir();
        }
        if ((logFile = new File(sLogFile.getParent() + "/logs.csv")).exists()) {
            logFile.delete();
        }
        this.createNewFile(logFile);
    }

    public void deleteLogFile() {
        File logFile = new File(sLogFile.getParent() + "/logs.csv");
        if (logFile.exists()) {
            OSSLogToFileUtils.log(4, "delete Log File ... ");
            logFile.delete();
        }
    }

    public void deleteLogFileDir() {
        this.deleteLogFile();
        File dir = new File(Environment.getExternalStorageDirectory().getPath() + File.separator + LOG_DIR_NAME);
        if (dir.exists()) {
            OSSLogToFileUtils.log(4, "delete Log FileDir ... ");
            dir.delete();
        }
    }

    public static void reset() {
        sContext = null;
        instance = null;
        sLogFile = null;
    }

    public static long getLogFileSize(File file) {
        long size = 0L;
        if (file != null && file.exists()) {
            try {
                FileInputStream fis = new FileInputStream(file);
                size = fis.available();
            }
            catch (Exception e) {
                OSSLogToFileUtils.log(6, e.toString());
            }
        }
        return size;
    }

    public static long getLocalLogFileSize() {
        return OSSLogToFileUtils.getLogFileSize(sLogFile);
    }

    private File getLogFile() {
        File file;
        boolean canStorage;
        if (this.useSdCard && Environment.getExternalStorageState().equals("mounted")) {
            canStorage = this.readSDCardSpace() > LOG_MAX_SIZE / 1024L;
            file = new File(Environment.getExternalStorageDirectory().getPath() + File.separator + LOG_DIR_NAME);
        } else {
            canStorage = this.readSystemSpace() > LOG_MAX_SIZE / 1024L;
            file = new File(sContext.getFilesDir().getPath() + File.separator + LOG_DIR_NAME);
        }
        File logFile = null;
        if (canStorage) {
            if (!file.exists()) {
                file.mkdirs();
            }
            if (!(logFile = new File(file.getPath() + "/logs.csv")).exists()) {
                this.createNewFile(logFile);
            }
        }
        return logFile;
    }

    public void createNewFile(File logFile) {
        try {
            logFile.createNewFile();
        }
        catch (Exception e) {
            OSSLogToFileUtils.log(6, "Create log file failure !!! " + e.toString());
        }
    }

    private String getFunctionInfo(StackTraceElement[] ste) {
        String msg = null;
        if (ste == null) {
            msg = "[" + sLogSDF.format(new Date()) + "]";
        }
        return msg;
    }

    public synchronized void write(Object str) {
        if (OSSLog.isEnableLog()) {
            if (null == sContext || null == instance || null == sLogFile) {
                return;
            }
            if (!sLogFile.exists()) {
                this.resetLogFile();
            }
            WriteCall writeCall = new WriteCall(str);
            logService.addExecuteTask(writeCall);
        }
    }

    private static void log(int level, String msg) {
        if (OSSLog.isEnableLog()) {
            if (level == 4) {
                Log.i((String)LOG_TAG, (String)msg);
            } else if (level == 6) {
                Log.e((String)LOG_TAG, (String)msg);
            } else if (level == 3) {
                Log.d((String)LOG_TAG, (String)msg);
            }
        }
    }

    static {
        sLogSDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        LOG_MAX_SIZE = 0x500000L;
        sWrite2Local = false;
    }

    private static class WriteCall
    implements Runnable {
        private Object mStr;

        public WriteCall(Object mStr) {
            this.mStr = mStr;
        }

        @Override
        public void run() {
            if (sLogFile != null) {
                OSSLogToFileUtils.getInstance();
                long logFileSize = OSSLogToFileUtils.getLogFileSize(sLogFile);
                OSSLogToFileUtils.log(4, "Log max size is: " + Formatter.formatFileSize((Context)sContext, (long)LOG_MAX_SIZE));
                OSSLogToFileUtils.log(4, "Log now size is: " + Formatter.formatFileSize((Context)sContext, (long)logFileSize));
                if (logFileSize > LOG_MAX_SIZE) {
                    OSSLogToFileUtils.getInstance().resetLogFile();
                }
                try {
                    PrintWriter pw = new PrintWriter((Writer)new FileWriter(sLogFile, true), true);
                    if (pw != null) {
                        OSSLogToFileUtils.log(3, "file exist:" + sLogFile.exists());
                        OSSLogToFileUtils.log(3, "write data");
                        this.setBaseInfo(pw);
                        if (this.mStr instanceof Throwable) {
                            this.printEx(pw);
                        } else {
                            pw.println(OSSLogToFileUtils.getInstance().getFunctionInfo(null) + " - " + this.mStr.toString());
                        }
                        pw.println("------>end of log");
                        pw.println();
                        pw.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        private PrintWriter setBaseInfo(PrintWriter pw) {
            pw.println("android_version\uff1a" + Build.VERSION.RELEASE);
            pw.println("mobile_model\uff1a" + Build.MODEL);
            ConnectivityManager connectivityManager = (ConnectivityManager)sContext.getSystemService("connectivity");
            NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
            String networkState = "unconnected";
            if (activeNetworkInfo.getState() == NetworkInfo.State.CONNECTED) {
                networkState = "connected";
            }
            if (!TextUtils.isEmpty((CharSequence)this.getOperatorName())) {
                pw.println("operator_name\uff1a" + this.getOperatorName());
            }
            pw.println("network_state\uff1a" + networkState);
            pw.println("network_type\uff1a" + activeNetworkInfo.getTypeName());
            return pw;
        }

        private PrintWriter printEx(PrintWriter pw) {
            pw.println("crash_time\uff1a" + sLogSDF.format(new Date()));
            ((Throwable)this.mStr).printStackTrace(pw);
            return pw;
        }

        private String getOperatorName() {
            TelephonyManager telephonyManager = (TelephonyManager)sContext.getSystemService("phone");
            String operator = telephonyManager.getSimOperator();
            String operatorName = "";
            if (operator != null) {
                if (operator.equals("46000") || operator.equals("46002")) {
                    operatorName = "CMCC";
                } else if (operator.equals("46001")) {
                    operatorName = "CUCC";
                } else if (operator.equals("46003")) {
                    operatorName = "CTCC";
                }
            }
            return operatorName;
        }
    }
}

