/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.oss.internal;

import com.alibaba.sdk.android.oss.common.OSSLog;
import com.alibaba.sdk.android.oss.internal.ResponseParser;
import com.alibaba.sdk.android.oss.model.OSSResult;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.Response;

public abstract class AbstractResponseParser<T extends OSSResult>
implements ResponseParser {
    abstract T parseData(Response var1, T var2) throws Exception;

    public boolean needCloseResponse() {
        return true;
    }

    @Override
    public T parse(Response response) throws IOException {
        try {
            Type type = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
            Class classType = (Class)type;
            OSSResult result = (OSSResult)classType.newInstance();
            if (result != null) {
                result.setRequestId(response.header("x-oss-request-id"));
                result.setStatusCode(response.code());
                result.setResponseHeader(this.parseResponseHeader(response));
                result = this.parseData(response, result);
            }
            OSSResult oSSResult = result;
            return (T)oSSResult;
        }
        catch (Exception e) {
            IOException ioException = new IOException(e.getMessage(), e);
            e.printStackTrace();
            OSSLog.logThrowable2Local(e);
            throw ioException;
        }
        finally {
            if (this.needCloseResponse()) {
                AbstractResponseParser.safeCloseResponse(response);
            }
        }
    }

    public static void safeCloseResponse(Response response) {
        try {
            response.body().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Map<String, String> parseResponseHeader(Response response) {
        HashMap<String, String> result = new HashMap<String, String>();
        Headers headers = response.headers();
        for (int i = 0; i < headers.size(); ++i) {
            result.put(headers.name(i), headers.value(i));
        }
        return result;
    }
}

