/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.oss.common;

import android.content.Context;
import android.os.Environment;
import android.os.StatFs;
import com.alibaba.sdk.android.oss.ClientConfiguration;
import com.alibaba.sdk.android.oss.common.LogThreadPoolManager;
import com.alibaba.sdk.android.oss.common.OSSLog;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;

public class OSSLogToFileUtils {
    private static LogThreadPoolManager logService = LogThreadPoolManager.newInstance();
    private static Context sContext;
    private static OSSLogToFileUtils instance;
    private static File sLogFile;
    private static SimpleDateFormat sLogSDF;
    private static long LOG_MAX_SIZE;
    private static final String LOG_DIR_NAME = "OSSLog";
    private boolean useSdCard = true;

    private OSSLogToFileUtils() {
    }

    public static void init(Context context, ClientConfiguration cfg) {
        OSSLog.logDebug("init ...", false);
        if (cfg != null) {
            LOG_MAX_SIZE = cfg.getMaxLogSize();
        }
        if (null == sContext || null == instance || null == sLogFile || !sLogFile.exists()) {
            sContext = context.getApplicationContext();
            instance = OSSLogToFileUtils.getInstance();
            logService.addExecuteTask(new Runnable(){

                @Override
                public void run() {
                    sLogFile = instance.getLogFile();
                    if (sLogFile != null) {
                        OSSLog.logInfo("LogFilePath is: " + sLogFile.getPath(), false);
                        long logFileSize = OSSLogToFileUtils.getLogFileSize(sLogFile);
                        if (LOG_MAX_SIZE < logFileSize) {
                            OSSLog.logInfo("init reset log file", false);
                            instance.resetLogFile();
                        }
                    }
                }
            });
        } else {
            OSSLog.logDebug("LogToFileUtils has been init ...", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OSSLogToFileUtils getInstance() {
        if (instance != null) return instance;
        Class<OSSLogToFileUtils> clazz = OSSLogToFileUtils.class;
        synchronized (OSSLogToFileUtils.class) {
            if (instance != null) return instance;
            instance = new OSSLogToFileUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private long readSDCardSpace() {
        long sdCardSize = 0L;
        String state = Environment.getExternalStorageState();
        if ("mounted".equals(state)) {
            File sdcardDir = Environment.getExternalStorageDirectory();
            StatFs sf = new StatFs(sdcardDir.getPath());
            long blockSize = sf.getBlockSize();
            long availCount = sf.getAvailableBlocks();
            sdCardSize = availCount * blockSize;
        }
        OSSLog.logDebug("sd\u5361\u5b58\u50a8\u7a7a\u95f4:" + String.valueOf(sdCardSize) + "kb", false);
        return sdCardSize;
    }

    private long readSystemSpace() {
        File root = Environment.getRootDirectory();
        StatFs sf = new StatFs(root.getPath());
        long blockSize = sf.getBlockSize();
        long availCount = sf.getAvailableBlocks();
        long systemSpaceSize = availCount * blockSize / 1024L;
        OSSLog.logDebug("\u5185\u90e8\u5b58\u50a8\u7a7a\u95f4:" + String.valueOf(systemSpaceSize) + "kb", false);
        return systemSpaceSize;
    }

    public void setUseSdCard(boolean useSdCard) {
        this.useSdCard = useSdCard;
    }

    public void resetLogFile() {
        File logFile;
        OSSLog.logDebug("Reset Log File ... ", false);
        if (!sLogFile.getParentFile().exists()) {
            OSSLog.logDebug("Reset Log make File dir ... ", false);
            sLogFile.getParentFile().mkdir();
        }
        if ((logFile = new File(sLogFile.getParent() + "/logs.csv")).exists()) {
            logFile.delete();
        }
        this.createNewFile(logFile);
    }

    public void deleteLogFile() {
        File logFile = new File(sLogFile.getParent() + "/logs.csv");
        if (logFile.exists()) {
            OSSLog.logDebug("delete Log File ... ", false);
            logFile.delete();
        }
    }

    public void deleteLogFileDir() {
        this.deleteLogFile();
        File dir = new File(Environment.getExternalStorageDirectory().getPath() + File.separator + LOG_DIR_NAME);
        if (dir.exists()) {
            OSSLog.logDebug("delete Log FileDir ... ", false);
            dir.delete();
        }
    }

    public static void reset() {
        sContext = null;
        instance = null;
        sLogFile = null;
    }

    public static long getLogFileSize(File file) {
        long size = 0L;
        if (file != null && file.exists()) {
            size = file.length();
        }
        return size;
    }

    public static long getLocalLogFileSize() {
        return OSSLogToFileUtils.getLogFileSize(sLogFile);
    }

    private File getLogFile() {
        File file;
        boolean canStorage;
        if (this.useSdCard && Environment.getExternalStorageState().equals("mounted")) {
            canStorage = this.readSDCardSpace() > LOG_MAX_SIZE / 1024L;
            file = new File(Environment.getExternalStorageDirectory().getPath() + File.separator + LOG_DIR_NAME);
        } else {
            canStorage = this.readSystemSpace() > LOG_MAX_SIZE / 1024L;
            file = new File(sContext.getFilesDir().getPath() + File.separator + LOG_DIR_NAME);
        }
        File logFile = null;
        if (canStorage) {
            if (!file.exists()) {
                file.mkdirs();
            }
            if (!(logFile = new File(file.getPath() + "/logs.csv")).exists()) {
                this.createNewFile(logFile);
            }
        }
        return logFile;
    }

    public void createNewFile(File logFile) {
        try {
            logFile.createNewFile();
        }
        catch (Exception e) {
            OSSLog.logError("Create log file failure !!! " + e.toString(), false);
        }
    }

    private String getFunctionInfo(StackTraceElement[] ste) {
        String msg = null;
        if (ste == null) {
            msg = "[" + sLogSDF.format(new Date()) + "]";
        }
        return msg;
    }

    public synchronized void write(Object str) {
        if (OSSLog.isEnableLog()) {
            if (null == sContext || null == instance || null == sLogFile) {
                return;
            }
            if (!sLogFile.exists()) {
                this.resetLogFile();
            }
            WriteCall writeCall = new WriteCall(str);
            logService.addExecuteTask(writeCall);
        }
    }

    static {
        sLogSDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        LOG_MAX_SIZE = 0x500000L;
    }

    private static class WriteCall
    implements Runnable {
        private Object mStr;

        public WriteCall(Object mStr) {
            this.mStr = mStr;
        }

        @Override
        public void run() {
            if (sLogFile != null) {
                OSSLogToFileUtils.getInstance();
                long logFileSize = OSSLogToFileUtils.getLogFileSize(sLogFile);
                if (logFileSize > LOG_MAX_SIZE) {
                    OSSLogToFileUtils.getInstance().resetLogFile();
                }
                try {
                    PrintWriter pw = new PrintWriter((Writer)new FileWriter(sLogFile, true), true);
                    if (pw != null) {
                        if (this.mStr instanceof Throwable) {
                            this.printEx(pw);
                        } else {
                            pw.println(OSSLogToFileUtils.getInstance().getFunctionInfo(null) + " - " + this.mStr.toString());
                        }
                        pw.println("------>end of log");
                        pw.println();
                        pw.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        private PrintWriter printEx(PrintWriter pw) {
            pw.println("crash_time\uff1a" + sLogSDF.format(new Date()));
            ((Throwable)this.mStr).printStackTrace(pw);
            return pw;
        }
    }
}

