/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.oss.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Base64;

public class BinaryUtil {
    public static String toBase64String(byte[] binaryData) {
        return new String(Base64.encodeBase64((byte[])binaryData));
    }

    public static byte[] fromBase64String(String base64String) {
        return Base64.decodeBase64((byte[])base64String.getBytes());
    }

    public static byte[] calculateMd5(byte[] binaryData) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("MD5 algorithm not found.");
        }
        messageDigest.update(binaryData);
        return messageDigest.digest();
    }

    public static byte[] calculateMd5(String filePath) throws IOException {
        byte[] md5;
        try {
            int len;
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[8192];
            FileInputStream is = new FileInputStream(new File(filePath));
            while ((len = is.read(buffer)) != -1) {
                digest.update(buffer, 0, len);
            }
            is.close();
            md5 = digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("MD5 algorithm not found.");
        }
        return md5;
    }

    public static String calculateMd5Str(byte[] binaryData) {
        return BinaryUtil.getMd5StrFromBytes(BinaryUtil.calculateMd5(binaryData));
    }

    public static String calculateMd5Str(String filePath) throws IOException {
        return BinaryUtil.getMd5StrFromBytes(BinaryUtil.calculateMd5(filePath));
    }

    public static String calculateBase64Md5(byte[] binaryData) {
        return BinaryUtil.toBase64String(BinaryUtil.calculateMd5(binaryData));
    }

    public static String calculateBase64Md5(String filePath) throws IOException {
        return BinaryUtil.toBase64String(BinaryUtil.calculateMd5(filePath));
    }

    public static String getMd5StrFromBytes(byte[] md5bytes) {
        if (md5bytes == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < md5bytes.length; ++i) {
            sb.append(String.format("%02x", md5bytes[i]));
        }
        return sb.toString();
    }
}

