/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.oss.common.utils;

import java.util.zip.Checksum;

public class CRC64
implements Checksum {
    private static final long POLY = -3932672073523589310L;
    private static final long[][] table;
    private long value = 0L;
    private static final int GF2_DIM = 64;

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public void reset() {
        this.value = 0L;
    }

    @Override
    public void update(int val) {
        byte[] b = new byte[]{(byte)(val & 0xFF)};
        this.update(b, b.length);
    }

    public void update(byte[] b, int len) {
        this.update(b, 0, len);
    }

    @Override
    public void update(byte[] b, int off, int len) {
        this.value ^= 0xFFFFFFFFFFFFFFFFL;
        int idx = off;
        while (len >= 8) {
            this.value = table[7][(int)(this.value & 0xFFL ^ (long)(b[idx] & 0xFF))] ^ table[6][(int)(this.value >>> 8 & 0xFFL ^ (long)(b[idx + 1] & 0xFF))] ^ table[5][(int)(this.value >>> 16 & 0xFFL ^ (long)(b[idx + 2] & 0xFF))] ^ table[4][(int)(this.value >>> 24 & 0xFFL ^ (long)(b[idx + 3] & 0xFF))] ^ table[3][(int)(this.value >>> 32 & 0xFFL ^ (long)(b[idx + 4] & 0xFF))] ^ table[2][(int)(this.value >>> 40 & 0xFFL ^ (long)(b[idx + 5] & 0xFF))] ^ table[1][(int)(this.value >>> 48 & 0xFFL ^ (long)(b[idx + 6] & 0xFF))] ^ table[0][(int)(this.value >>> 56 ^ (long)(b[idx + 7] & 0xFF))];
            idx += 8;
            len -= 8;
        }
        while (len > 0) {
            this.value = table[0][(int)((this.value ^ (long)b[idx]) & 0xFFL)] ^ this.value >>> 8;
            ++idx;
            --len;
        }
        this.value ^= 0xFFFFFFFFFFFFFFFFL;
    }

    private static long gf2MatrixTimes(long[] mat, long vec) {
        long sum = 0L;
        int idx = 0;
        while (vec != 0L) {
            if ((vec & 1L) == 1L) {
                sum ^= mat[idx];
            }
            vec >>>= 1;
            ++idx;
        }
        return sum;
    }

    private static void gf2MatrixSquare(long[] square, long[] mat) {
        for (int n = 0; n < 64; ++n) {
            square[n] = CRC64.gf2MatrixTimes(mat, mat[n]);
        }
    }

    public static long combine(long crcLast, long crcNext, long len2) {
        if (len2 == 0L) {
            return crcLast;
        }
        long[] even = new long[64];
        long[] odd = new long[64];
        odd[0] = -3932672073523589310L;
        long row = 1L;
        for (int n = 1; n < 64; ++n) {
            odd[n] = row;
            row <<= 1;
        }
        CRC64.gf2MatrixSquare(even, odd);
        CRC64.gf2MatrixSquare(odd, even);
        long crc1 = crcLast;
        long crc2 = crcNext;
        do {
            CRC64.gf2MatrixSquare(even, odd);
            if ((len2 & 1L) == 1L) {
                crc1 = CRC64.gf2MatrixTimes(even, crc1);
            }
            if ((len2 >>>= 1) == 0L) break;
            CRC64.gf2MatrixSquare(odd, even);
            if ((len2 & 1L) != 1L) continue;
            crc1 = CRC64.gf2MatrixTimes(odd, crc1);
        } while ((len2 >>>= 1) != 0L);
        return crc1 ^= crc2;
    }

    static {
        int k;
        long crc;
        int n;
        table = new long[8][256];
        for (n = 0; n < 256; ++n) {
            crc = n;
            for (k = 0; k < 8; ++k) {
                if ((crc & 1L) == 1L) {
                    crc = crc >>> 1 ^ 0xC96C5795D7870F42L;
                    continue;
                }
                crc >>>= 1;
            }
            CRC64.table[0][n] = crc;
        }
        for (n = 0; n < 256; ++n) {
            crc = table[0][n];
            for (k = 1; k < 8; ++k) {
                CRC64.table[k][n] = crc = table[0][(int)(crc & 0xFFL)] ^ crc >>> 8;
            }
        }
    }
}

