/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.oss.common.utils;

import com.alibaba.sdk.android.oss.common.OSSLog;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONArray;
import org.json.JSONObject;

public class HttpdnsMini {
    private static final String TAG = "HttpDnsMini";
    private static final String SERVER_IP = "203.107.1.1";
    private static final String ACCOUNT_ID = "181345";
    private static final int MAX_THREAD_NUM = 5;
    private static final int RESOLVE_TIMEOUT_IN_SEC = 10;
    private static final int MAX_HOLD_HOST_NUM = 100;
    private static final int EMPTY_RESULT_HOST_TTL = 30;
    private static HttpdnsMini instance;
    private ConcurrentMap<String, HostObject> hostManager = new ConcurrentHashMap<String, HostObject>();
    private ExecutorService pool = Executors.newFixedThreadPool(5);

    private HttpdnsMini() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpdnsMini getInstance() {
        if (instance != null) return instance;
        Class<HttpdnsMini> clazz = HttpdnsMini.class;
        synchronized (HttpdnsMini.class) {
            if (instance != null) return instance;
            instance = new HttpdnsMini();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String getIpByHostAsync(String hostName) {
        HostObject host = (HostObject)this.hostManager.get(hostName);
        if (host == null || host.isExpired()) {
            OSSLog.logDebug("[httpdnsmini] - refresh host: " + hostName);
            this.pool.submit(new QueryHostTask(hostName));
        }
        if (host != null) {
            return host.isStillAvailable() ? host.getIp() : null;
        }
        return null;
    }

    class QueryHostTask
    implements Callable<String> {
        private String hostName;
        private boolean hasRetryed = false;

        public QueryHostTask(String hostToQuery) {
            this.hostName = hostToQuery;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String call() {
            String chooseServerAddress = HttpdnsMini.SERVER_IP;
            String resolveUrl = "http://" + chooseServerAddress + "/" + HttpdnsMini.ACCOUNT_ID + "/d?host=" + this.hostName;
            InputStream in = null;
            OSSLog.logDebug("[httpdnsmini] - buildUrl: " + resolveUrl);
            try {
                HttpURLConnection conn = (HttpURLConnection)new URL(resolveUrl).openConnection();
                conn.setConnectTimeout(10000);
                conn.setReadTimeout(10000);
                if (conn.getResponseCode() != 200) {
                    OSSLog.logError("[httpdnsmini] - responseCodeNot 200, but: " + conn.getResponseCode());
                } else {
                    String line;
                    in = conn.getInputStream();
                    BufferedReader streamReader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                    StringBuilder sb = new StringBuilder();
                    while ((line = streamReader.readLine()) != null) {
                        sb.append(line);
                    }
                    JSONObject json = new JSONObject(sb.toString());
                    String host = json.getString("host");
                    long ttl = json.getLong("ttl");
                    JSONArray ips = json.getJSONArray("ips");
                    OSSLog.logDebug("[httpdnsmini] - ips:" + ips.toString());
                    if (host != null && ips != null && ips.length() > 0) {
                        if (ttl == 0L) {
                            ttl = 30L;
                        }
                        HostObject hostObject = new HostObject();
                        String ip = ips == null ? null : ips.getString(0);
                        hostObject.setHostName(host);
                        hostObject.setTtl(ttl);
                        hostObject.setIp(ip);
                        hostObject.setQueryTime(System.currentTimeMillis() / 1000L);
                        OSSLog.logDebug("[httpdnsmini] - resolve result:" + hostObject.toString());
                        if (HttpdnsMini.this.hostManager.size() < 100) {
                            HttpdnsMini.this.hostManager.put(this.hostName, hostObject);
                        }
                        String string = ip;
                        return string;
                    }
                }
            }
            catch (Exception e) {
                if (OSSLog.isEnableLog()) {
                    e.printStackTrace();
                    OSSLog.logThrowable2Local(e);
                }
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (!this.hasRetryed) {
                this.hasRetryed = true;
                return this.call();
            }
            return null;
        }
    }

    class HostObject {
        private String hostName;
        private String ip;
        private long ttl;
        private long queryTime;

        HostObject() {
        }

        public String toString() {
            return "[hostName=" + this.getHostName() + ", ip=" + this.ip + ", ttl=" + this.getTtl() + ", queryTime=" + this.queryTime + "]";
        }

        public boolean isExpired() {
            return this.getQueryTime() + this.ttl < System.currentTimeMillis() / 1000L;
        }

        public boolean isStillAvailable() {
            return this.getQueryTime() + this.ttl + 600L > System.currentTimeMillis() / 1000L;
        }

        public String getIp() {
            return this.ip;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public void setHostName(String hostName) {
            this.hostName = hostName;
        }

        public String getHostName() {
            return this.hostName;
        }

        public long getTtl() {
            return this.ttl;
        }

        public void setTtl(long ttl) {
            this.ttl = ttl;
        }

        public long getQueryTime() {
            return this.queryTime;
        }

        public void setQueryTime(long queryTime) {
            this.queryTime = queryTime;
        }
    }
}

