/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.oss.internal;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import com.alibaba.sdk.android.oss.ClientConfiguration;
import com.alibaba.sdk.android.oss.ClientException;
import com.alibaba.sdk.android.oss.ServiceException;
import com.alibaba.sdk.android.oss.callback.OSSCompletedCallback;
import com.alibaba.sdk.android.oss.common.HttpMethod;
import com.alibaba.sdk.android.oss.common.auth.OSSCredentialProvider;
import com.alibaba.sdk.android.oss.common.utils.CRC64;
import com.alibaba.sdk.android.oss.common.utils.DateUtil;
import com.alibaba.sdk.android.oss.common.utils.OSSUtils;
import com.alibaba.sdk.android.oss.common.utils.VersionInfoUtils;
import com.alibaba.sdk.android.oss.exception.InconsistentException;
import com.alibaba.sdk.android.oss.internal.OSSAsyncTask;
import com.alibaba.sdk.android.oss.internal.RequestMessage;
import com.alibaba.sdk.android.oss.internal.ResponseParsers;
import com.alibaba.sdk.android.oss.model.AbortMultipartUploadRequest;
import com.alibaba.sdk.android.oss.model.AbortMultipartUploadResult;
import com.alibaba.sdk.android.oss.model.AppendObjectRequest;
import com.alibaba.sdk.android.oss.model.AppendObjectResult;
import com.alibaba.sdk.android.oss.model.CompleteMultipartUploadRequest;
import com.alibaba.sdk.android.oss.model.CompleteMultipartUploadResult;
import com.alibaba.sdk.android.oss.model.CopyObjectRequest;
import com.alibaba.sdk.android.oss.model.CopyObjectResult;
import com.alibaba.sdk.android.oss.model.CreateBucketRequest;
import com.alibaba.sdk.android.oss.model.CreateBucketResult;
import com.alibaba.sdk.android.oss.model.DeleteBucketRequest;
import com.alibaba.sdk.android.oss.model.DeleteBucketResult;
import com.alibaba.sdk.android.oss.model.DeleteObjectRequest;
import com.alibaba.sdk.android.oss.model.DeleteObjectResult;
import com.alibaba.sdk.android.oss.model.GetBucketACLRequest;
import com.alibaba.sdk.android.oss.model.GetBucketACLResult;
import com.alibaba.sdk.android.oss.model.GetObjectRequest;
import com.alibaba.sdk.android.oss.model.GetObjectResult;
import com.alibaba.sdk.android.oss.model.HeadObjectRequest;
import com.alibaba.sdk.android.oss.model.HeadObjectResult;
import com.alibaba.sdk.android.oss.model.InitiateMultipartUploadRequest;
import com.alibaba.sdk.android.oss.model.InitiateMultipartUploadResult;
import com.alibaba.sdk.android.oss.model.ListObjectsRequest;
import com.alibaba.sdk.android.oss.model.ListObjectsResult;
import com.alibaba.sdk.android.oss.model.ListPartsRequest;
import com.alibaba.sdk.android.oss.model.ListPartsResult;
import com.alibaba.sdk.android.oss.model.OSSRequest;
import com.alibaba.sdk.android.oss.model.OSSResult;
import com.alibaba.sdk.android.oss.model.PartETag;
import com.alibaba.sdk.android.oss.model.PutObjectRequest;
import com.alibaba.sdk.android.oss.model.PutObjectResult;
import com.alibaba.sdk.android.oss.model.UploadPartRequest;
import com.alibaba.sdk.android.oss.model.UploadPartResult;
import com.alibaba.sdk.android.oss.network.ExecutionContext;
import com.alibaba.sdk.android.oss.network.OSSRequestTask;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import okhttp3.Dispatcher;
import okhttp3.OkHttpClient;

public class InternalRequestOperation {
    private volatile URI endpoint;
    private OkHttpClient innerClient;
    private Context applicationContext;
    private OSSCredentialProvider credentialProvider;
    private int maxRetryCount = 2;
    private ClientConfiguration conf;
    private static final int LIST_PART_MAX_RETURNS = 1000;
    private static final int MAX_PART_NUMBER = 10000;
    private static ExecutorService executorService = Executors.newFixedThreadPool(5, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "oss-android-api-thread");
        }
    });

    public InternalRequestOperation(Context context, final URI endpoint, OSSCredentialProvider credentialProvider, ClientConfiguration conf) {
        this.applicationContext = context;
        this.endpoint = endpoint;
        this.credentialProvider = credentialProvider;
        this.conf = conf;
        OkHttpClient.Builder builder = new OkHttpClient.Builder().followRedirects(false).followSslRedirects(false).retryOnConnectionFailure(false).cache(null).hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return HttpsURLConnection.getDefaultHostnameVerifier().verify(endpoint.getHost(), session);
            }
        });
        if (conf != null) {
            Dispatcher dispatcher = new Dispatcher();
            dispatcher.setMaxRequests(conf.getMaxConcurrentRequest());
            builder.connectTimeout((long)conf.getConnectionTimeout(), TimeUnit.MILLISECONDS).readTimeout((long)conf.getSocketTimeout(), TimeUnit.MILLISECONDS).writeTimeout((long)conf.getSocketTimeout(), TimeUnit.MILLISECONDS).dispatcher(dispatcher);
            if (conf.getProxyHost() != null && conf.getProxyPort() != 0) {
                builder.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(conf.getProxyHost(), conf.getProxyPort())));
            }
            this.maxRetryCount = conf.getMaxErrorRetry();
        }
        this.innerClient = builder.build();
    }

    public PutObjectResult syncPutObject(PutObjectRequest request) throws ClientException, ServiceException {
        PutObjectResult result = this.putObject(request, null).getResult();
        this.checkCRC64(request, result);
        return result;
    }

    public OSSAsyncTask<PutObjectResult> putObject(PutObjectRequest request, final OSSCompletedCallback<PutObjectRequest, PutObjectResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.PUT);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setObjectKey(request.getObjectKey());
        if (request.getUploadData() != null) {
            requestMessage.setUploadData(request.getUploadData());
        }
        if (request.getUploadFilePath() != null) {
            requestMessage.setUploadFilePath(request.getUploadFilePath());
        }
        if (request.getCallbackParam() != null) {
            requestMessage.getHeaders().put("x-oss-callback", OSSUtils.populateMapToBase64JsonString(request.getCallbackParam()));
        }
        if (request.getCallbackVars() != null) {
            requestMessage.getHeaders().put("x-oss-callback-var", OSSUtils.populateMapToBase64JsonString(request.getCallbackVars()));
        }
        OSSUtils.populateRequestMetadata(requestMessage.getHeaders(), request.getMetadata());
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<PutObjectRequest, PutObjectResult> executionContext = new ExecutionContext<PutObjectRequest, PutObjectResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(new OSSCompletedCallback<PutObjectRequest, PutObjectResult>(){

                @Override
                public void onSuccess(PutObjectRequest request, PutObjectResult result) {
                    InternalRequestOperation.this.checkCRC64(request, result, completedCallback);
                }

                @Override
                public void onFailure(PutObjectRequest request, ClientException clientException, ServiceException serviceException) {
                    completedCallback.onFailure(request, clientException, serviceException);
                }
            });
        }
        if (request.getRetryCallback() != null) {
            executionContext.setRetryCallback(request.getRetryCallback());
        }
        executionContext.setProgressCallback(request.getProgressCallback());
        ResponseParsers.PutObjectResponseParser parser = new ResponseParsers.PutObjectResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<CreateBucketResult> createBucket(CreateBucketRequest request, OSSCompletedCallback<CreateBucketRequest, CreateBucketResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.PUT);
        requestMessage.setBucketName(request.getBucketName());
        if (request.getBucketACL() != null) {
            requestMessage.getHeaders().put("x-oss-acl", request.getBucketACL().toString());
        }
        try {
            requestMessage.createBucketRequestBodyMarshall(request.getLocationConstraint());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<CreateBucketRequest, CreateBucketResult> executionContext = new ExecutionContext<CreateBucketRequest, CreateBucketResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.CreateBucketResponseParser parser = new ResponseParsers.CreateBucketResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<DeleteBucketResult> deleteBucket(DeleteBucketRequest request, OSSCompletedCallback<DeleteBucketRequest, DeleteBucketResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.DELETE);
        requestMessage.setBucketName(request.getBucketName());
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<DeleteBucketRequest, DeleteBucketResult> executionContext = new ExecutionContext<DeleteBucketRequest, DeleteBucketResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.DeleteBucketResponseParser parser = new ResponseParsers.DeleteBucketResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<GetBucketACLResult> getBucketACL(GetBucketACLRequest request, OSSCompletedCallback<GetBucketACLRequest, GetBucketACLResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        LinkedHashMap<String, String> query = new LinkedHashMap<String, String>();
        query.put("acl", "");
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.GET);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setParameters(query);
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<GetBucketACLRequest, GetBucketACLResult> executionContext = new ExecutionContext<GetBucketACLRequest, GetBucketACLResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.GetBucketACLResponseParser parser = new ResponseParsers.GetBucketACLResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(executorService.submit(callable), executionContext);
    }

    public AppendObjectResult syncAppendObject(AppendObjectRequest request) throws ClientException, ServiceException {
        boolean checkCRC;
        AppendObjectResult result = this.appendObject(request, null).getResult();
        boolean bl = checkCRC = request.getCRC64() == OSSRequest.CRC64Config.YES;
        if (request.getInitCRC64() != null && checkCRC) {
            result.setClientCRC(CRC64.combine(request.getInitCRC64(), result.getClientCRC(), result.getNextPosition() - request.getPosition()));
        }
        this.checkCRC64(request, result);
        return result;
    }

    public OSSAsyncTask<AppendObjectResult> appendObject(AppendObjectRequest request, final OSSCompletedCallback<AppendObjectRequest, AppendObjectResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.POST);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setObjectKey(request.getObjectKey());
        if (request.getUploadData() != null) {
            requestMessage.setUploadData(request.getUploadData());
        }
        if (request.getUploadFilePath() != null) {
            requestMessage.setUploadFilePath(request.getUploadFilePath());
        }
        requestMessage.getParameters().put("append", "");
        requestMessage.getParameters().put("position", String.valueOf(request.getPosition()));
        OSSUtils.populateRequestMetadata(requestMessage.getHeaders(), request.getMetadata());
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<AppendObjectRequest, AppendObjectResult> executionContext = new ExecutionContext<AppendObjectRequest, AppendObjectResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(new OSSCompletedCallback<AppendObjectRequest, AppendObjectResult>(){

                @Override
                public void onSuccess(AppendObjectRequest request, AppendObjectResult result) {
                    boolean checkCRC;
                    boolean bl = checkCRC = request.getCRC64() == OSSRequest.CRC64Config.YES;
                    if (request.getInitCRC64() != null && checkCRC) {
                        result.setClientCRC(CRC64.combine(request.getInitCRC64(), result.getClientCRC(), result.getNextPosition() - request.getPosition()));
                    }
                    InternalRequestOperation.this.checkCRC64(request, result, completedCallback);
                }

                @Override
                public void onFailure(AppendObjectRequest request, ClientException clientException, ServiceException serviceException) {
                    completedCallback.onFailure(request, clientException, serviceException);
                }
            });
        }
        executionContext.setProgressCallback(request.getProgressCallback());
        ResponseParsers.AppendObjectResponseParser parser = new ResponseParsers.AppendObjectResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<HeadObjectResult> headObject(HeadObjectRequest request, OSSCompletedCallback<HeadObjectRequest, HeadObjectResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.HEAD);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setObjectKey(request.getObjectKey());
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<HeadObjectRequest, HeadObjectResult> executionContext = new ExecutionContext<HeadObjectRequest, HeadObjectResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.HeadObjectResponseParser parser = new ResponseParsers.HeadObjectResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<GetObjectResult> getObject(GetObjectRequest request, OSSCompletedCallback<GetObjectRequest, GetObjectResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.GET);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setObjectKey(request.getObjectKey());
        if (request.getRange() != null) {
            requestMessage.getHeaders().put("Range", request.getRange().toString());
        }
        if (request.getxOssProcess() != null) {
            requestMessage.getParameters().put("x-oss-process", request.getxOssProcess());
        }
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<GetObjectRequest, GetObjectResult> executionContext = new ExecutionContext<GetObjectRequest, GetObjectResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        executionContext.setProgressCallback(request.getProgressListener());
        ResponseParsers.GetObjectResponseParser parser = new ResponseParsers.GetObjectResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<CopyObjectResult> copyObject(CopyObjectRequest request, OSSCompletedCallback<CopyObjectRequest, CopyObjectResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.PUT);
        requestMessage.setBucketName(request.getDestinationBucketName());
        requestMessage.setObjectKey(request.getDestinationKey());
        OSSUtils.populateCopyObjectHeaders(request, requestMessage.getHeaders());
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<CopyObjectRequest, CopyObjectResult> executionContext = new ExecutionContext<CopyObjectRequest, CopyObjectResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.CopyObjectResponseParser parser = new ResponseParsers.CopyObjectResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<DeleteObjectResult> deleteObject(DeleteObjectRequest request, OSSCompletedCallback<DeleteObjectRequest, DeleteObjectResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.DELETE);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setObjectKey(request.getObjectKey());
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<DeleteObjectRequest, DeleteObjectResult> executionContext = new ExecutionContext<DeleteObjectRequest, DeleteObjectResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.DeleteObjectResponseParser parser = new ResponseParsers.DeleteObjectResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<ListObjectsResult> listObjects(ListObjectsRequest request, OSSCompletedCallback<ListObjectsRequest, ListObjectsResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.GET);
        requestMessage.setBucketName(request.getBucketName());
        this.canonicalizeRequestMessage(requestMessage, request);
        OSSUtils.populateListObjectsRequestParameters(request, requestMessage.getParameters());
        ExecutionContext<ListObjectsRequest, ListObjectsResult> executionContext = new ExecutionContext<ListObjectsRequest, ListObjectsResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.ListObjectsResponseParser parser = new ResponseParsers.ListObjectsResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<InitiateMultipartUploadResult> initMultipartUpload(InitiateMultipartUploadRequest request, OSSCompletedCallback<InitiateMultipartUploadRequest, InitiateMultipartUploadResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.POST);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setObjectKey(request.getObjectKey());
        requestMessage.getParameters().put("uploads", "");
        OSSUtils.populateRequestMetadata(requestMessage.getHeaders(), request.getMetadata());
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<InitiateMultipartUploadRequest, InitiateMultipartUploadResult> executionContext = new ExecutionContext<InitiateMultipartUploadRequest, InitiateMultipartUploadResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.InitMultipartResponseParser parser = new ResponseParsers.InitMultipartResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(executorService.submit(callable), executionContext);
    }

    public UploadPartResult syncUploadPart(UploadPartRequest request) throws ClientException, ServiceException {
        UploadPartResult result = this.uploadPart(request, null).getResult();
        this.checkCRC64(request, result);
        return result;
    }

    public OSSAsyncTask<UploadPartResult> uploadPart(UploadPartRequest request, final OSSCompletedCallback<UploadPartRequest, UploadPartResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.PUT);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setObjectKey(request.getObjectKey());
        requestMessage.getParameters().put("uploadId", request.getUploadId());
        requestMessage.getParameters().put("partNumber", String.valueOf(request.getPartNumber()));
        requestMessage.setUploadData(request.getPartContent());
        if (request.getMd5Digest() != null) {
            requestMessage.getHeaders().put("Content-MD5", request.getMd5Digest());
        }
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<UploadPartRequest, UploadPartResult> executionContext = new ExecutionContext<UploadPartRequest, UploadPartResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(new OSSCompletedCallback<UploadPartRequest, UploadPartResult>(){

                @Override
                public void onSuccess(UploadPartRequest request, UploadPartResult result) {
                    InternalRequestOperation.this.checkCRC64(request, result, completedCallback);
                }

                @Override
                public void onFailure(UploadPartRequest request, ClientException clientException, ServiceException serviceException) {
                    completedCallback.onFailure(request, clientException, serviceException);
                }
            });
        }
        executionContext.setProgressCallback(request.getProgressCallback());
        ResponseParsers.UploadPartResponseParser parser = new ResponseParsers.UploadPartResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(executorService.submit(callable), executionContext);
    }

    public CompleteMultipartUploadResult syncCompleteMultipartUpload(CompleteMultipartUploadRequest request) throws ClientException, ServiceException {
        CompleteMultipartUploadResult result = this.completeMultipartUpload(request, null).getResult();
        if (result.getServerCRC() != null) {
            long crc64 = this.calcObjectCRCFromParts(request.getPartETags());
            result.setClientCRC(crc64);
        }
        this.checkCRC64(request, result);
        return result;
    }

    public OSSAsyncTask<CompleteMultipartUploadResult> completeMultipartUpload(CompleteMultipartUploadRequest request, final OSSCompletedCallback<CompleteMultipartUploadRequest, CompleteMultipartUploadResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.POST);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setObjectKey(request.getObjectKey());
        requestMessage.setStringBody(OSSUtils.buildXMLFromPartEtagList(request.getPartETags()));
        requestMessage.getParameters().put("uploadId", request.getUploadId());
        if (request.getCallbackParam() != null) {
            requestMessage.getHeaders().put("x-oss-callback", OSSUtils.populateMapToBase64JsonString(request.getCallbackParam()));
        }
        if (request.getCallbackVars() != null) {
            requestMessage.getHeaders().put("x-oss-callback-var", OSSUtils.populateMapToBase64JsonString(request.getCallbackVars()));
        }
        OSSUtils.populateRequestMetadata(requestMessage.getHeaders(), request.getMetadata());
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<CompleteMultipartUploadRequest, CompleteMultipartUploadResult> executionContext = new ExecutionContext<CompleteMultipartUploadRequest, CompleteMultipartUploadResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(new OSSCompletedCallback<CompleteMultipartUploadRequest, CompleteMultipartUploadResult>(){

                @Override
                public void onSuccess(CompleteMultipartUploadRequest request, CompleteMultipartUploadResult result) {
                    if (result.getServerCRC() != null) {
                        long crc64 = InternalRequestOperation.this.calcObjectCRCFromParts(request.getPartETags());
                        result.setClientCRC(crc64);
                    }
                    InternalRequestOperation.this.checkCRC64(request, result, completedCallback);
                }

                @Override
                public void onFailure(CompleteMultipartUploadRequest request, ClientException clientException, ServiceException serviceException) {
                    completedCallback.onFailure(request, clientException, serviceException);
                }
            });
        }
        ResponseParsers.CompleteMultipartUploadResponseParser parser = new ResponseParsers.CompleteMultipartUploadResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<AbortMultipartUploadResult> abortMultipartUpload(AbortMultipartUploadRequest request, OSSCompletedCallback<AbortMultipartUploadRequest, AbortMultipartUploadResult> completedCallback) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.DELETE);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setObjectKey(request.getObjectKey());
        requestMessage.getParameters().put("uploadId", request.getUploadId());
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<AbortMultipartUploadRequest, AbortMultipartUploadResult> executionContext = new ExecutionContext<AbortMultipartUploadRequest, AbortMultipartUploadResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.AbortMultipartUploadResponseParser parser = new ResponseParsers.AbortMultipartUploadResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(executorService.submit(callable), executionContext);
    }

    public OSSAsyncTask<ListPartsResult> listParts(ListPartsRequest request, OSSCompletedCallback<ListPartsRequest, ListPartsResult> completedCallback) {
        Integer partNumberMarker;
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setIsAuthorizationRequired(request.isAuthorizationRequired());
        requestMessage.setEndpoint(this.endpoint);
        requestMessage.setMethod(HttpMethod.GET);
        requestMessage.setBucketName(request.getBucketName());
        requestMessage.setObjectKey(request.getObjectKey());
        requestMessage.getParameters().put("uploadId", request.getUploadId());
        Integer maxParts = request.getMaxParts();
        if (maxParts != null) {
            if (!OSSUtils.checkParamRange(maxParts.intValue(), 0L, true, 1000L, true)) {
                throw new IllegalArgumentException("MaxPartsOutOfRange: 1000");
            }
            requestMessage.getParameters().put("max-parts", maxParts.toString());
        }
        if ((partNumberMarker = request.getPartNumberMarker()) != null) {
            if (!OSSUtils.checkParamRange(partNumberMarker.intValue(), 0L, false, 10000L, true)) {
                throw new IllegalArgumentException("PartNumberMarkerOutOfRange: 10000");
            }
            requestMessage.getParameters().put("part-number-marker", partNumberMarker.toString());
        }
        this.canonicalizeRequestMessage(requestMessage, request);
        ExecutionContext<ListPartsRequest, ListPartsResult> executionContext = new ExecutionContext<ListPartsRequest, ListPartsResult>(this.getInnerClient(), request, this.applicationContext);
        if (completedCallback != null) {
            executionContext.setCompletedCallback(completedCallback);
        }
        ResponseParsers.ListPartsResponseParser parser = new ResponseParsers.ListPartsResponseParser();
        OSSRequestTask callable = new OSSRequestTask(requestMessage, parser, executionContext, this.maxRetryCount);
        return OSSAsyncTask.wrapRequestTask(executorService.submit(callable), executionContext);
    }

    private boolean checkIfHttpDnsAvailable(boolean httpDnsEnable) {
        if (httpDnsEnable) {
            if (this.applicationContext == null) {
                return false;
            }
            boolean IS_ICS_OR_LATER = Build.VERSION.SDK_INT >= 14;
            String proxyHost = IS_ICS_OR_LATER ? System.getProperty("http.proxyHost") : android.net.Proxy.getHost((Context)this.applicationContext);
            String confProxyHost = this.conf.getProxyHost();
            if (!TextUtils.isEmpty((CharSequence)confProxyHost)) {
                proxyHost = confProxyHost;
            }
            return TextUtils.isEmpty((CharSequence)proxyHost);
        }
        return false;
    }

    public OkHttpClient getInnerClient() {
        return this.innerClient;
    }

    private void canonicalizeRequestMessage(RequestMessage message, OSSRequest request) {
        Map header = message.getHeaders();
        if (header.get("Date") == null) {
            header.put("Date", DateUtil.currentFixedSkewedTimeInRFC822Format());
        }
        if ((message.getMethod() == HttpMethod.POST || message.getMethod() == HttpMethod.PUT) && OSSUtils.isEmptyString((String)header.get("Content-Type"))) {
            String determineContentType = OSSUtils.determineContentType(null, message.getUploadFilePath(), message.getObjectKey());
            header.put("Content-Type", determineContentType);
        }
        message.setHttpDnsEnable(this.checkIfHttpDnsAvailable(this.conf.isHttpDnsEnable()));
        message.setCredentialProvider(this.credentialProvider);
        message.getHeaders().put("User-Agent", VersionInfoUtils.getUserAgent(this.conf.getCustomUserMark()));
        if (message.getHeaders().containsKey("Range") || message.getParameters().containsKey("x-oss-process")) {
            message.setCheckCRC64(false);
        }
        message.setIsInCustomCnameExcludeList(OSSUtils.isInCustomCnameExcludeList(this.endpoint.getHost(), this.conf.getCustomCnameExcludeList()));
        boolean checkCRC64 = request.getCRC64() != OSSRequest.CRC64Config.NULL ? request.getCRC64() == OSSRequest.CRC64Config.YES : this.conf.isCheckCRC64();
        message.setCheckCRC64(checkCRC64);
        request.setCRC64(checkCRC64 ? OSSRequest.CRC64Config.YES : OSSRequest.CRC64Config.NO);
    }

    public void setCredentialProvider(OSSCredentialProvider credentialProvider) {
        this.credentialProvider = credentialProvider;
    }

    private <Request extends OSSRequest, Result extends OSSResult> void checkCRC64(Request request, Result result) throws ClientException {
        if (request.getCRC64() == OSSRequest.CRC64Config.YES) {
            try {
                OSSUtils.checkChecksum(result.getClientCRC(), result.getServerCRC(), result.getRequestId());
            }
            catch (InconsistentException e) {
                throw new ClientException(e.getMessage(), e);
            }
        }
    }

    private <Request extends OSSRequest, Result extends OSSResult> void checkCRC64(Request request, Result result, OSSCompletedCallback<Request, Result> completedCallback) {
        block3: {
            try {
                this.checkCRC64(request, result);
                if (completedCallback != null) {
                    completedCallback.onSuccess(request, result);
                }
            }
            catch (ClientException e) {
                if (completedCallback == null) break block3;
                completedCallback.onFailure(request, e, null);
            }
        }
    }

    private long calcObjectCRCFromParts(List<PartETag> partETags) {
        long crc = 0L;
        for (PartETag partETag : partETags) {
            if (partETag.getCRC64() == 0L || partETag.getPartSize() <= 0L) {
                return 0L;
            }
            crc = CRC64.combine(crc, partETag.getCRC64(), partETag.getPartSize());
        }
        return crc;
    }

    public Context getApplicationContext() {
        return this.applicationContext;
    }

    public ClientConfiguration getConf() {
        return this.conf;
    }
}

