/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.oss.internal;

import com.alibaba.sdk.android.oss.ClientException;
import com.alibaba.sdk.android.oss.ServiceException;
import com.alibaba.sdk.android.oss.callback.OSSCompletedCallback;
import com.alibaba.sdk.android.oss.internal.BaseMultipartUploadTask;
import com.alibaba.sdk.android.oss.internal.InternalRequestOperation;
import com.alibaba.sdk.android.oss.model.AbortMultipartUploadRequest;
import com.alibaba.sdk.android.oss.model.CompleteMultipartUploadResult;
import com.alibaba.sdk.android.oss.model.InitiateMultipartUploadRequest;
import com.alibaba.sdk.android.oss.model.InitiateMultipartUploadResult;
import com.alibaba.sdk.android.oss.model.MultipartUploadRequest;
import com.alibaba.sdk.android.oss.network.ExecutionContext;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;

public class MultipartUploadTask
extends BaseMultipartUploadTask<MultipartUploadRequest, CompleteMultipartUploadResult>
implements Callable<CompleteMultipartUploadResult> {
    public MultipartUploadTask(InternalRequestOperation operation, MultipartUploadRequest request, OSSCompletedCallback<MultipartUploadRequest, CompleteMultipartUploadResult> completedCallback, ExecutionContext context) {
        super(operation, request, completedCallback, context);
    }

    @Override
    protected void initMultipartUploadId() throws ClientException, ServiceException {
        InitiateMultipartUploadRequest init = new InitiateMultipartUploadRequest(this.mRequest.getBucketName(), this.mRequest.getObjectKey(), this.mRequest.getMetadata());
        InitiateMultipartUploadResult initResult = this.mApiOperation.initMultipartUpload(init, null).getResult();
        this.mUploadId = initResult.getUploadId();
        this.mRequest.setUploadId(this.mUploadId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CompleteMultipartUploadResult doMultipartUpload() throws IOException, ServiceException, ClientException, InterruptedException {
        this.checkCancel();
        this.mUploadFile = new File(this.mRequest.getUploadFilePath());
        this.mFileLength = this.mUploadFile.length();
        if (this.mFileLength == 0L) {
            throw new ClientException("file length must not be 0");
        }
        int[] partAttr = new int[2];
        this.checkPartSize(partAttr);
        int readByte = partAttr[0];
        final int partNumber = partAttr[1];
        int currentLength = 0;
        for (int i = 0; i < partNumber; ++i) {
            this.checkException();
            if (this.mPoolExecutor == null) continue;
            if (i == partNumber - 1) {
                readByte = (int)Math.min((long)readByte, this.mFileLength - (long)currentLength);
            }
            final int byteCount = readByte;
            final int readIndex = i;
            currentLength += byteCount;
            this.mPoolExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    MultipartUploadTask.this.uploadPart(readIndex, byteCount, partNumber);
                }
            });
        }
        if (this.checkWaitCondition(partNumber)) {
            Object i = this.mLock;
            synchronized (i) {
                this.mLock.wait();
            }
        }
        if (this.mUploadException != null) {
            this.abortThisUpload();
        }
        this.checkException();
        CompleteMultipartUploadResult completeResult = this.completeMultipartUploadResult();
        this.releasePool();
        return completeResult;
    }

    @Override
    protected void abortThisUpload() {
        if (this.mUploadId != null) {
            AbortMultipartUploadRequest abort = new AbortMultipartUploadRequest(this.mRequest.getBucketName(), this.mRequest.getObjectKey(), this.mUploadId);
            this.mApiOperation.abortMultipartUpload(abort, null).waitUntilFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processException(Exception e) {
        Object object = this.mLock;
        synchronized (object) {
            ++this.mPartExceptionCount;
            if (this.mUploadException == null) {
                this.mUploadException = e;
                this.mLock.notify();
            }
        }
    }

    @Override
    protected void preUploadPart(int readIndex, int byteCount, int partNumber) throws Exception {
        this.checkException();
    }
}

